/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import io.papermc.paper.scoreboard.numbers.NumberFormat;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_8646;
import net.minecraft.class_9022;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.scoreboard.CardboardCriteria;
import org.bukkit.craftbukkit.scoreboard.CardboardScore;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboard;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboardComponent;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboardTranslations;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardboardObjective
extends CardboardScoreboardComponent
implements Objective {
    private final class_266 objective;
    private final CardboardCriteria criteria;

    CardboardObjective(CardboardScoreboard scoreboard, class_266 objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CardboardCriteria.getFromNMS(objective);
    }

    class_266 getHandle() {
        return this.objective;
    }

    public String getName() throws IllegalStateException {
        this.checkState();
        return this.objective.method_1113();
    }

    public String getDisplayName() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.objective.method_1114());
    }

    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(displayName, "Display name cannot be null");
        Validate.isTrue(displayName.length() <= 128, "Display name '" + displayName + "' is longer than the limit of 128 characters");
        this.checkState();
        this.objective.method_1121(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getCriteria() throws IllegalStateException {
        this.checkState();
        return this.criteria.bukkitName;
    }

    public boolean isModifiable() throws IllegalStateException {
        this.checkState();
        return !this.criteria.criteria.method_1226();
    }

    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        class_269 board = scoreboard.board;
        class_266 objective = this.objective;
        for (class_8646 nmsSlot : class_8646.values()) {
            if (board.method_1189(nmsSlot) != objective) continue;
            board.method_1158(nmsSlot, null);
        }
        if (slot != null) {
            class_8646 nmsSlot = CardboardScoreboardTranslations.fromBukkitSlot(slot);
            board.method_1158(nmsSlot, objective);
        }
    }

    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        class_269 board = scoreboard.board;
        class_266 objective = this.objective;
        for (class_8646 slot : class_8646.values()) {
            if (board.method_1189(slot) != objective) continue;
            return CardboardScoreboardTranslations.toBukkitSlot(slot);
        }
        return null;
    }

    public void setRenderType(RenderType renderType) throws IllegalStateException {
        Validate.notNull(renderType, "RenderType cannot be null");
        this.checkState();
        this.objective.method_1115(CardboardScoreboardTranslations.fromBukkitRender(renderType));
    }

    public RenderType getRenderType() throws IllegalStateException {
        this.checkState();
        return CardboardScoreboardTranslations.toBukkitRender(this.objective.method_1118());
    }

    public Score getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull(player, "Player cannot be null");
        this.checkState();
        return new CardboardScore(this, () -> ((OfflinePlayer)player).getName());
    }

    public Score getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull(entry, "Entry cannot be null");
        Validate.isTrue(entry.length() <= 40, "Score '" + entry + "' is longer than the limit of 40 characters");
        this.checkState();
        return new CardboardScore(this, () -> entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        scoreboard.board.method_1194(this.objective);
    }

    @Override
    public CardboardScoreboard checkState() throws IllegalStateException {
        if (this.getScoreboard().board.method_1170(this.objective.method_1113()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CardboardObjective other = (CardboardObjective)obj;
        return Objects.equals(this.objective, other.objective);
    }

    @NotNull
    public Component displayName() throws IllegalStateException {
        CardboardScoreboard scoreboard = this.checkState();
        return CardboardAdventure.asAdventure(this.objective.method_1114());
    }

    public void displayName(@Nullable Component arg0) throws IllegalStateException, IllegalArgumentException {
        this.setDisplayName(arg0.toString());
    }

    @NotNull
    public Score getScoreFor(@NotNull Entity arg0) throws IllegalArgumentException, IllegalStateException {
        return null;
    }

    @NotNull
    public Criteria getTrackedCriteria() throws IllegalStateException {
        this.checkState();
        return this.criteria;
    }

    public boolean willAutoUpdateDisplay() {
        this.checkState();
        return this.objective.method_55383();
    }

    public void setAutoUpdateDisplay(boolean autoUpdateDisplay) {
        this.checkState();
        this.objective.method_55381(autoUpdateDisplay);
    }

    @Nullable
    public NumberFormat numberFormat() {
        this.checkState();
        class_9022 vanilla = this.objective.method_55384();
        if (vanilla == null) {
            return null;
        }
        return null;
    }

    public void numberFormat(@Nullable NumberFormat format) {
    }
}

