/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered;

import com.destroystokyo.paper.Metrics_Cardboard;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.plugin.Plugin;

public class PaperMetrics {
    public static void startMetrics_Cardboard() {
        File configFile = new File(new File(new File("plugins"), "bStats"), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration(configFile);
        if (!config.isSet("serverUuid")) {
            config.addDefault("enabled", true);
            config.addDefault("serverUuid", UUID.randomUUID().toString());
            config.addDefault("logFailedRequests", false);
            config.options().header("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)").copyDefaults(true);
            try {
                config.save(configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String serverUUID = config.getString("serverUuid");
        boolean logFailedRequests = config.getBoolean("logFailedRequests", false);
        if (config.getBoolean("enabled", true)) {
            Metrics_Cardboard Metrics_Cardboard2 = new Metrics_Cardboard("Paper", serverUUID, logFailedRequests, Bukkit.getLogger());
            Metrics_Cardboard2.addCustomChart(new Metrics_Cardboard.SimplePie("minecraft_version", () -> {
                String minecraftVersion = Bukkit.getVersion();
                minecraftVersion = minecraftVersion.substring(minecraftVersion.indexOf("MC: ") + 4, minecraftVersion.length() - 1);
                return minecraftVersion;
            }));
            Metrics_Cardboard2.addCustomChart(new Metrics_Cardboard.SingleLineChart("players", () -> Bukkit.getOnlinePlayers().size()));
            Metrics_Cardboard2.addCustomChart(new Metrics_Cardboard.SimplePie("online_mode", () -> Bukkit.getOnlineMode() ? "online" : "offline"));
            Metrics_Cardboard2.addCustomChart(new Metrics_Cardboard.SimplePie("paper_version", () -> "git-Cardboard-" + CraftServer.server.method_3827()));
            Metrics_Cardboard2.addCustomChart(new Metrics_Cardboard.DrilldownPie("java_version", () -> {
                String release;
                HashMap map = new HashMap();
                String javaVersion = System.getProperty("java.version");
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(javaVersion, 1);
                String majorVersion = javaVersion.split("\\.")[0];
                int indexOf = javaVersion.lastIndexOf(46);
                if (majorVersion.equals("1")) {
                    release = "Java " + javaVersion.substring(0, indexOf);
                } else {
                    Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                    if (versionMatcher.find()) {
                        majorVersion = versionMatcher.group(0);
                    }
                    release = "Java " + majorVersion;
                }
                map.put((CallSite)((Object)release), entry);
                return map;
            }));
            Metrics_Cardboard2.addCustomChart(new Metrics_Cardboard.DrilldownPie("legacy_plugins", () -> {
                HashMap map = new HashMap();
                int legacy = 0;
                for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                    if (!CraftMagicNumbers.isLegacy(plugin.getDescription())) continue;
                    ++legacy;
                }
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(String.valueOf(legacy), 1);
                if (legacy == 0) {
                    map.put("0 \ud83d\ude0e", entry);
                } else if (legacy <= 5) {
                    map.put("1-5", entry);
                } else if (legacy <= 10) {
                    map.put("6-10", entry);
                } else if (legacy <= 25) {
                    map.put("11-25", entry);
                } else if (legacy <= 50) {
                    map.put("26-50", entry);
                } else {
                    map.put("50 \ud83d\ude2d", entry);
                }
                return map;
            }));
        }
    }
}

