/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import me.isaiah.common.cmixin.IMixinBlockEntity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_1767;
import net.minecraft.class_2185;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2573;
import net.minecraft.class_9307;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;

public class CardboardBanner
extends CardboardBlockEntityState<class_2573>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CardboardBanner(World world, class_2573 tileEntity) {
        super(world, tileEntity);
    }

    protected CardboardBanner(CardboardBanner state, Location location) {
        super(state, location);
    }

    @Override
    public CardboardBanner copy() {
        return new CardboardBanner(this, null);
    }

    @Override
    public CardboardBanner copy(Location location) {
        return new CardboardBanner(this, location);
    }

    @Override
    public void load(class_2573 banner) {
        super.load(banner);
        this.base = DyeColor.getByWoolData((byte)((byte)((class_2185)this.data.method_26204()).method_9303().method_7789()));
        this.patterns = new ArrayList<Pattern>();
        if (banner.method_58122() != null) {
            for (int i = 0; i < banner.method_58122().comp_2428().size(); ++i) {
                class_9307.class_9308 p = (class_9307.class_9308)banner.method_58122().comp_2428().get(i);
                this.patterns.add(new Pattern(DyeColor.getByWoolData((byte)((byte)p.comp_2430().method_7789())), PatternType.getByIdentifier((String)p.comp_2429().method_55840())));
            }
        }
    }

    public DyeColor getBaseColor() {
        return this.base;
    }

    public void setBaseColor(DyeColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.base = color;
    }

    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    public Pattern getPattern(int i) {
        return this.patterns.get(i);
    }

    public Pattern removePattern(int i) {
        return this.patterns.remove(i);
    }

    public void setPattern(int i, Pattern pattern) {
        this.patterns.set(i, pattern);
    }

    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public void applyTo(class_2573 banner) {
        super.applyTo(banner);
        banner.field_11774 = class_1767.method_7791((int)this.base.getWoolData());
        class_2487 bannerNbt = new class_2487();
        class_2499 newPatterns = new class_2499();
        for (Pattern p : this.patterns) {
            class_2487 compound = new class_2487();
            compound.method_10569("Color", (int)p.getColor().getWoolData());
            compound.method_10582("Pattern", p.getPattern().getIdentifier());
            newPatterns.add((Object)compound);
        }
        bannerNbt.method_10566("Patterns", (class_2520)newPatterns);
        IMixinBlockEntity ic = (IMixinBlockEntity)banner;
        ic.IC$read_nbt(bannerNbt);
    }

    public Component customName() {
        return Component.text((String)((class_2573)this.getSnapshot()).method_5797().getString());
    }

    public void customName(Component customName) {
        CardboardBanner.set_name((class_2573)this.getSnapshot(), class_2561.method_30163((String)customName.toString()));
    }

    public static void set_name(class_2573 b, class_2561 name) {
        b.field_11772 = name;
    }

    public String getCustomName() {
        return (String)LegacyComponentSerializer.legacySection().serializeOrNull(this.customName());
    }

    public void setCustomName(String name) {
        this.customName(LegacyComponentSerializer.legacySection().deserializeOrNull((Object)name));
    }
}

