/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.block;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import me.isaiah.common.cmixin.IMixinSkullBlockEntity;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.jetbrains.annotations.Nullable;

public class CardboardSkull
extends CardboardBlockEntityState<class_2631>
implements Skull {
    private static final int MAX_OWNER_LENGTH = 16;
    private GameProfile profile;

    public CardboardSkull(World world, class_2631 tileEntity) {
        super(world, tileEntity);
    }

    protected CardboardSkull(CardboardSkull state, Location location) {
        super(state, location);
    }

    @Override
    public CardboardSkull copy() {
        return new CardboardSkull(this, null);
    }

    @Override
    public CardboardSkull copy(Location location) {
        return new CardboardSkull(this, location);
    }

    @Override
    public void load(class_2631 skull) {
        super.load(skull);
        IMixinSkullBlockEntity ic = (IMixinSkullBlockEntity)this;
        this.profile = ic.IC$get_game_profile();
    }

    static int getSkullType(SkullType type) {
        switch (type) {
            default: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
            case PLAYER: {
                return 3;
            }
            case CREEPER: {
                return 4;
            }
            case DRAGON: 
        }
        return 5;
    }

    public boolean hasOwner() {
        return this.profile != null;
    }

    public String getOwner() {
        return this.hasOwner() ? this.profile.getName() : null;
    }

    public boolean setOwner(String name) {
        if (name == null || name.length() > 16) {
            return false;
        }
        Optional<GameProfile> profile = CraftServer.getUC().card_findByName(name);
        if (profile.isEmpty()) {
            return false;
        }
        this.profile = profile.get();
        return true;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.profile != null) {
            if (this.profile.getId() != null) {
                return Bukkit.getOfflinePlayer((UUID)this.profile.getId());
            }
            if (this.profile.getName() != null) {
                return Bukkit.getOfflinePlayer((String)this.profile.getName());
            }
        }
        return null;
    }

    public void setOwningPlayer(OfflinePlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        this.profile = player instanceof CraftPlayer ? ((CraftPlayer)player).nms.method_7334() : new GameProfile(player.getUniqueId(), player.getName());
    }

    public BlockFace getRotation() {
        BlockData blockData = this.getBlockData();
        return blockData instanceof Rotatable ? ((Rotatable)blockData).getRotation() : ((Directional)blockData).getFacing();
    }

    public void setRotation(BlockFace rotation) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Rotatable) {
            ((Rotatable)blockData).setRotation(rotation);
        } else {
            ((Directional)blockData).setFacing(rotation);
        }
        this.setBlockData(blockData);
    }

    public SkullType getSkullType() {
        switch (this.getType()) {
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: {
                return SkullType.SKELETON;
            }
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: {
                return SkullType.WITHER;
            }
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return SkullType.ZOMBIE;
            }
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: {
                return SkullType.PLAYER;
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: {
                return SkullType.CREEPER;
            }
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: {
                return SkullType.DRAGON;
            }
        }
        throw new IllegalArgumentException("Unknown SkullType for " + String.valueOf(this.getType()));
    }

    public void setSkullType(SkullType skullType) {
        throw new UnsupportedOperationException("Must change block type");
    }

    @Override
    public void applyTo(class_2631 skull) {
        super.applyTo(skull);
        if (this.getSkullType() == SkullType.PLAYER) {
            IMixinSkullBlockEntity ic = (IMixinSkullBlockEntity)this;
            ic.IC$set_game_profile(this.profile);
        }
    }

    public PlayerProfile getPlayerProfile() {
        return null;
    }

    public void setPlayerProfile(PlayerProfile arg0) {
        this.profile = new GameProfile(arg0.getId(), arg0.getName());
    }

    public PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    public void setOwnerProfile(@Nullable org.bukkit.profile.PlayerProfile profile) {
        if (profile == null) {
            this.profile = null;
        }
    }

    public NamespacedKey getNoteBlockSound() {
        class_2960 key = ((class_2631)this.getSnapshot()).method_47888();
        return key != null ? CraftNamespacedKey.fromMinecraft(key) : null;
    }

    public void setNoteBlockSound(@Nullable NamespacedKey namespacedKey) {
        if (namespacedKey == null) {
            ((class_2631)this.getSnapshot()).field_41603 = null;
            return;
        }
        ((class_2631)this.getSnapshot()).field_41603 = CraftNamespacedKey.toMinecraft(namespacedKey);
    }

    @Nullable
    public Component customName() {
        return null;
    }

    public void customName(@Nullable Component customName) {
    }
}

