/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.command;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.defaults.PluginsCommand;
import org.cardboardpowered.impl.command.ModsCommand;
import org.cardboardpowered.impl.command.MyCommand;
import org.cardboardpowered.impl.command.VersionCommand;
import org.jetbrains.annotations.NotNull;

public class CommandMapImpl
extends SimpleCommandMap {
    private static final Class<?> CARDBOARD_VERSION_COMMAND = VersionCommand.class;
    public static HashMap<String, Command> DUMMY_MAP = new HashMap();

    public CommandMapImpl(Server server) {
        super(server, DUMMY_MAP);
        this.registerCardboardCommands();
    }

    public boolean register(@NotNull String label, @NotNull String fallbackPrefix, @NotNull Command command) {
        if (label.equals("version") && fallbackPrefix.equals("bukkit") && !CARDBOARD_VERSION_COMMAND.isInstance(command)) {
            return false;
        }
        return super.register(label, fallbackPrefix, command);
    }

    private void setDefaultCommands() {
        this.register("bukkit", new VersionCommand("version"));
        this.register("bukkit", (Command)new PluginsCommand("plugins"));
    }

    public synchronized void clearCommands() {
        super.clearCommands();
        this.registerCardboardCommands();
    }

    public Map<String, Command> getKnownCommands() {
        return this.knownCommands;
    }

    private void registerCardboardCommands() {
        this.register("bukkit", new VersionCommand("version"));
        this.register("bukkit", (Command)new PluginsCommand("plugins"));
        this.register("cardboard", new ModsCommand("fabricmods"));
        this.register("cardboard", new MyCommand());
    }
}

