/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.command;

import com.google.common.base.Joiner;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3218;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.cardboardpowered.impl.entity.CraftPlayer;

public final class MinecraftCommandWrapper
extends BukkitCommand {
    private final class_2170 dispatcher;
    public final CommandNode<?> vanillaCommand;

    public MinecraftCommandWrapper(class_2170 dispatcher, CommandNode<?> vanillaCommand) {
        super(vanillaCommand.getName(), "A Minecraft provided command", vanillaCommand.getUsageText(), Collections.emptyList());
        this.dispatcher = dispatcher;
        this.vanillaCommand = vanillaCommand;
        this.setPermission(MinecraftCommandWrapper.getPermission(vanillaCommand));
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        class_2168 icommandlistener = MinecraftCommandWrapper.getCommandSource(sender);
        this.dispatcher.method_44252(icommandlistener, this.toDispatcher(args, this.getName()));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        class_2168 icommandlistener = MinecraftCommandWrapper.getCommandSource(sender);
        ParseResults parsed = this.dispatcher.method_9235().parse(this.toDispatcher(args, this.getName()), (Object)icommandlistener);
        ArrayList<String> results = new ArrayList<String>();
        this.dispatcher.method_9235().getCompletionSuggestions(parsed).thenAccept(suggestions -> suggestions.getList().forEach(s -> results.add(s.getText())));
        return results;
    }

    public static String getPermission(CommandNode<?> vanillaCommand) {
        return "minecraft.command." + (vanillaCommand.getRedirect() == null ? vanillaCommand.getName() : vanillaCommand.getRedirect().getName());
    }

    private String toDispatcher(String[] args, String name) {
        return name + (String)(args.length > 0 ? " " + Joiner.on((char)' ').join((Object[])args) : "");
    }

    public static class_2168 getCommandSource(CommandSender s) {
        if (s instanceof CraftPlayer) {
            return ((CraftPlayer)s).getHandle().method_64396();
        }
        if (s instanceof CraftEntity) {
            return ((CraftEntity)s).getHandle().method_5671((class_3218)((CraftEntity)s).getWorld());
        }
        if (s instanceof ConsoleCommandSender) {
            return ((CraftServer)s.getServer()).getServer().method_3739();
        }
        return null;
    }
}

