/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.mixin;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import me.isaiah.common.ICommonMod;
import net.minecraft.class_11368;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2632;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2724;
import net.minecraft.class_2748;
import net.minecraft.class_2759;
import net.minecraft.class_2767;
import net.minecraft.class_2783;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3312;
import net.minecraft.class_3320;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4273;
import net.minecraft.class_5217;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6682;
import net.minecraft.class_6880;
import net.minecraft.class_7428;
import net.minecraft.class_8791;
import net.minecraft.class_8792;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.cardboardpowered.CardboardConfig;
import org.cardboardpowered.CardboardMod;
import org.cardboardpowered.ChunkTicketBridge;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IMixinPlayNetworkHandler;
import org.cardboardpowered.interfaces.IMixinPlayerManager;
import org.cardboardpowered.interfaces.IMixinServerLoginNetworkHandler;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3324.class})
public abstract class MixinPlayerManager
implements IMixinPlayerManager {
    @Shadow
    public List<class_3222> field_14351;
    @Shadow
    private MinecraftServer field_14360;
    @Shadow
    public Map<UUID, class_3222> field_14354;
    @Unique
    private CraftPlayer plr;
    private static final Logger cb$LOGGER = LogUtils.getLogger();
    private Location banner$loc = null;
    private transient PlayerRespawnEvent.RespawnFlag banner$respawnReason;
    public class_3218 banner$worldserver = null;
    public AtomicBoolean avoidSuffocation = new AtomicBoolean(true);
    public World fromWorld;
    public PlayerRespawnEvent respawnEvent;
    public class_3218 worldserver1;
    public class_5217 worlddata;
    public class_3222 entityplayer_vanilla;

    @Shadow
    public void method_14576(class_3222 player) {
    }

    @Shadow
    public void method_14606(class_3222 player, class_3218 world) {
    }

    @Shadow
    public void method_14577(class_3222 player) {
    }

    @Shadow
    public void method_14594(class_3222 player) {
    }

    public void Player_forceSetPositionRotation(class_3222 p, double x, double y, double z, float yaw, float pitch) {
        p.method_5808(x, y, z, yaw, pitch);
        p.field_13987.method_14372();
    }

    @Override
    public class_3222 moveToWorld(class_3222 player, class_3218 worldserver, boolean flag, Location to, boolean avoidSuffocation) {
        return this.respawn(player, true, class_1297.class_5529.field_27002, null, to);
    }

    @Override
    public class_3222 respawn(class_3222 player, boolean keepInventory, class_1297.class_5529 reason, PlayerRespawnEvent.RespawnReason eventReason, Location location) {
        class_3218 level1;
        class_5454 teleportTransition;
        if (CardboardConfig.DEBUG_PLAYER) {
            CardboardMod.LOGGER.info("DEBUG: PlayerManager.respawn called");
        }
        player.method_5848();
        this.field_14351.remove(player);
        player.method_51469().method_18770(player, reason);
        class_3222 serverPlayer = player;
        class_3218 fromWorld = player.method_51469();
        player.field_13989 = false;
        serverPlayer.field_13987 = player.field_13987;
        serverPlayer.method_14203(player, keepInventory);
        serverPlayer.method_5838(player.method_5628());
        serverPlayer.method_7283(player.method_6068());
        for (String string : player.method_5752()) {
            serverPlayer.method_5780(string);
        }
        boolean isBedSpawn = false;
        boolean isRespawn = false;
        boolean isAnchorSpawn = false;
        if (location == null) {
            teleportTransition = player.findRespawnPositionAndUseSpawnBlock(!keepInventory, class_5454.field_52245, eventReason);
            if (!keepInventory) {
                player.reset();
            }
            if (teleportTransition == null) {
                return player;
            }
            isRespawn = true;
            location = CraftLocation.toBukkit(teleportTransition.comp_2821(), (World)teleportTransition.comp_2820().getWorld(), teleportTransition.comp_2823(), teleportTransition.comp_2824());
        } else {
            teleportTransition = new class_5454(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3(location), class_243.field_1353, location.getYaw(), location.getPitch(), class_5454.field_52245);
        }
        if (teleportTransition == null) {
            return player;
        }
        class_3218 level = teleportTransition.comp_2820();
        serverPlayer.spawnIn(level);
        serverPlayer.method_31482();
        serverPlayer.method_5660(false);
        class_243 vec3 = teleportTransition.comp_2821();
        this.Player_forceSetPositionRotation(serverPlayer, vec3.field_1352, vec3.field_1351, vec3.field_1350, teleportTransition.comp_2823(), teleportTransition.comp_2824());
        level.method_14178().method_66009(ChunkTicketBridge.POST_TELEPORT, new class_1923(class_3532.method_15357((double)vec3.method_10216()) >> 4, class_3532.method_15357((double)vec3.method_10215()) >> 4), 1);
        if (teleportTransition.comp_2825()) {
            if (CardboardConfig.DEBUG_PLAYER) {
                CardboardMod.LOGGER.info("teleportTransition#missingRespawnBlock!");
            }
            serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25645, 0.0f));
            serverPlayer.method_26284(null, false);
        }
        byte b2 = (byte)(keepInventory ? 1 : 0);
        class_3218 serverLevel = serverPlayer.method_51469();
        class_5217 levelData = serverLevel.method_8401();
        serverPlayer.field_13987.method_14364((class_2596)new class_2724(serverPlayer.method_52374(serverLevel), b2));
        player.method_48105(this.worldserver1, location.getX(), location.getY(), location.getZ(), null, 0.0f, 0.0f, false);
        serverPlayer.field_13987.method_14364((class_2596)new class_2759(level.method_43126(), level.method_43127()));
        serverPlayer.field_13987.method_14364((class_2596)new class_2632(levelData.method_207(), levelData.method_197()));
        serverPlayer.field_13987.method_14364((class_2596)new class_2748(serverPlayer.field_7510, serverPlayer.field_7495, serverPlayer.field_7520));
        this.method_60598(serverPlayer);
        this.method_14606(serverPlayer, level);
        this.method_14576(serverPlayer);
        if (!serverPlayer.method_14239()) {
            if (CardboardConfig.DEBUG_PLAYER) {
                CardboardMod.LOGGER.info("calling onPlayerRespawned");
            }
            level.method_18215(serverPlayer);
            this.field_14351.add(serverPlayer);
            this.field_14354.put(serverPlayer.method_5667(), serverPlayer);
        }
        serverPlayer.method_6033(serverPlayer.method_6032());
        class_3222.class_10766 respawnConfig = serverPlayer.method_67564();
        if (!keepInventory && respawnConfig != null && (level1 = this.field_14360.method_3847(respawnConfig.comp_3683())) != null) {
            class_2338 blockPos = respawnConfig.comp_3684();
            class_2680 blockState = level1.method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_23152)) {
                serverPlayer.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_23117, class_3419.field_15245, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 1.0f, 1.0f, level.method_8409().method_43055()));
            }
            if (!teleportTransition.comp_2825()) {
                if (blockState.method_26164(class_3481.field_16443)) {
                    isBedSpawn = true;
                } else if (blockState.method_27852(class_2246.field_23152)) {
                    isAnchorSpawn = true;
                }
            }
        }
        this.method_14594(player);
        player.method_7355();
        for (class_1293 mobEffect : player.method_6026()) {
            player.field_13987.method_14364((class_2596)new class_2783(player.method_5628(), mobEffect, false));
        }
        player.method_18783(level);
        if (fromWorld != level) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)player.getBukkitEntity(), (World)fromWorld.getWorld());
            CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        }
        if (player.method_14239()) {
            this.method_14577(player);
        }
        if (isRespawn) {
            new PlayerPostRespawnEvent((Player)player.getBukkitEntity(), location, isBedSpawn, isAnchorSpawn, teleportTransition.comp_2825(), eventReason).callEvent();
        }
        return serverPlayer;
    }

    @Shadow
    void method_60598(class_3222 player) {
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="HEAD")})
    public void onConnect(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        this.plr = (CraftPlayer)CraftServer.INSTANCE.getPlayer(player);
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"))
    public void firePlayerJoinEvent(class_3324 instance, class_2561 message, boolean overlay) {
        if (this.plr == null) {
            instance.method_43514(message, overlay);
            return;
        }
        CraftPlayer plr = this.plr;
        this.plr = null;
        String key = "multiplayer.player.joined";
        class_2561 name = plr.nms.method_5476();
        Object joinMessage = String.valueOf(class_124.field_1054) + class_2561.method_43469((String)key, (Object[])new Object[]{name}).getString();
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)plr, (String)joinMessage);
        CraftEventFactory.callEvent((Event)playerJoinEvent);
        IMixinPlayNetworkHandler ims = (IMixinPlayNetworkHandler)plr.nms.field_13987;
        if (!ims.cb_get_connection().method_10758()) {
            return;
        }
        joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && !((String)joinMessage).isEmpty()) {
            for (class_2561 line : CraftChatMessage.fromString((String)joinMessage)) {
                this.method_43512(line, entityplayer -> line, false);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"remove"})
    public void firePlayerQuitEvent(class_3222 player, CallbackInfo ci) {
        player.method_7346();
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent(CraftServer.INSTANCE.getPlayer(player), "\u00a7e" + player.method_5476().getString() + " left the game");
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)playerQuitEvent);
        player.method_14226();
    }

    private class_3218 cardboard$getPlayerSpawn(class_3222 player) {
        String string;
        GameProfile gameProfile = player.method_7334();
        class_3312 profileCache = this.field_14360.method_3793();
        if (profileCache != null) {
            Optional optional = profileCache.method_14512(gameProfile.getId());
            string = optional.map(GameProfile::getName).orElse(gameProfile.getName());
            profileCache.method_14508(gameProfile);
        } else {
            string = gameProfile.getName();
        }
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(player.method_71370(), cb$LOGGER);){
            class_3218 serverLevel;
            class_3218 level;
            boolean[] invalidPlayerWorld;
            class_5321 resourceKey;
            Optional loadedPlayerData;
            block17: {
                World bWorld;
                block19: {
                    Optional worldName;
                    block18: {
                        Optional optional1;
                        loadedPlayerData = optional1 = this.field_14360.method_3760().method_14600(player, (class_8942)scopedCollector);
                        if (loadedPlayerData.isPresent()) {
                            string = loadedPlayerData.flatMap(view -> view.method_71420("bukkit")).flatMap(t -> t.method_71441("lastKnownName")).orElse(string);
                        }
                        resourceKey = null;
                        invalidPlayerWorld = new boolean[]{false};
                        if (!loadedPlayerData.isPresent()) break block17;
                        class_11368 playerData = (class_11368)loadedPlayerData.get();
                        Optional worldUUIDMost = playerData.method_71440("WorldUUIDMost");
                        Optional worldUUIDLeast = playerData.method_71440("WorldUUIDLeast");
                        worldName = playerData.method_71441("world");
                        if (!worldUUIDMost.isPresent() || !worldUUIDLeast.isPresent()) break block18;
                        bWorld = Bukkit.getServer().getWorld(new UUID((Long)worldUUIDMost.get(), (Long)worldUUIDLeast.get()));
                        break block19;
                    }
                    if (!worldName.isPresent()) break block17;
                    bWorld = Bukkit.getServer().getWorld((String)worldName.get());
                }
                if (bWorld != null) {
                    resourceKey = ((CraftWorld)bWorld).getHandle().method_27983();
                } else {
                    resourceKey = class_1937.field_25179;
                    invalidPlayerWorld[0] = true;
                }
            }
            if (resourceKey == null) {
                resourceKey = loadedPlayerData.flatMap(compoundTag -> {
                    Optional result = compoundTag.method_71426("Dimension", class_1937.field_25178);
                    invalidPlayerWorld[0] = result.isEmpty();
                    return result;
                }).orElse(class_1937.field_25179);
            }
            if ((level = this.field_14360.method_3847(resourceKey)) == null) {
                cb$LOGGER.warn("Unknown respawn dimension {}, defaulting to overworld", (Object)resourceKey);
                serverLevel = this.field_14360.method_30002();
                invalidPlayerWorld[0] = true;
            } else {
                serverLevel = level;
            }
            player.method_51468(serverLevel);
            if (loadedPlayerData.isEmpty() || invalidPlayerWorld[0]) {
                player.method_60949(player.method_14245(serverLevel, serverLevel.method_43126()).method_61082(), serverLevel.method_43127(), 0.0f);
            }
            class_3218 class_32182 = serverLevel;
            return class_32182;
        }
    }

    @Override
    public class_3222 attemptLogin(class_3248 nethand, GameProfile profile, class_7428 key, String hostname) {
        UUID uuid = ICommonMod.getIServer().get_uuid_from_profile(profile);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.field_14351.size(); ++i) {
            class_3222 entityplayer = this.field_14351.get(i);
            if (!entityplayer.method_5667().equals(uuid)) continue;
            list.add(entityplayer);
        }
        for (class_3222 entityplayer : list) {
            this.method_14577(entityplayer);
            entityplayer.field_13987.method_52396(class_2561.method_30163((String)"multiplayer.disconnect.duplicate_login"));
        }
        IMixinServerLoginNetworkHandler ims = (IMixinServerLoginNetworkHandler)nethand;
        SocketAddress address = ims.cb_get_connection().method_10755();
        class_3222 entity = new class_3222((MinecraftServer)CraftServer.server, CraftServer.server.method_3847(class_1937.field_25179), profile, class_8791.method_53821());
        Player player = (Player)entity.getBukkitEntity();
        class_3218 serverLevel = this.cardboard$getPlayerSpawn(entity);
        PlayerLoginEvent event = new PlayerLoginEvent(player, hostname, ((InetSocketAddress)address).getAddress(), ((InetSocketAddress)ims.cb_get_connection().field_11651.remoteAddress()).getAddress());
        if (((class_3324)this).method_14563().method_14650(profile)) {
            class_5250 chatmessage = class_2561.method_43469((String)"multiplayer.disconnect.banned.reason", (Object[])new Object[]{"TODO REASON!"});
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((class_2561)chatmessage));
        } else if (!((class_3324)this).method_14587(profile)) {
            class_5250 chatmessage = class_2561.method_43471((String)"multiplayer.disconnect.not_whitelisted");
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, "Server whitelisted!");
        } else if (((class_3324)this).method_14585().method_14527(address)) {
            class_3320 ipbanentry = ((class_3324)this).method_14585().method_14528(address);
            class_5250 chatmessage = class_2561.method_43469((String)"multiplayer.disconnect.banned_ip.reason", (Object[])new Object[]{ipbanentry.method_14503()});
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((class_2561)chatmessage));
        } else if (this.field_14351.size() >= ((class_3324)this).method_14592() && !((class_3324)this).method_14609(profile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, "Server is full");
        }
        CraftEventFactory.callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            nethand.method_14380(class_2561.method_30163((String)event.getKickMessage()));
            return null;
        }
        return entity;
    }

    @Shadow
    public void method_14588(class_2995 scoreboardserver, class_3222 entityplayer) {
    }

    @Shadow
    public abstract void method_43512(class_2561 var1, Function<class_3222, class_2561> var2, boolean var3);

    @Override
    public void sendScoreboardBF(class_2995 newboard, class_3222 handle) {
        this.method_14588(newboard, handle);
    }

    @Overwrite
    public class_3222 method_14556(class_3222 player, boolean keepInventory, class_1297.class_5529 reason) {
        Object level1;
        class_5454 teleportTransition;
        PlayerRespawnEvent.RespawnReason eventReason = null;
        Location location = null;
        player.method_5848();
        this.field_14351.remove(player);
        player.method_51469().method_18770(player, reason);
        class_3222 serverPlayer = player;
        class_3218 fromWorld = player.method_51469();
        player.field_13989 = false;
        player.field_13987 = player.field_13987;
        player.method_14203(player, keepInventory);
        player.method_5838(player.method_5628());
        player.method_7283(player.method_6068());
        for (String string : player.method_5752()) {
            serverPlayer.method_5780(string);
        }
        boolean isBedSpawn = false;
        boolean isRespawn = false;
        boolean isAnchorSpawn = false;
        if (location == null) {
            teleportTransition = player.findRespawnPositionAndUseSpawnBlock(!keepInventory, class_5454.field_52245, eventReason);
            if (!keepInventory) {
                player.reset();
            }
            if (teleportTransition == null) {
                if (CardboardConfig.DEBUG_PLAYER) {
                    CardboardMod.LOGGER.info("teleportTransition is null");
                }
                return player;
            }
            isRespawn = true;
            location = CraftLocation.toBukkit(teleportTransition.comp_2821(), (World)teleportTransition.comp_2820().getWorld(), teleportTransition.comp_2823(), teleportTransition.comp_2824());
        } else {
            teleportTransition = new class_5454(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3(location), class_243.field_1353, location.getYaw(), location.getPitch(), class_5454.field_52245);
        }
        if (teleportTransition == null) {
            if (CardboardConfig.DEBUG_PLAYER) {
                CardboardMod.LOGGER.info("teleTrans is null");
            }
            return player;
        }
        class_3218 level = teleportTransition.comp_2820();
        player.spawnIn(level);
        serverPlayer.method_31482();
        serverPlayer.method_5660(false);
        class_243 vec3 = teleportTransition.comp_2821();
        serverPlayer.spigot$forceSetPositionRotation(vec3.field_1352, vec3.field_1351, vec3.field_1350, teleportTransition.comp_2823(), teleportTransition.comp_2824());
        level.method_14178().method_66009(ChunkTicketBridge.POST_TELEPORT, new class_1923(class_3532.method_15357((double)vec3.method_10216()) >> 4, class_3532.method_15357((double)vec3.method_10215()) >> 4), 1);
        if (teleportTransition.comp_2825()) {
            if (CardboardConfig.DEBUG_PLAYER) {
                CardboardMod.LOGGER.info("teleTrans missing respawn block");
            }
            serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25645, 0.0f));
        }
        byte b = (byte)(keepInventory ? 1 : 0);
        class_3218 serverLevel = serverPlayer.method_51469();
        class_5217 levelData = serverLevel.method_8401();
        serverPlayer.field_13987.method_14364((class_2596)new class_2724(serverPlayer.method_52374(serverLevel), b));
        serverPlayer.field_13987.method_14364((class_2596)new class_4273(8));
        serverPlayer.field_13987.method_14364((class_2596)new class_6682(8));
        IMixinPlayNetworkHandler iNetworkHandler = (IMixinPlayNetworkHandler)serverPlayer.field_13987;
        iNetworkHandler.teleport(CraftLocation.toBukkit(serverPlayer.method_19538(), (World)serverLevel.getWorld(), serverPlayer.method_36454(), serverPlayer.method_36455()));
        serverPlayer.field_13987.method_14364((class_2596)new class_2759(level.method_43126(), level.method_43127()));
        serverPlayer.field_13987.method_14364((class_2596)new class_2632(levelData.method_207(), levelData.method_197()));
        serverPlayer.field_13987.method_14364((class_2596)new class_2748(serverPlayer.field_7510, serverPlayer.field_7495, serverPlayer.field_7520));
        this.method_60598(serverPlayer);
        this.method_14606(serverPlayer, level);
        this.method_14576(serverPlayer);
        if (!iNetworkHandler.isDisconnected()) {
            if (CardboardConfig.DEBUG_PLAYER) {
                CardboardMod.LOGGER.info("onplrrespawned");
            }
            level.method_18215(serverPlayer);
            this.field_14351.add(serverPlayer);
            this.field_14354.put(serverPlayer.method_5667(), serverPlayer);
        }
        serverPlayer.method_6033(serverPlayer.method_6032());
        class_3222.class_10766 respawnConfig = serverPlayer.method_67564();
        if (!keepInventory && respawnConfig != null && (level1 = this.field_14360.method_3847(respawnConfig.comp_3683())) != null) {
            class_2338 blockPos = respawnConfig.comp_3684();
            class_2680 blockState = level1.method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_23152)) {
                serverPlayer.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_23117, class_3419.field_15245, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 1.0f, 1.0f, level.method_8409().method_43055()));
            }
            if (!teleportTransition.comp_2825()) {
                if (blockState.method_26164(class_3481.field_16443)) {
                    isBedSpawn = true;
                } else if (blockState.method_27852(class_2246.field_23152)) {
                    isAnchorSpawn = true;
                }
            }
        }
        this.method_14594(player);
        player.method_7355();
        for (class_1293 mobEffect : player.method_6026()) {
            player.field_13987.method_14364((class_2596)new class_2783(player.method_5628(), mobEffect, false));
        }
        player.method_18783(level);
        if (fromWorld != level) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)player.getBukkitEntity(), (World)fromWorld.getCraftWorld());
            CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        }
        if (iNetworkHandler.isDisconnected()) {
            this.method_14577(player);
        }
        if (isRespawn) {
            new PlayerPostRespawnEvent((Player)player.getBukkitEntity(), location, isBedSpawn, isAnchorSpawn, teleportTransition.comp_2825(), eventReason).callEvent();
        }
        return serverPlayer;
    }
}

