/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.mixin.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import io.netty.channel.local.LocalAddress;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2901;
import net.minecraft.class_2907;
import net.minecraft.class_2909;
import net.minecraft.class_2915;
import net.minecraft.class_2917;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3324;
import net.minecraft.class_3515;
import net.minecraft.class_4844;
import net.minecraft.class_5525;
import net.minecraft.class_7648;
import net.minecraft.class_8593;
import net.minecraft.class_8610;
import net.minecraft.class_8792;
import net.minecraft.class_9157;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.cardboardpowered.interfaces.IMixinClientConnection;
import org.cardboardpowered.interfaces.IMixinPlayerManager;
import org.cardboardpowered.interfaces.IMixinServerLoginNetworkHandler;
import org.cardboardpowered.interfaces.INetworkConfiguration;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3248.class}, priority=999)
public abstract class MixinServerLoginNetworkHandler
implements IMixinServerLoginNetworkHandler {
    @Shadow
    @Nullable
    private String field_45028;
    @Shadow
    private byte[] field_14167 = new byte[4];
    @Shadow
    private MinecraftServer field_14162;
    @Shadow
    public class_2535 field_14158;
    @Shadow
    private class_3248.class_3249 field_14163;
    @Shadow
    private GameProfile field_45029;
    @Shadow
    private static AtomicInteger field_14157;
    public class_3222 delayedPlayer;
    private Logger LOGGER_BF = LogManager.getLogger((String)"Bukkit|ServerLoginNetworkHandler");
    public String hostname = "";
    private long theid = 0L;
    private class_3222 player;
    private class_3222 cardboard_player;
    @Shadow
    private boolean field_48275;

    @Shadow
    abstract void method_52417(GameProfile var1);

    @Override
    public class_2535 cb_get_connection() {
        return this.field_14158;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String s) {
        this.hostname = s;
    }

    @Overwrite
    public void method_12642(class_2917 packetIn) {
        String s;
        Validate.validState((this.field_14163 == class_3248.class_3249.field_14175 ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.field_14162.method_3716().getPrivate();
            if (!packetIn.method_43643(this.field_14167, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packetIn.method_12654(privatekey);
            Cipher cipher = class_3515.method_15235((int)2, (Key)secretKey);
            Cipher cipher1 = class_3515.method_15235((int)1, (Key)secretKey);
            s = new BigInteger(class_3515.method_15240((String)"", (PublicKey)this.field_14162.method_3716().getPublic(), (SecretKey)secretKey)).toString(16);
            this.field_14163 = class_3248.class_3249.field_14169;
            this.field_14158.method_10746(cipher, cipher1);
        }
        catch (class_5525 cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = new Thread("User Authenticator #" + this.theid++){

            @Override
            public void run() {
                GameProfile gameprofile = MixinServerLoginNetworkHandler.this.field_45029;
                String name = Objects.requireNonNull(MixinServerLoginNetworkHandler.this.field_45028, "Player name not initialized");
                try {
                    MixinServerLoginNetworkHandler.this.field_45029 = MixinServerLoginNetworkHandler.this.field_14162.method_3844().hasJoinedServer(name, s, this.getAddress()).profile();
                    if (MixinServerLoginNetworkHandler.this.field_45029 != null) {
                        if (!MixinServerLoginNetworkHandler.this.field_14158.method_10758()) {
                            return;
                        }
                        MixinServerLoginNetworkHandler.this.fireEvents();
                    } else if (MixinServerLoginNetworkHandler.this.field_14162.method_3724()) {
                        MixinServerLoginNetworkHandler.this.LOGGER_BF.warn("Failed to verify username but will let them in anyway!");
                        MixinServerLoginNetworkHandler.this.field_45029 = class_4844.method_54140((String)name);
                        MixinServerLoginNetworkHandler.this.method_52417(MixinServerLoginNetworkHandler.this.field_45029);
                    } else {
                        MixinServerLoginNetworkHandler.this.disconnect("multiplayer.disconnect.unverified_username");
                        MixinServerLoginNetworkHandler.this.LOGGER_BF.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (MixinServerLoginNetworkHandler.this.field_14162.method_3724()) {
                        MixinServerLoginNetworkHandler.this.LOGGER_BF.warn("Authentication servers are down but will let them in anyway!");
                        MixinServerLoginNetworkHandler.this.field_45029 = class_4844.method_54140((String)name);
                        MixinServerLoginNetworkHandler.this.method_52417(MixinServerLoginNetworkHandler.this.field_45029);
                    } else {
                        MixinServerLoginNetworkHandler.this.disconnect("multiplayer.disconnect.authservers_down");
                        MixinServerLoginNetworkHandler.this.LOGGER_BF.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    MixinServerLoginNetworkHandler.this.disconnect("Failed to verify username!");
                    MixinServerLoginNetworkHandler.this.LOGGER_BF.log(Level.WARN, "Exception verifying " + name, (Throwable)exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = MixinServerLoginNetworkHandler.this.field_14158.method_10755();
                return MixinServerLoginNetworkHandler.this.field_14162.method_3775() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.start();
    }

    public void fireEvents() throws Exception {
        String playerName = this.field_45029.getName();
        InetAddress address = this.field_14158.method_10755() instanceof LocalAddress ? InetAddress.getLocalHost() : ((InetSocketAddress)this.field_14158.method_10755()).getAddress();
        UUID uniqueId = this.field_45029.getId();
        final CraftServer server = CraftServer.INSTANCE;
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        server.getPluginManager().callEvent((Event)asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            CraftServer.server.getProcessQueue().add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
        this.LOGGER_BF.info("UUID of player {} is {}", (Object)this.field_45029.getName(), (Object)this.field_45029.getId());
        this.method_52417(this.field_45029);
    }

    public void disconnect(String s) {
        try {
            class_2561 text = class_2561.method_30163((String)s);
            this.LOGGER_BF.info("Disconnecting BUKKITFABRIC_TODO: " + s);
            this.field_14158.method_10743((class_2596)new class_2909(text));
            this.field_14158.method_10747(text);
        }
        catch (Exception exception) {
            this.LOGGER_BF.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    @Override
    public class_3222 cardboard$get_player() {
        if (null == this.player) {
            this.player = this.cardboard_player;
        }
        return this.player;
    }

    @Overwrite
    private void method_52419(GameProfile profile) {
        class_3222 s;
        class_3324 playerManager = this.field_14162.method_3760();
        class_2561 text = null;
        IMixinPlayerManager pm = (IMixinPlayerManager)this.field_14162.method_3760();
        this.cardboard_player = s = pm.attemptLogin((class_3248)this, this.field_45029, null, this.hostname);
        this.player = s;
        if (text != null) {
            this.method_14380(text);
        } else {
            boolean bl;
            if (this.field_14162.method_3773() >= 0 && !this.field_14158.method_10756()) {
                this.field_14158.method_10752((class_2596)new class_2907(this.field_14162.method_3773()), class_7648.method_45084(() -> this.field_14158.method_10760(this.field_14162.method_3773(), true)));
            }
            if (bl = playerManager.method_52449(profile)) {
                this.field_14163 = class_3248.class_3249.field_45031;
            } else {
                this.method_52420(profile);
            }
        }
    }

    @Shadow
    private void method_52420(GameProfile profile) {
        this.field_14163 = class_3248.class_3249.field_45032;
        this.field_14158.method_10743((class_2596)new class_2901(profile));
    }

    @Inject(at={@At(value="TAIL")}, method={"onHello"})
    public void spigotHello(class_2915 packetlogininstart, CallbackInfo ci) {
        if (!this.field_14162.method_3828() || this.field_14158.method_10756()) {
            new Thread("User Authenticator #" + this.theid++){

                @Override
                public void run() {
                    try {
                        MixinServerLoginNetworkHandler.this.initUUID();
                        MixinServerLoginNetworkHandler.this.fireEvents();
                    }
                    catch (Exception ex) {
                        MixinServerLoginNetworkHandler.this.disconnect("Failed to verify username!");
                        CraftServer.INSTANCE.getLogger().log(java.util.logging.Level.WARNING, "Exception verifying " + MixinServerLoginNetworkHandler.this.field_45029.getName(), ex);
                    }
                }
            }.start();
        }
    }

    public void initUUID() {
        UUID uuid = ((IMixinClientConnection)this.field_14158).getSpoofedUUID() != null ? ((IMixinClientConnection)this.field_14158).getSpoofedUUID() : class_4844.method_43344((String)this.field_45029.getName());
        this.field_45029 = new GameProfile(uuid, this.field_45029.getName());
        if (((IMixinClientConnection)this.field_14158).getSpoofedProfile() != null) {
            for (Property property : ((IMixinClientConnection)this.field_14158).getSpoofedProfile()) {
                this.field_45029.getProperties().put((Object)property.name(), (Object)property);
            }
        }
    }

    @Overwrite
    public void method_52289(class_8593 packet) {
        Validate.validState((this.field_14163 == class_3248.class_3249.field_45032 ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        this.field_14158.method_56329(class_9157.field_48699);
        class_8792 commonlistenercookie = class_8792.method_53824((GameProfile)Objects.requireNonNull(this.field_45029), (boolean)this.field_48275);
        class_8610 networkConfig = new class_8610(this.field_14162, this.field_14158, commonlistenercookie);
        if (this.cardboard_player != null) {
            ((INetworkConfiguration)networkConfig).cardboard_setPlayer(this.cardboard_player);
        }
        this.field_14158.method_56330(class_9157.field_48698, (class_2547)networkConfig);
        networkConfig.method_52409();
        this.field_14163 = class_3248.class_3249.field_14172;
    }

    @Shadow
    public void method_14380(class_2561 t) {
    }
}

