/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cardboardpowered.util.Hex;

public class DigestUtil {
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private final MessageDigest messageDigest;

    public static byte[] digest(MessageDigest messageDigest, byte[] data) {
        return messageDigest.digest(data);
    }

    public static byte[] digest(MessageDigest messageDigest, ByteBuffer data) {
        messageDigest.update(data);
        return messageDigest.digest();
    }

    public static byte[] digest(MessageDigest messageDigest, File data) throws IOException {
        return DigestUtil.updateDigest(messageDigest, data).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, InputStream data) throws IOException {
        return DigestUtil.updateDigest(messageDigest, data).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, Path data, OpenOption ... options) throws IOException {
        return DigestUtil.updateDigest(messageDigest, data, options).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, RandomAccessFile data) throws IOException {
        return DigestUtil.updateDigest(messageDigest, data).digest();
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MessageDigest getDigest(String algorithm, MessageDigest defaultMessageDigest) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            return defaultMessageDigest;
        }
    }

    public static MessageDigest getMd5Digest() {
        return DigestUtil.getDigest("MD5");
    }

    public static byte[] md5(byte[] data) {
        return DigestUtil.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getMd5Digest(), data);
    }

    public static String md5Hex(byte[] data) {
        return Hex.encodeHexString(DigestUtil.md5(data));
    }

    public static String md5Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(DigestUtil.md5(data));
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, byte[] valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, ByteBuffer valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, File data) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(data));){
            MessageDigest messageDigest = DigestUtil.updateDigest(digest, inputStream);
            return messageDigest;
        }
    }

    private static MessageDigest updateDigest(MessageDigest digest, FileChannel data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (data.read(buffer) > 0) {
            buffer.flip();
            digest.update(buffer);
            buffer.clear();
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int read = inputStream.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = inputStream.read(buffer, 0, 1024);
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, Path path, OpenOption ... options) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, options));){
            MessageDigest messageDigest = DigestUtil.updateDigest(digest, inputStream);
            return messageDigest;
        }
    }

    public static MessageDigest updateDigest(MessageDigest digest, RandomAccessFile data) throws IOException {
        return DigestUtil.updateDigest(digest, data.getChannel());
    }

    @Deprecated
    public DigestUtil() {
        this.messageDigest = null;
    }

    public DigestUtil(MessageDigest digest) {
        this.messageDigest = digest;
    }

    public DigestUtil(String name) {
        this(DigestUtil.getDigest(name));
    }

    public byte[] digest(byte[] data) {
        return DigestUtil.updateDigest(this.messageDigest, data).digest();
    }

    public byte[] digest(ByteBuffer data) {
        return DigestUtil.updateDigest(this.messageDigest, data).digest();
    }

    public byte[] digest(File data) throws IOException {
        return DigestUtil.updateDigest(this.messageDigest, data).digest();
    }

    public byte[] digest(InputStream data) throws IOException {
        return DigestUtil.updateDigest(this.messageDigest, data).digest();
    }

    public byte[] digest(Path data, OpenOption ... options) throws IOException {
        return DigestUtil.updateDigest(this.messageDigest, data, options).digest();
    }

    public String digestAsHex(byte[] data) {
        return Hex.encodeHexString(this.digest(data));
    }

    public String digestAsHex(ByteBuffer data) {
        return Hex.encodeHexString(this.digest(data));
    }

    public String digestAsHex(File data) throws IOException {
        return Hex.encodeHexString(this.digest(data));
    }

    public String digestAsHex(InputStream data) throws IOException {
        return Hex.encodeHexString(this.digest(data));
    }

    public String digestAsHex(Path data, OpenOption ... options) throws IOException {
        return Hex.encodeHexString(this.digest(data, options));
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }
}

