/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.util;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class SwitchTableFixer {
    public static final SwitchTableFixer INSTANCE = new SwitchTableFixer();
    private static final Set<String> ENUMS = ImmutableSet.builder().add((Object)"org/bukkit/Material").build();

    public byte[] processClass(byte[] bytes) {
        ClassNode node = new ClassNode();
        new ClassReader(bytes).accept((ClassVisitor)node, 4);
        this.processClass(node);
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public boolean processClass(ClassNode node) {
        boolean success = false;
        for (MethodNode method : node.methods) {
            if (this.inject1(node, method)) {
                success = true;
                continue;
            }
            if (!this.inject2(node, method)) continue;
            success = true;
        }
        return success;
    }

    private boolean inject1(ClassNode node, MethodNode method) {
        if (Modifier.isStatic(method.access) && (method.access & 0x1000) != 0 && method.desc.equals("()[I")) {
            boolean foundTryCatch = false;
            for (TryCatchBlockNode tryCatchBlock : method.tryCatchBlocks) {
                if ("java/lang/NoSuchFieldError".equals(tryCatchBlock.type)) {
                    foundTryCatch = true;
                    continue;
                }
                return false;
            }
            if (!foundTryCatch) {
                return false;
            }
            FieldInsnNode fieldInsnNode = null;
            String enumType = null;
            for (AbstractInsnNode insnNode : method.instructions) {
                AbstractInsnNode newArray;
                AbstractInsnNode next;
                String retType;
                Type methodType;
                Type returnType;
                if (enumType != null) break;
                if (insnNode.getOpcode() == 178 && ((FieldInsnNode)insnNode).desc.equals("[I")) {
                    fieldInsnNode = (FieldInsnNode)insnNode;
                }
                if (insnNode.getOpcode() != 184 || !((MethodInsnNode)insnNode).name.equals("values") || (returnType = (methodType = Type.getMethodType((String)((MethodInsnNode)insnNode).desc)).getReturnType()).getSort() != 9 || returnType.getDimensions() != 1 || !ENUMS.contains(retType = returnType.getElementType().getInternalName()) || (next = insnNode.getNext()).getOpcode() != 190 || (newArray = next.getNext()).getOpcode() != 188 || ((IntInsnNode)newArray).operand != 10) continue;
                enumType = retType;
            }
            if (fieldInsnNode != null && enumType != null) {
                AbstractInsnNode last;
                for (last = method.instructions.getLast(); last != null && last.getOpcode() != 176; last = last.getPrevious()) {
                }
                if (last == null) {
                    return false;
                }
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType(enumType)));
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(SwitchTableFixer.class), "fillSwitchTable1", "([ILjava/lang/Class;)[I", false));
                list.add((AbstractInsnNode)new InsnNode(89));
                list.add((AbstractInsnNode)new FieldInsnNode(179, fieldInsnNode.owner, fieldInsnNode.name, fieldInsnNode.desc));
                method.instructions.insertBefore(last, list);
                return true;
            }
        }
        return false;
    }

    public static int[] fillSwitchTable1(int[] arr, Class<? extends Enum<?>> cl) {
        Enum<?>[] enums = cl.getEnumConstants();
        if (arr.length < enums.length) {
            int[] ints = new int[enums.length];
            System.arraycopy(arr, 0, ints, 0, arr.length);
            arr = ints;
        }
        int i = -1;
        for (int j : arr) {
            if (j <= i) continue;
            i = j;
        }
        if (i != -1) {
            for (int k = i; k < enums.length; ++k) {
                arr[k] = enums[k].ordinal();
            }
        }
        return arr;
    }

    private boolean inject2(ClassNode node, MethodNode method) {
        if ((node.access & 0x1000) != 0 && node.methods.size() == 1 && Modifier.isStatic(method.access) && method.name.equals("<clinit>")) {
            boolean foundTryCatch = false;
            for (TryCatchBlockNode tryCatchBlock : method.tryCatchBlocks) {
                if ("java/lang/NoSuchFieldError".equals(tryCatchBlock.type)) {
                    foundTryCatch = true;
                    continue;
                }
                return false;
            }
            if (!foundTryCatch) {
                return false;
            }
            FieldInsnNode fieldInsnNode = null;
            String enumType = null;
            for (AbstractInsnNode insnNode : method.instructions) {
                AbstractInsnNode putStatic;
                AbstractInsnNode newArray;
                AbstractInsnNode next;
                String retType;
                Type methodType;
                Type returnType;
                if (insnNode.getOpcode() != 184 || !((MethodInsnNode)insnNode).name.equals("values") || (returnType = (methodType = Type.getMethodType((String)((MethodInsnNode)insnNode).desc)).getReturnType()).getSort() != 9 || returnType.getDimensions() != 1 || !ENUMS.contains(retType = returnType.getElementType().getInternalName()) || (next = insnNode.getNext()).getOpcode() != 190 || (newArray = next.getNext()).getOpcode() != 188 || ((IntInsnNode)newArray).operand != 10 || (putStatic = newArray.getNext()).getOpcode() != 179 || !((FieldInsnNode)putStatic).desc.equals("[I")) continue;
                enumType = retType;
                fieldInsnNode = (FieldInsnNode)putStatic;
                break;
            }
            if (fieldInsnNode != null) {
                AbstractInsnNode last;
                for (last = method.instructions.getLast(); last != null && last.getOpcode() != 177; last = last.getPrevious()) {
                }
                if (last == null) {
                    return false;
                }
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new FieldInsnNode(178, fieldInsnNode.owner, fieldInsnNode.name, fieldInsnNode.desc));
                list.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType(enumType)));
                list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(SwitchTableFixer.class), "fillSwitchTable2", "([ILjava/lang/Class;)[I", false));
                list.add((AbstractInsnNode)new FieldInsnNode(179, fieldInsnNode.owner, fieldInsnNode.name, fieldInsnNode.desc));
                method.instructions.insertBefore(last, list);
                return true;
            }
        }
        return false;
    }

    public static int[] fillSwitchTable2(int[] arr, Class<? extends Enum<?>> cl) {
        Enum<?>[] enums = cl.getEnumConstants();
        if (arr.length < enums.length) {
            int[] ints = new int[enums.length];
            System.arraycopy(arr, 0, ints, 0, arr.length);
            arr = ints;
        }
        return arr;
    }
}

