/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.nms.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMUtils {
    private static final Map<Integer, String> opcodeMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private static final Map<Integer, BiConsumer<String, AbstractInsnNode>> printerMap = new HashMap<Integer, BiConsumer<String, AbstractInsnNode>>();
    public static final String classLoaderdesc = "java/lang/ClassLoader";
    public static final String urlclassLoaderdesc = "java/net/URLClassLoader";

    public static String toDescriptorV1(String className) {
        if (className.startsWith("[")) {
            return className.replace('.', '/');
        }
        switch (className) {
            case "byte": {
                return "B";
            }
            case "short": {
                return "S";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "float": {
                return "F";
            }
            case "double": {
                return "D";
            }
            case "boolean": {
                return "Z";
            }
            case "char": {
                return "C";
            }
            case "void": {
                return "V";
            }
        }
        return "L" + className.replace('.', '/') + ";";
    }

    public static String toDescriptorV2(String internalName) {
        if (internalName.startsWith("[")) {
            return internalName;
        }
        if (internalName.length() == 1) {
            return internalName;
        }
        return "L" + internalName.replace('.', '/') + ";";
    }

    public static String toClassName(String internalName) {
        return internalName.replace('/', '.');
    }

    public static Type toType(Class<?> clazz) {
        return Type.getType(clazz);
    }

    public static String toDescriptor(Class<?> clazz) {
        return Type.getDescriptor(clazz);
    }

    public static String toInternalName(Class<?> clazz) {
        return Type.getInternalName(clazz);
    }

    public static String toInternalName(String className) {
        return className.replace('.', '/');
    }

    public static String toArgumentDescriptor(Class<?> ... classes) {
        StringJoiner sj = new StringJoiner("", "(", ")");
        for (Class<?> aClass : classes) {
            sj.add(Type.getDescriptor(aClass));
        }
        return sj.toString();
    }

    public static String toArgumentDescriptor(String methodDescriptor) {
        return methodDescriptor.substring(0, methodDescriptor.lastIndexOf(41));
    }

    public static String toMethodDescriptor(Class<?> returnType, Class<?> ... classes) {
        StringJoiner sj = new StringJoiner("", "(", ")");
        for (Class<?> aClass : classes) {
            sj.add(ASMUtils.toDescriptor(aClass));
        }
        return sj.toString() + ASMUtils.toDescriptor(returnType);
    }

    public static void dump(Path dir, byte[] bs) throws IOException {
        ClassReader classReader = new ClassReader(bs);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        File file = dir.resolve(classNode.name + ".class").toFile();
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        Files.write(file.toPath(), bs, new OpenOption[0]);
    }

    public static String getOpcodeName(int opcode) {
        return opcodeMap.get(opcode);
    }

    public static String getTypeName(int type) {
        return opcodeMap.get(type);
    }

    public static String getInternalName(Type type) {
        if (type.getSort() <= 8) {
            return type.getDescriptor();
        }
        return type.getInternalName();
    }

    private static void print(String prefix, Handle o) {
        System.out.println(prefix + " Handle " + o.getOwner() + " " + o.getName() + " " + o.getDesc());
    }

    private static void print(String prefix, Type o) {
        System.out.println(prefix + " Type " + o.getDescriptor());
    }

    private static void print(String prefix, AbstractInsnNode insn) {
        prefix = (String)prefix + " " + insn.getClass().getSimpleName() + " " + ASMUtils.getTypeName(insn.getType()) + " " + ASMUtils.getOpcodeName(insn.getOpcode());
        BiConsumer<String, AbstractInsnNode> printer = printerMap.get(insn.getType());
        if (printer != null) {
            printer.accept((String)prefix, insn);
        } else {
            System.out.println((String)prefix);
        }
    }

    static {
        for (Field field : Opcodes.class.getDeclaredFields()) {
            if (field.getType() != Integer.TYPE || !Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                opcodeMap.put((Integer)field.get(null), field.getName());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (Field field : AbstractInsnNode.class.getDeclaredFields()) {
            if (field.getType() != Integer.TYPE || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                typeMap.put((Integer)field.get(null), field.getName());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        printerMap.put(4, (prefix, item) -> {
            FieldInsnNode node = (FieldInsnNode)item;
            System.out.println(prefix + " " + node.owner + " " + node.name + " " + node.desc);
        });
        printerMap.put(2, (prefix, item) -> {
            VarInsnNode node = (VarInsnNode)item;
            System.out.println(prefix + " " + node.var);
        });
        printerMap.put(3, (prefix, item) -> {
            TypeInsnNode node = (TypeInsnNode)item;
            System.out.println(prefix + " " + node.desc);
        });
        printerMap.put(5, (prefix, item) -> {
            MethodInsnNode node = (MethodInsnNode)item;
            System.out.println(prefix + " " + node.owner + " " + node.name + " " + node.desc);
        });
        printerMap.put(6, (prefix, item) -> {
            InvokeDynamicInsnNode node = (InvokeDynamicInsnNode)item;
            System.out.println(prefix + " " + node.name + " " + node.desc);
            if (node.bsm != null) {
                ASMUtils.print(prefix, node.bsm);
            }
            if (node.bsmArgs != null) {
                for (Object bsmArg : node.bsmArgs) {
                    if (bsmArg instanceof Type) {
                        ASMUtils.print(prefix, (Type)bsmArg);
                        continue;
                    }
                    if (bsmArg instanceof Handle) {
                        ASMUtils.print(prefix, (Handle)bsmArg);
                        continue;
                    }
                    if (bsmArg instanceof String) {
                        System.out.println(prefix + " String " + bsmArg);
                        continue;
                    }
                    System.out.println(prefix + " " + bsmArg.getClass().getSimpleName() + " " + bsmArg);
                }
            }
        });
    }
}

