/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.Tool;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.util.TriState;
import net.minecraft.class_7924;
import net.minecraft.class_9424;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.util.Handleable;
import org.cardboardpowered.Registries_Bridge;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperItemTool(class_9424 impl) implements Tool,
Handleable<class_9424>
{
    private static List<Tool.Rule> convert(List<class_9424.class_9425> tool) {
        return MCUtil.transformUnmodifiable(tool, nms -> new PaperRule(PaperRegistrySets.convertToApi(RegistryKey.BLOCK, nms.comp_2501()), nms.comp_2502().orElse(null), TriState.byBoolean((Boolean)nms.comp_2503().orElse(null))));
    }

    @Override
    public class_9424 getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    Tool.Rule> rules() {
        return PaperItemTool.convert(this.impl.comp_2498());
    }

    public float defaultMiningSpeed() {
        return this.impl.comp_2499();
    }

    public int damagePerBlock() {
        return this.impl.comp_2500();
    }

    public boolean canDestroyBlocksInCreative() {
        return this.impl.comp_3480();
    }

    record PaperRule(RegistryKeySet<BlockType> blocks, @Nullable Float speed, TriState correctForDrops) implements Tool.Rule
    {
        public static PaperRule fromUnsafe(RegistryKeySet<BlockType> blocks, @Nullable Float speed, TriState correctForDrops) {
            Preconditions.checkArgument((speed == null || speed.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"speed must be positive");
            return new PaperRule(blocks, speed, correctForDrops);
        }
    }

    static final class BuilderImpl
    implements Tool.Builder {
        private final List<class_9424.class_9425> rules = new ObjectArrayList();
        private int damage = 1;
        private float miningSpeed = 1.0f;
        private boolean canDestroyBlocksInCreative = true;

        BuilderImpl() {
        }

        public Tool.Builder damagePerBlock(int damage) {
            Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be non-negative, was %s", (int)damage);
            this.damage = damage;
            return this;
        }

        public Tool.Builder defaultMiningSpeed(float miningSpeed) {
            this.miningSpeed = miningSpeed;
            return this;
        }

        public Tool.Builder addRule(Tool.Rule rule) {
            this.rules.add(new class_9424.class_9425(PaperRegistrySets.convertToNms(class_7924.field_41254, Registries_Bridge.BUILT_IN_CONVERSIONS.lookup(), rule.blocks()), Optional.ofNullable(rule.speed()), Optional.ofNullable(rule.correctForDrops().toBoolean())));
            return this;
        }

        public Tool.Builder canDestroyBlocksInCreative(boolean canDestroyBlocksInCreative) {
            this.canDestroyBlocksInCreative = canDestroyBlocksInCreative;
            return this;
        }

        public Tool.Builder addRules(Collection<Tool.Rule> rules) {
            rules.forEach(this::addRule);
            return this;
        }

        public Tool build() {
            return new PaperItemTool(new class_9424((List)new ObjectArrayList(this.rules), this.miningSpeed, this.damage, this.canDestroyBlocksInCreative));
        }
    }
}

