/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.pluginremap;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.papermc.paper.pluginremap.DebugLogger;
import io.papermc.paper.pluginremap.InsertManifestAttribute;
import io.papermc.paper.pluginremap.RemappedPluginIndex;
import io.papermc.paper.pluginremap.ReobfServer;
import io.papermc.paper.pluginremap.UnknownOriginRemappedPluginIndex;
import io.papermc.paper.util.AtomicFiles;
import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.concurrent.ScalingThreadPool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.minecraft.class_143;
import net.minecraft.class_5127;
import net.neoforged.art.api.Renamer;
import net.neoforged.art.api.SignatureStripperConfig;
import net.neoforged.art.api.Transformer;
import net.neoforged.srgutils.IMappingFile;
import org.cardboardpowered.CardboardLogger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.slf4j.Logger;
import org.spongepowered.configurate.util.CheckedConsumer;

@DefaultQualifier(value=NonNull.class)
public final class PluginRemapper {
    public static final boolean DEBUG_LOGGING = Boolean.getBoolean("Paper.PluginRemapperDebug");
    private static final String PAPER_REMAPPED = ".paper-remapped";
    private static final String UNKNOWN_ORIGIN = "unknown-origin";
    private static final String LIBRARIES = "libraries";
    private static final String EXTRA_PLUGINS = "extra-plugins";
    private static final String REMAP_CLASSPATH = "remap-classpath";
    private static final String REVERSED_MAPPINGS = "mappings/reversed";
    private static final Logger LOGGER = CardboardLogger.getSLF4J();
    private final ExecutorService threadPool = PluginRemapper.createThreadPool();
    private final ReobfServer reobf;
    private final RemappedPluginIndex remappedPlugins;
    private final RemappedPluginIndex extraPlugins;
    private final UnknownOriginRemappedPluginIndex unknownOrigin;
    private final UnknownOriginRemappedPluginIndex libraries;
    private @Nullable CompletableFuture<IMappingFile> reversedMappings;

    public PluginRemapper(Path pluginsDir) {
        CompletableFuture<IMappingFile> mappings = CompletableFuture.supplyAsync(PluginRemapper::loadReobfMappings, this.threadPool);
        Path remappedPlugins = pluginsDir.resolve(PAPER_REMAPPED);
        this.reversedMappings = this.reversedMappingsFuture(() -> mappings, remappedPlugins, this.threadPool);
        this.reobf = new ReobfServer(remappedPlugins.resolve(REMAP_CLASSPATH), mappings, this.threadPool);
        this.remappedPlugins = new RemappedPluginIndex(remappedPlugins, false);
        this.extraPlugins = new RemappedPluginIndex(this.remappedPlugins.dir().resolve(EXTRA_PLUGINS), true);
        this.unknownOrigin = new UnknownOriginRemappedPluginIndex(this.remappedPlugins.dir().resolve(UNKNOWN_ORIGIN));
        this.libraries = new UnknownOriginRemappedPluginIndex(this.remappedPlugins.dir().resolve(LIBRARIES));
    }

    public static @Nullable PluginRemapper create(Path pluginsDir) {
        if (!MappingEnvironment.reobf() && MappingEnvironment.hasMappings()) {
            try {
                return new PluginRemapper(pluginsDir);
            }
            catch (Exception var2) {
                throw new RuntimeException("Failed to create PluginRemapper, try deleting the '" + String.valueOf(pluginsDir.resolve(PAPER_REMAPPED)) + "' directory", var2);
            }
        }
        return null;
    }

    public void shutdown() {
        boolean didShutdown;
        this.threadPool.shutdown();
        this.save(true);
        try {
            didShutdown = this.threadPool.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException var3) {
            didShutdown = false;
        }
        if (!didShutdown) {
            this.threadPool.shutdownNow();
        }
    }

    public void save(boolean clean) {
        this.remappedPlugins.write();
        this.extraPlugins.write();
        this.unknownOrigin.write(clean);
        this.libraries.write(clean);
    }

    public void loadingPlugins() {
        if (this.reversedMappings == null) {
            this.reversedMappings = this.reversedMappingsFuture(() -> CompletableFuture.supplyAsync(PluginRemapper::loadReobfMappings, this.threadPool), this.remappedPlugins.dir(), this.threadPool);
        }
    }

    public void pluginsEnabled() {
        this.reversedMappings = null;
        this.save(false);
    }

    public List<Path> remapLibraries(List<Path> libraries) {
        ArrayList<CompletableFuture<Path>> tasks = new ArrayList<CompletableFuture<Path>>();
        for (Path lib : libraries) {
            if (!lib.getFileName().toString().endsWith(".jar")) {
                if (DEBUG_LOGGING) {
                    LOGGER.info("Library '{}' is not a jar.", (Object)lib);
                }
                tasks.add(CompletableFuture.completedFuture(lib));
                continue;
            }
            Path cached = this.libraries.getIfPresent(lib);
            if (cached != null) {
                if (DEBUG_LOGGING) {
                    LOGGER.info("Library '{}' has not changed since last remap.", (Object)lib);
                }
                tasks.add(CompletableFuture.completedFuture(cached));
                continue;
            }
            tasks.add(this.remapLibrary(this.libraries, lib));
        }
        return PluginRemapper.waitForAll(tasks);
    }

    public Path rewritePlugin(Path plugin) {
        if (!plugin.getParent().equals(this.remappedPlugins.dir()) && !plugin.getParent().equals(this.extraPlugins.dir())) {
            Path cached = this.unknownOrigin.getIfPresent(plugin);
            if (cached != null) {
                if (DEBUG_LOGGING) {
                    LOGGER.info("Plugin '{}' has not changed since last remap.", (Object)plugin);
                }
                return cached;
            }
            return this.remapPlugin(this.unknownOrigin, plugin).join();
        }
        return plugin;
    }

    public List<Path> rewriteExtraPlugins(List<Path> plugins) {
        List<Path> allCached = this.extraPlugins.getAllIfPresent(plugins);
        if (allCached != null) {
            if (DEBUG_LOGGING) {
                LOGGER.info("All extra plugins have a remapped variant cached.");
            }
            return allCached;
        }
        ArrayList<CompletableFuture<Path>> tasks = new ArrayList<CompletableFuture<Path>>();
        for (Path file : plugins) {
            Path cached = this.extraPlugins.getIfPresent(file);
            if (cached != null) {
                if (DEBUG_LOGGING) {
                    LOGGER.info("Extra plugin '{}' has not changed since last remap.", (Object)file);
                }
                tasks.add(CompletableFuture.completedFuture(cached));
                continue;
            }
            tasks.add(this.remapPlugin(this.extraPlugins, file));
        }
        return PluginRemapper.waitForAll(tasks);
    }

    public List<Path> rewritePluginDirectory(List<Path> jars) {
        List<Path> remappedJars = this.remappedPlugins.getAllIfPresent(jars);
        if (remappedJars != null) {
            if (DEBUG_LOGGING) {
                LOGGER.info("All plugins have a remapped variant cached.");
            }
            return remappedJars;
        }
        ArrayList<CompletableFuture<Path>> tasks = new ArrayList<CompletableFuture<Path>>();
        for (Path file : jars) {
            Path existingFile = this.remappedPlugins.getIfPresent(file);
            if (existingFile != null) {
                if (DEBUG_LOGGING) {
                    LOGGER.info("Plugin '{}' has not changed since last remap.", (Object)file);
                }
                tasks.add(CompletableFuture.completedFuture(existingFile));
                continue;
            }
            tasks.add(this.remapPlugin(this.remappedPlugins, file));
        }
        return PluginRemapper.waitForAll(tasks);
    }

    private static IMappingFile reverse(IMappingFile mappings) {
        if (DEBUG_LOGGING) {
            LOGGER.info("Reversing mappings...");
        }
        long start = System.currentTimeMillis();
        IMappingFile reversed = mappings.reverse();
        if (DEBUG_LOGGING) {
            LOGGER.info("Done reversing mappings in {}ms.", (Object)(System.currentTimeMillis() - start));
        }
        return reversed;
    }

    private CompletableFuture<IMappingFile> reversedMappingsFuture(Supplier<CompletableFuture<IMappingFile>> mappingsFuture, Path remappedPlugins, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String mappingsHash = MappingEnvironment.mappingsHash();
                String fName = mappingsHash + ".tiny";
                Path reversedMappings1 = remappedPlugins.resolve(REVERSED_MAPPINGS);
                Path file = reversedMappings1.resolve(fName);
                if (Files.isDirectory(reversedMappings1, new LinkOption[0])) {
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        return CompletableFuture.completedFuture(PluginRemapper.loadMappings("Reversed", Files.newInputStream(file, new OpenOption[0])));
                    }
                    for (Path oldFile : PluginRemapper.list(reversedMappings1, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) {
                        Files.delete(oldFile);
                    }
                } else {
                    Files.createDirectories(reversedMappings1, new FileAttribute[0]);
                }
                return ((CompletableFuture)mappingsFuture.get()).thenApply(loadedMappings -> {
                    IMappingFile reversed = PluginRemapper.reverse(loadedMappings);
                    try {
                        AtomicFiles.atomicWrite(file, (CheckedConsumer<Path, IOException>)((CheckedConsumer)writeTo -> reversed.write(writeTo, IMappingFile.Format.TINY, false)));
                        return reversed;
                    }
                    catch (IOException var4x) {
                        throw new RuntimeException("Failed to write reversed mappings", var4x);
                    }
                });
            }
            catch (IOException var8) {
                throw new RuntimeException("Failed to load reversed mappings", var8);
            }
        }, executor).thenCompose(f -> f);
    }

    private CompletableFuture<Path> remapPlugin(RemappedPluginIndex index, Path inputFile) {
        return this.remap(index, inputFile, false);
    }

    private CompletableFuture<Path> remapLibrary(RemappedPluginIndex index, Path inputFile) {
        return this.remap(index, inputFile, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompletableFuture<Path> remap(RemappedPluginIndex index, Path inputFile, boolean library) {
        Path destination = index.input(inputFile);
        try (FileSystem fs = FileSystems.newFileSystem(inputFile, new HashMap());){
            CompletionStage<Path> completionStage;
            boolean mojangMappedManifest;
            String ns;
            Path manifestPath = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
            if (Files.exists(manifestPath, new LinkOption[0])) {
                Manifest manifest;
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(manifestPath, new OpenOption[0]));){
                    manifest = new Manifest(in);
                }
                ns = manifest.getMainAttributes().getValue("paperweight-mappings-namespace");
            } else {
                ns = null;
            }
            if (ns != null && !InsertManifestAttribute.KNOWN_NAMESPACES.contains(ns)) {
                throw new RuntimeException("Failed to remap plugin " + String.valueOf(inputFile) + " with unknown mapping namespace '" + ns + "'");
            }
            boolean bl = mojangMappedManifest = ns != null && (ns.equals("mojang") || ns.equals("mojang+yarn"));
            if (library) {
                if (mojangMappedManifest) {
                    if (DEBUG_LOGGING) {
                        LOGGER.info("Library '{}' is already Mojang mapped.", (Object)inputFile);
                    }
                    index.skip(inputFile);
                    completionStage = CompletableFuture.completedFuture(inputFile);
                    return completionStage;
                }
                if (ns != null) {
                    completionStage = this.reobf.remapped().thenApplyAsync(reobfServer -> {
                        LOGGER.info("Remapping {} '{}'...", (Object)(library ? "library" : "plugin"), (Object)inputFile);
                        long start = System.currentTimeMillis();
                        try (DebugLogger logger = DebugLogger.forOutputFile(destination);
                             Renamer renamer = Renamer.builder().add(Transformer.renamerFactory((IMappingFile)this.mappings(), (boolean)false)).add(InsertManifestAttribute.addNamespaceManifestAttribute("mojang+yarn")).add(Transformer.signatureStripperFactory((SignatureStripperConfig)SignatureStripperConfig.ALL)).lib(reobfServer.toFile()).threads(1).logger((Consumer)logger).debug(logger.debug()).build();){
                            renamer.run(inputFile.toFile(), destination.toFile());
                        }
                        catch (Exception var15x) {
                            throw new RuntimeException("Failed to remap plugin jar '" + String.valueOf(inputFile) + "'", var15x);
                        }
                        LOGGER.info("Done remapping {} '{}' in {}ms.", new Object[]{library ? "library" : "plugin", inputFile, System.currentTimeMillis() - start});
                        return destination;
                    }, (Executor)this.threadPool);
                    return completionStage;
                }
                if (DEBUG_LOGGING) {
                    LOGGER.info("Library '{}' does not specify a mappings namespace (not remapping).", (Object)inputFile);
                }
                index.skip(inputFile);
                completionStage = CompletableFuture.completedFuture(inputFile);
                return completionStage;
            }
            if (mojangMappedManifest) {
                if (DEBUG_LOGGING) {
                    LOGGER.info("Plugin '{}' is already Mojang mapped.", (Object)inputFile);
                }
                index.skip(inputFile);
                completionStage = CompletableFuture.completedFuture(inputFile);
                return completionStage;
            }
            if (ns != null || !Files.exists(fs.getPath("paper-plugin.yml", new String[0]), new LinkOption[0])) {
                completionStage = this.reobf.remapped().thenApplyAsync(reobfServer -> {
                    LOGGER.info("Remapping {} '{}'...", (Object)(library ? "library" : "plugin"), (Object)inputFile);
                    long start = System.currentTimeMillis();
                    try (DebugLogger logger = DebugLogger.forOutputFile(destination);
                         Renamer renamer = Renamer.builder().add(Transformer.renamerFactory((IMappingFile)this.mappings(), (boolean)false)).add(InsertManifestAttribute.addNamespaceManifestAttribute("mojang+yarn")).add(Transformer.signatureStripperFactory((SignatureStripperConfig)SignatureStripperConfig.ALL)).lib(reobfServer.toFile()).threads(1).logger((Consumer)logger).debug(logger.debug()).build();){
                        renamer.run(inputFile.toFile(), destination.toFile());
                    }
                    catch (Exception var15x) {
                        throw new RuntimeException("Failed to remap plugin jar '" + String.valueOf(inputFile) + "'", var15x);
                    }
                    LOGGER.info("Done remapping {} '{}' in {}ms.", new Object[]{library ? "library" : "plugin", inputFile, System.currentTimeMillis() - start});
                    return destination;
                }, (Executor)this.threadPool);
                return completionStage;
            }
            if (DEBUG_LOGGING) {
                LOGGER.info("Plugin '{}' is a Paper plugin with no namespace specified.", (Object)inputFile);
            }
            index.skip(inputFile);
            CompletableFuture<Path> var18 = CompletableFuture.completedFuture(inputFile);
            return var18;
        }
        catch (IOException var16) {
            return CompletableFuture.failedFuture(new RuntimeException("Failed to open plugin jar " + String.valueOf(inputFile), var16));
        }
    }

    private IMappingFile mappings() {
        CompletableFuture<IMappingFile> mappings = this.reversedMappings;
        return mappings == null ? this.reversedMappingsFuture(() -> CompletableFuture.supplyAsync(PluginRemapper::loadReobfMappings, Runnable::run), this.remappedPlugins.dir(), Runnable::run).join() : mappings.join();
    }

    private static IMappingFile loadReobfMappings() {
        return PluginRemapper.loadMappings("Reobf", MappingEnvironment.mappingsStream());
    }

    private static IMappingFile loadMappings(String name, InputStream stream) {
        try {
            IMappingFile var6;
            InputStream ex = stream;
            try {
                if (DEBUG_LOGGING) {
                    LOGGER.info("Loading {} mappings...", (Object)name);
                }
                long start = System.currentTimeMillis();
                IMappingFile load = IMappingFile.load((InputStream)stream);
                if (DEBUG_LOGGING) {
                    LOGGER.info("Done loading {} mappings in {}ms.", (Object)name, (Object)(System.currentTimeMillis() - start));
                }
                var6 = load;
            }
            catch (Throwable var8) {
                if (stream != null) {
                    try {
                        ex.close();
                    }
                    catch (Throwable var7) {
                        var8.addSuppressed(var7);
                    }
                }
                throw var8;
            }
            if (stream != null) {
                stream.close();
            }
            return var6;
        }
        catch (IOException var9) {
            throw new RuntimeException("Failed to load " + name + " mappings", var9);
        }
    }

    static List<Path> list(Path dir, Predicate<Path> filter) {
        try {
            List<Path> var3;
            try (Stream<Path> stream = Files.list(dir);){
                var3 = stream.filter(filter).toList();
            }
            return var3;
        }
        catch (IOException var7) {
            throw new RuntimeException("Failed to list directory '" + String.valueOf(dir) + "'", var7);
        }
    }

    private static List<Path> waitForAll(List<CompletableFuture<Path>> tasks) {
        class_5127 collector = new class_5127();
        ArrayList<Path> ret = new ArrayList<Path>();
        for (CompletableFuture<Path> task : tasks) {
            try {
                ret.add(task.join());
            }
            catch (CompletionException var7) {
                collector.method_26807((Throwable)var7);
            }
        }
        try {
            collector.method_26806();
        }
        catch (Exception var6) {
            LOGGER.error("Encountered exception remapping plugins", (Throwable)var6);
        }
        return ret;
    }

    private static ThreadPoolExecutor createThreadPool() {
        return new ThreadPoolExecutor(0, 4, 5L, TimeUnit.SECONDS, ScalingThreadPool.createUnboundedQueue(), new ThreadFactoryBuilder().setNameFormat("Paper Plugin Remapper Thread - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_143(LOGGER)).build(), ScalingThreadPool.defaultReEnqueuePolicy());
    }
}

