/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import com.google.common.base.Suppliers;
import io.papermc.paper.registry.legacy.DelayedRegistry;
import io.papermc.paper.registry.legacy.DelayedRegistryEntry;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public interface RegistryHolder<B extends Keyed> {
    public Registry<B> get();

    public static final class Memoized<B extends Keyed, R extends Registry<B>>
    implements RegistryHolder<B> {
        private final Supplier<R> memoizedSupplier = Suppliers.memoize(supplier::get);

        public Memoized(Supplier<? extends R> supplier) {
        }

        @Override
        public Registry<B> get() {
            return (Registry)this.memoizedSupplier.get();
        }
    }

    public static final class Delayed<B extends Keyed, R extends Registry<B>>
    implements RegistryHolder<B> {
        private final DelayedRegistry<B, R> delayedRegistry = new DelayedRegistry();

        public DelayedRegistry<B, R> get() {
            return this.delayedRegistry;
        }

        <M> void loadFrom(DelayedRegistryEntry<M, B> delayedEntry, class_2378<M> registry) {
            RegistryHolder<B> delegateHolder = delayedEntry.delegate().createRegistryHolder(registry);
            if (!(delegateHolder instanceof Memoized)) {
                throw new IllegalArgumentException(String.valueOf(delegateHolder) + " must be a memoized holder");
            }
            this.delayedRegistry.load(((Memoized)delegateHolder).memoizedSupplier);
        }
    }
}

