/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class Hashing {
    private Hashing() {
    }

    public static String sha256(InputStream stream) {
        try {
            String var2;
            InputStream ex = stream;
            try {
                var2 = com.google.common.hash.Hashing.sha256().hashBytes(IOUtils.toByteArray((InputStream)stream)).toString().toUpperCase(Locale.ROOT);
            }
            catch (Throwable var5) {
                if (stream != null) {
                    try {
                        ex.close();
                    }
                    catch (Throwable var4) {
                        var5.addSuppressed(var4);
                    }
                }
                throw var5;
            }
            if (stream != null) {
                stream.close();
            }
            return var2;
        }
        catch (IOException var6) {
            throw new RuntimeException("Failed to take hash of InputStream", var6);
        }
    }

    public static String sha256(Path file) {
        HashCode hash;
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("'" + String.valueOf(file) + "' is not a regular file!");
        }
        try {
            hash = com.google.common.io.Files.asByteSource((File)file.toFile()).hash(com.google.common.hash.Hashing.sha256());
        }
        catch (IOException var3) {
            throw new RuntimeException("Failed to take hash of file '" + String.valueOf(file) + "'", var3);
        }
        return hash.toString().toUpperCase(Locale.ROOT);
    }
}

