/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.util.Hashing;
import java.io.InputStream;
import java.util.Objects;
import net.minecraft.class_1311;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class MappingEnvironment {
    public static final boolean DISABLE_PLUGIN_REMAPPING = Boolean.getBoolean("paper.disablePluginRemapping");
    public static final String LEGACY_CB_VERSION = "v1_21_R6";
    private static final @Nullable String MAPPINGS_HASH = MappingEnvironment.readMappingsHash();
    private static final boolean REOBF = MappingEnvironment.checkReobf();

    private MappingEnvironment() {
    }

    public static boolean reobf() {
        return REOBF;
    }

    public static boolean hasMappings() {
        return MAPPINGS_HASH != null;
    }

    public static InputStream mappingsStream() {
        return Objects.requireNonNull(MappingEnvironment.mappingsStreamIfPresent(), "Missing mappings!");
    }

    public static @Nullable InputStream mappingsStreamIfPresent() {
        return MappingEnvironment.class.getClassLoader().getResourceAsStream("META-INF/mappings/reobf.tiny");
    }

    public static String mappingsHash() {
        return Objects.requireNonNull(MAPPINGS_HASH, "MAPPINGS_HASH");
    }

    private static String readMappingsHash() {
        InputStream stream = MappingEnvironment.mappingsStreamIfPresent();
        return stream == null ? null : Hashing.sha256(stream);
    }

    private static boolean checkReobf() {
        Class<class_1311> clazz = class_1311.class;
        if (clazz.getSimpleName().equals("class_1311")) {
            return false;
        }
        if (clazz.getSimpleName().equals("MobCategory")) {
            return false;
        }
        if (clazz.getSimpleName().equals("EnumCreatureType")) {
            return true;
        }
        throw new IllegalStateException();
    }
}

