/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.SrgLib;

public final class FieldData {
    private final JavaType declaringType;
    private final String name;

    private FieldData(JavaType declaringType, String name) {
        this.declaringType = Objects.requireNonNull(declaringType, "Null declaring type");
        this.name = Objects.requireNonNull(name, "Null name");
        if (!SrgLib.isValidIdentifier(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }

    public JavaType getDeclaringType() {
        return this.declaringType;
    }

    public String getName() {
        return this.name;
    }

    public String getInternalName() {
        return this.declaringType.getInternalName() + "/" + this.name;
    }

    public FieldData withName(String name) {
        return new FieldData(this.declaringType, name);
    }

    public boolean hasSameTypes(FieldData other) {
        Objects.requireNonNull(other, "Null other data!");
        return this.declaringType.equals(other.declaringType);
    }

    public FieldData withDeclaringType(JavaType declaringType) {
        return new FieldData(declaringType, this.name);
    }

    public FieldData mapTypes(UnaryOperator<JavaType> transformer) {
        return new FieldData((JavaType)transformer.apply(this.declaringType), this.name);
    }

    public static FieldData create(JavaType declaringType, String name) {
        return new FieldData(declaringType, name);
    }

    public int hashCode() {
        return this.declaringType.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == FieldData.class && ((FieldData)obj).declaringType.equals(this.declaringType) && ((FieldData)obj).name.equals(this.name);
    }

    public String toString() {
        return this.getInternalName();
    }

    public static FieldData fromInternalName(String internalName) {
        int index = internalName.lastIndexOf(47);
        if (index < 0 || index >= internalName.length() - 1) {
            throw new IllegalArgumentException("Invalid internal name: " + internalName);
        }
        JavaType declaringType = JavaType.fromInternalName(internalName.substring(0, index));
        String name = internalName.substring(index + 1);
        return FieldData.create(declaringType, name);
    }
}

