/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.cardboardpowered.impl.world.CardboardChunk;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IMixinWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CraftBlockState
implements BlockState {
    protected final CraftWorld world;
    @Deprecated
    private CardboardChunk chunk;
    private final class_2338 position;
    protected class_2680 data;
    protected int flag;
    private WeakReference<class_1936> weakWorld;

    public CraftBlockState(Block block) {
        this.world = (CraftWorld)block.getWorld();
        this.position = ((CraftBlock)block).getPosition();
        this.data = ((CraftBlock)block).getNMS();
        this.chunk = (CardboardChunk)block.getChunk();
        this.flag = 3;
    }

    public CraftBlockState(Block block, int flag) {
        this(block);
        this.flag = flag;
    }

    protected CraftBlockState(@Nullable World world, class_2338 blockPosition, class_2680 blockData) {
        this.world = (CraftWorld)world;
        this.position = blockPosition;
        this.data = blockData;
    }

    protected CraftBlockState(CraftBlockState state, @Nullable Location location) {
        if (location == null) {
            this.world = null;
            this.position = state.getPosition().method_10062();
        } else {
            this.world = (CraftWorld)location.getWorld();
            this.position = CraftLocation.toBlockPosition(location);
        }
        this.data = state.data;
        this.flag = state.flag;
        this.setWorldHandle(state.getWorldHandle());
    }

    public void setWorldHandle(class_1936 generatorAccess) {
        this.weakWorld = generatorAccess instanceof class_1937 ? null : new WeakReference<class_1936>(generatorAccess);
    }

    public class_1936 getWorldHandle() {
        if (this.weakWorld == null) {
            return this.isPlaced() ? this.world.getHandle() : null;
        }
        class_1936 access = (class_1936)this.weakWorld.get();
        if (access == null) {
            this.weakWorld = null;
            return this.isPlaced() ? this.world.getHandle() : null;
        }
        return access;
    }

    protected final boolean isWorldGeneration() {
        class_1936 generatorAccess = this.getWorldHandle();
        return generatorAccess != null && !(generatorAccess instanceof class_1937);
    }

    public static CraftBlockState getBlockState(class_1936 world, class_2338 pos) {
        return new CraftBlockState(CraftBlock.at((class_3218)world, pos));
    }

    public static CraftBlockState getBlockState(class_1937 world, class_2338 pos, int flag) {
        return new CraftBlockState(((IMixinWorld)world).getCraftWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), flag);
    }

    public World getWorld() {
        this.requirePlaced();
        return this.world;
    }

    public int getX() {
        return this.position.method_10263();
    }

    public int getY() {
        return this.position.method_10264();
    }

    public int getZ() {
        return this.position.method_10260();
    }

    public Chunk getChunk() {
        this.requirePlaced();
        return this.world.getChunkAt(this.getX() >> 4, this.getZ() >> 4);
    }

    public void setData(class_2680 data) {
        this.data = data;
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public class_2680 getHandle() {
        return this.data;
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.data);
    }

    public void setBlockData(BlockData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        this.data = ((CraftBlockData)data).getState();
    }

    public void setData(MaterialData data) {
        Material mat = CraftMagicNumbers.getMaterial(this.data).getItemType();
        if (mat == null || mat.getData() == null) {
            this.data = CraftMagicNumbers.getBlock(data);
        } else if (data.getClass() == mat.getData() || data.getClass() == MaterialData.class) {
            this.data = CraftMagicNumbers.getBlock(data);
        } else {
            throw new IllegalArgumentException("Provided data is not of type " + mat.getData().getName() + ", found " + data.getClass().getName());
        }
    }

    public MaterialData getData() {
        return CraftMagicNumbers.getMaterial(this.data);
    }

    public void setType(Material type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)type.isBlock(), (Object)"Material must be a block!");
        if (this.getType() != type) {
            this.data = CraftMagicNumbers.getBlock(type).method_9564();
        }
    }

    public Material getType() {
        return CraftMagicNumbers.getMaterial(this.data.method_26204());
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public int getFlag() {
        return this.flag;
    }

    public byte getLightLevel() {
        return this.getBlock().getLightLevel();
    }

    public CraftBlock getBlock() {
        this.requirePlaced();
        return CraftBlock.at(this.world.getHandle(), this.position);
    }

    public boolean update() {
        return this.update(false);
    }

    public boolean update(boolean force) {
        return this.update(force, true);
    }

    public boolean update(boolean force, boolean applyPhysics) {
        if (!this.isPlaced()) {
            return true;
        }
        CraftBlock block = this.getBlock();
        if (block.getType() != this.getType() && !force) {
            return false;
        }
        class_2680 newBlock = this.data;
        block.setTypeAndData(newBlock, applyPhysics);
        this.world.getHandle().method_8413(this.position, block.getNMS(), newBlock, 3);
        return true;
    }

    public byte getRawData() {
        return CraftMagicNumbers.toLegacyData(this.data);
    }

    public Location getLocation() {
        return new Location((World)this.world, (double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld((World)this.world);
            loc.setX((double)this.getX());
            loc.setY((double)this.getY());
            loc.setZ((double)this.getZ());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public void setRawData(byte data) {
        this.data = CraftMagicNumbers.getBlock(this.getType(), data);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftBlockState other = (CraftBlockState)obj;
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        if (!(this.position == other.position || this.position != null && this.position.equals((Object)other.position))) {
            return false;
        }
        return this.data == other.data || this.data != null && this.data.equals((Object)other.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + (this.position != null ? this.position.hashCode() : 0);
        hash = 73 * hash + (this.data != null ? this.data.hashCode() : 0);
        return hash;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.requirePlaced();
        this.world.getBlockMetadata().setMetadata((Object)this.getBlock(), metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        this.requirePlaced();
        return this.world.getBlockMetadata().getMetadata((Object)this.getBlock(), metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        this.requirePlaced();
        return this.world.getBlockMetadata().hasMetadata((Object)this.getBlock(), metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.requirePlaced();
        this.world.getBlockMetadata().removeMetadata((Object)this.getBlock(), metadataKey, owningPlugin);
    }

    public boolean isPlaced() {
        return this.world != null;
    }

    protected void requirePlaced() {
        if (!this.isPlaced()) {
            throw new IllegalStateException("The state must be placed to call this method");
        }
    }

    public boolean isCollidable() {
        return false;
    }

    public @Unmodifiable @NotNull Collection<ItemStack> getDrops() {
        return this.getDrops(null, null);
    }

    public @Unmodifiable @NotNull Collection<ItemStack> getDrops(@Nullable ItemStack arg0) {
        return this.getDrops(arg0, null);
    }

    public @Unmodifiable @NotNull Collection<ItemStack> getDrops(@NotNull ItemStack arg0, @Nullable Entity entity) {
        this.requirePlaced();
        class_1799 nms = CraftItemStack.asNMSCopy(arg0);
        if (arg0 == null || !this.data.method_29291() || nms.method_7951(this.data)) {
            return class_2248.method_9609((class_2680)this.data, (class_3218)this.world.getHandle(), (class_2338)this.position, (class_2586)this.world.getHandle().method_8321(this.position), (class_1297)(entity == null ? null : ((CraftEntity)entity).getHandle()), (class_1799)nms).stream().map(CraftItemStack::asBukkitCopy).toList();
        }
        return Collections.emptyList();
    }

    public BlockState copy() {
        return new CraftBlockState(this, null);
    }

    public BlockState copy(Location location) {
        return new CraftBlockState(this, location);
    }

    public boolean isSuffocating() {
        this.requirePlaced();
        return this.data.method_26228((class_1922)this.getWorldHandle(), this.position);
    }
}

