/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.banner;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.class_2378;
import net.minecraft.class_2582;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.NamespacedKey;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;

public class CraftPatternType
implements PatternType,
Handleable<class_2582> {
    private static int count = 0;
    private final NamespacedKey key;
    private final class_2582 bannerPatternType;
    private final String name;
    private final int ordinal;

    public static PatternType minecraftToBukkit(class_2582 minecraft) {
        return (PatternType)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41252);
    }

    public static PatternType minecraftHolderToBukkit(class_6880<class_2582> minecraft) {
        return CraftPatternType.minecraftToBukkit((class_2582)minecraft.comp_349());
    }

    public static class_2582 bukkitToMinecraft(PatternType bukkit) {
        return (class_2582)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static class_6880<class_2582> bukkitToMinecraftHolder(PatternType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41252);
        class_6880 registryEntry = registry.method_47983((Object)CraftPatternType.bukkitToMinecraft(bukkit));
        if (registryEntry instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)registryEntry;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own banner pattern without properly registering it.");
    }

    public CraftPatternType(NamespacedKey key, class_2582 bannerPatternType) {
        this.key = key;
        this.bannerPatternType = bannerPatternType;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public class_2582 getHandle() {
        return this.bannerPatternType;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public int compareTo(PatternType patternType) {
        return this.ordinal - patternType.ordinal();
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftPatternType)) {
            return false;
        }
        return this.getKey().equals((Object)((PatternType)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String getIdentifier() {
        return switch (this.name()) {
            case "BASE" -> "b";
            case "SQUARE_BOTTOM_LEFT" -> "bl";
            case "SQUARE_BOTTOM_RIGHT" -> "br";
            case "SQUARE_TOP_LEFT" -> "tl";
            case "SQUARE_TOP_RIGHT" -> "tr";
            case "STRIPE_BOTTOM" -> "bs";
            case "STRIPE_TOP" -> "ts";
            case "STRIPE_LEFT" -> "ls";
            case "STRIPE_RIGHT" -> "rs";
            case "STRIPE_CENTER" -> "cs";
            case "STRIPE_MIDDLE" -> "ms";
            case "STRIPE_DOWNRIGHT" -> "drs";
            case "STRIPE_DOWNLEFT" -> "dls";
            case "SMALL_STRIPES" -> "ss";
            case "CROSS" -> "cr";
            case "STRAIGHT_CROSS" -> "sc";
            case "TRIANGLE_BOTTOM" -> "bt";
            case "TRIANGLE_TOP" -> "tt";
            case "TRIANGLES_BOTTOM" -> "bts";
            case "TRIANGLES_TOP" -> "tts";
            case "DIAGONAL_LEFT" -> "ld";
            case "DIAGONAL_UP_RIGHT" -> "rd";
            case "DIAGONAL_UP_LEFT" -> "lud";
            case "DIAGONAL_RIGHT" -> "rud";
            case "CIRCLE" -> "mc";
            case "RHOMBUS" -> "mr";
            case "HALF_VERTICAL" -> "vh";
            case "HALF_HORIZONTAL" -> "hh";
            case "HALF_VERTICAL_RIGHT" -> "vhr";
            case "HALF_HORIZONTAL_BOTTOM" -> "hhb";
            case "BORDER" -> "bo";
            case "CURLY_BORDER" -> "cbo";
            case "CREEPER" -> "cre";
            case "GRADIENT" -> "gra";
            case "GRADIENT_UP" -> "gru";
            case "BRICKS" -> "bri";
            case "SKULL" -> "sku";
            case "FLOWER" -> "flo";
            case "MOJANG" -> "moj";
            case "GLOBE" -> "glb";
            case "PIGLIN" -> "pig";
            case "FLOW" -> "flw";
            case "GUSTER" -> "gus";
            default -> this.getKey().toString();
        };
    }
}

