/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_5329;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.cardboardpowered.impl.entity.AbstractProjectile;
import org.cardboardpowered.interfaces.IMixinPersistentProjectileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CraftAbstractArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftAbstractArrow(CraftServer server, class_1665 entity) {
        super(server, (class_1297)entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
    }

    public int getKnockbackStrength() {
        return ((IMixinPersistentProjectileEntity)this.getHandle()).getPunchBF();
    }

    public double getDamage() {
        return this.getHandle().field_7571;
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (Object)"Damage must be positive");
        this.getHandle().method_7438(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().method_7447();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (Object)"Pierce level out of range, expected 0 < level < 127");
        this.getHandle().method_7451((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().method_7443();
    }

    public void setCritical(boolean critical) {
        this.getHandle().method_7439(critical);
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().getProjectileSourceBukkit();
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof Entity) {
            this.getHandle().method_7432(((CraftEntity)shooter).getHandle());
        } else {
            this.getHandle().method_7432(null);
        }
        this.getHandle().setProjectileSourceBukkit(shooter);
    }

    public boolean isInBlock() {
        return ((IMixinPersistentProjectileEntity)this.getHandle()).getInGroundBF();
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        class_2338 pos = this.getHandle().method_24515();
        return this.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().field_7572.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        this.getHandle().field_7572 = class_1665.class_1666.method_7458((int)status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        ((IMixinPersistentProjectileEntity)this.getHandle()).setLifeBF(value);
    }

    public boolean isShotFromCrossbow() {
        class_1799 firedFromWeapon = this.getHandle().method_59958();
        return firedFromWeapon != null && firedFromWeapon.method_31574(class_1802.field_8399);
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
    }

    public class_1665 getHandle() {
        return (class_1665)this.nms;
    }

    public String toString() {
        return "CraftArrow";
    }

    @Override
    public EntityType getType() {
        return EntityType.ARROW;
    }

    @Override
    public boolean fromMobSpawner() {
        return false;
    }

    @Override
    public CreatureSpawnEvent.SpawnReason getEntitySpawnReason() {
        return null;
    }

    @Override
    public boolean isInBubbleColumn() {
        return false;
    }

    @Override
    public boolean isInWaterOrBubbleColumn() {
        return false;
    }

    @Override
    public boolean isInWaterOrRain() {
        return false;
    }

    @Override
    public boolean isInWaterOrRainOrBubbleColumn() {
        return false;
    }

    public ItemStack getItemStack() {
        return null;
    }

    @Override
    @Nullable
    public Component customName() {
        return null;
    }

    @Override
    public void customName(@Nullable Component arg0) {
    }

    @Override
    public boolean hasNoPhysics() {
        return this.getHandle().method_7441();
    }

    @Override
    public void setNoPhysics(boolean arg0) {
        this.getHandle().method_7433(arg0);
    }

    @NotNull
    public Sound getHitSound() {
        return Sound.ENTITY_ARROW_SHOOT;
    }

    public int getLifetimeTicks() {
        return 0;
    }

    public void setHitSound(@NotNull Sound arg0) {
    }

    public void setLifetimeTicks(int arg0) {
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().method_54759());
    }

    public void setItem(@NotNull ItemStack item) {
    }

    public void setItemStack(@NotNull ItemStack stack) {
    }

    public ItemStack getWeapon() {
        if (this.getHandle().method_59958() == null) {
            return null;
        }
        return CraftItemStack.asBukkitCopy(this.getHandle().method_59958());
    }

    public void setWeapon(@NotNull ItemStack item) {
        this.getHandle().field_51620 = CraftItemStack.asNMSCopy(item);
    }

    public void setShooter(@Nullable ProjectileSource shooter, boolean resetPickupStatus) {
        if (shooter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)shooter;
            this.getHandle().method_7432(craftEntity.getHandle());
        } else {
            this.getHandle().method_7432(null);
        }
        this.getHandle().setProjectileSourceBukkit(shooter);
    }

    @NotNull
    public @Unmodifiable List<Block> getAttachedBlocks() {
        if (!this.isInBlock()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterator)new class_5329((class_1941)this.getHandle().method_73183(), (class_1297)null, new class_238(this.getHandle().method_73189(), this.getHandle().method_73189()).method_1014(0.06), false, (mutableBlockPos, voxelShape) -> CraftBlock.at((class_3218)this.getHandle().method_73183(), (class_2338)mutableBlockPos)));
    }
}

