/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1668;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5281;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.util.Vector;

public final class CraftEntityTypes {
    private static final BiConsumer<SpawnData, class_1297> POS = (spawnData, entity) -> entity.method_5814(spawnData.x(), spawnData.y(), spawnData.z());
    private static final BiConsumer<SpawnData, class_1297> ABS_MOVE = (spawnData, entity) -> {
        entity.method_5641(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
        entity.method_5847(spawnData.yaw());
    };
    private static final BiConsumer<SpawnData, class_1297> MOVE = (spawnData, entity) -> entity.method_5808(spawnData.x(), spawnData.y(), spawnData.z(), spawnData.yaw(), spawnData.pitch());
    private static final BiConsumer<SpawnData, class_1297> MOVE_EMPTY_ROT = (spawnData, entity) -> entity.method_5808(spawnData.x(), spawnData.y(), spawnData.z(), 0.0f, 0.0f);
    private static final BiConsumer<SpawnData, class_1668> DIRECTION = (spawnData, entity) -> {
        Vector direction = spawnData.location().getDirection().multiply(10);
    };
    private static final BiConsumer<SpawnData, class_1297> ROT = (spawnData, entity) -> entity.method_5710(spawnData.yaw(), spawnData.pitch());
    private static final BiConsumer<SpawnData, class_1297> CLEAR_MOVE_IF_NOT_RANDOMIZED = (spawnData, entity) -> {
        if (!spawnData.randomizeData()) {
            entity.method_18799(class_243.field_1353);
        }
    };
    private static final Map<Class<?>, EntityTypeData<?, ?>> CLASS_TYPE_DATA = new HashMap();
    private static final Map<EntityType, EntityTypeData<?, ?>> ENTITY_TYPE_DATA = new HashMap();

    private static void register(EntityTypeData<?, ?> typeData) {
        EntityTypeData<?, ?> other = CLASS_TYPE_DATA.put(typeData.entityClass(), typeData);
        if (other != null) {
            Bukkit.getLogger().warning(String.format("Found multiple entity type data for class %s, replacing '%s' with new value '%s'", typeData.entityClass().getName(), other, typeData));
        }
        if ((other = ENTITY_TYPE_DATA.put(typeData.entityType(), typeData)) != null) {
            Bukkit.getLogger().warning(String.format("Found multiple entity type data for entity type %s, replacing '%s' with new value '%s'", typeData.entityType().getKey(), other, typeData));
        }
    }

    private static <R extends class_1297> Function<SpawnData, R> fromEntityType(class_1299<R> entityTypes) {
        return spawnData -> entityTypes.method_5883(spawnData.minecraftWorld(), class_3730.field_16462);
    }

    private static <R extends class_1309> Function<SpawnData, R> createLiving(class_1299<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), ABS_MOVE);
    }

    private static <R extends class_1668> Function<SpawnData, R> createFireball(class_1299<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.createAndMove(entityTypes), DIRECTION);
    }

    private static <R extends class_1297> Function<SpawnData, R> createAndMove(class_1299<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), MOVE);
    }

    private static <R extends class_1297> Function<SpawnData, R> createAndMoveEmptyRot(class_1299<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), MOVE_EMPTY_ROT);
    }

    private static <R extends class_1297> Function<SpawnData, R> createAndSetPos(class_1299<R> entityTypes) {
        return CraftEntityTypes.combine(CraftEntityTypes.fromEntityType(entityTypes), POS);
    }

    private static <E extends Hanging, R extends class_1530> Function<SpawnData, R> createHanging(Class<E> clazz, BiFunction<SpawnData, HangingData, R> spawnFunction) {
        return spawnData -> {
            boolean randomizeData = spawnData.randomizeData();
            BlockFace face = BlockFace.SELF;
            BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
            int width = 16;
            int height = 16;
            if (ItemFrame.class.isAssignableFrom(clazz)) {
                width = 12;
                height = 12;
                faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};
            }
            class_2338 pos = class_2338.method_49637((double)spawnData.x(), (double)spawnData.y(), (double)spawnData.z());
            for (BlockFace dir : faces) {
                class_2680 nmsBlock = spawnData.world().method_8320(pos.method_10093(CraftBlock.blockFaceToNotch(dir)));
                if (!nmsBlock.method_51367() && !class_2312.method_9999((class_2680)nmsBlock)) continue;
                boolean taken = false;
                class_238 bb = ItemFrame.class.isAssignableFrom(clazz) ? CraftEntityTypes.ItemFrameEntity_calculateBoundingBox(null, pos, CraftBlock.blockFaceToNotch(dir).method_10153(), width, height) : CraftEntityTypes.AbstractDecorationEntity_calculateBoundingBox(null, pos, CraftBlock.blockFaceToNotch(dir).method_10153(), width, height);
                class_238 box = bb;
                if (!spawnData.world.method_18026(bb)) continue;
                List list = spawnData.world().method_8335(null, bb);
                Iterator it = list.iterator();
                while (!taken && it.hasNext()) {
                    class_1297 e2 = (class_1297)it.next();
                    if (!(e2 instanceof class_1530)) continue;
                    taken = true;
                }
                if (taken) continue;
                face = dir;
                break;
            }
            if (face == BlockFace.SELF) {
                face = BlockFace.SOUTH;
                randomizeData = false;
            }
            class_2350 dir = CraftBlock.blockFaceToNotch(face).method_10153();
            return (class_1530)spawnFunction.apply((SpawnData)spawnData, new HangingData(randomizeData, pos, dir));
        };
    }

    private static class_238 ItemFrameEntity_calculateBoundingBox(class_1297 entity, class_2338 blockPosition, class_2350 direction, int width, int height) {
        double d0 = 0.46875;
        double locX = (double)blockPosition.method_10263() + 0.5 - (double)direction.method_10148() * 0.46875;
        double locY = (double)blockPosition.method_10264() + 0.5 - (double)direction.method_10164() * 0.46875;
        double locZ = (double)blockPosition.method_10260() + 0.5 - (double)direction.method_10165() * 0.46875;
        if (entity != null) {
            entity.method_23327(locX, locY, locZ);
        }
        double d2 = width;
        double d3 = height;
        double d4 = width;
        class_2350.class_2351 enumdirection_enumaxis = direction.method_10166();
        switch (enumdirection_enumaxis) {
            case field_11048: {
                d2 = 1.0;
                break;
            }
            case field_11052: {
                d3 = 1.0;
                break;
            }
            case field_11051: {
                d4 = 1.0;
            }
        }
        return new class_238(locX - (d2 /= 32.0), locY - (d3 /= 32.0), locZ - (d4 /= 32.0), locX + d2, locY + d3, locZ + d4);
    }

    private static double a(int i) {
        return i % 32 == 0 ? 0.5 : 0.0;
    }

    private static class_238 AbstractDecorationEntity_calculateBoundingBox(class_1297 entity, class_2338 blockPosition, class_2350 direction, int width, int height) {
        double d0 = (double)blockPosition.method_10263() + 0.5;
        double d2 = (double)blockPosition.method_10264() + 0.5;
        double d3 = (double)blockPosition.method_10260() + 0.5;
        double d4 = 0.46875;
        double d5 = CraftEntityTypes.a(width);
        double d6 = CraftEntityTypes.a(height);
        d0 -= (double)direction.method_10148() * 0.46875;
        d3 -= (double)direction.method_10165() * 0.46875;
        d2 += d6;
        class_2350 enumdirection = direction.method_10160();
        d0 += d5 * (double)enumdirection.method_10148();
        d3 += d5 * (double)enumdirection.method_10165();
        if (entity != null) {
            entity.method_23327(d0, d2, d3);
        }
        double d7 = width;
        double d8 = height;
        double d9 = width;
        if (direction.method_10166() == class_2350.class_2351.field_11051) {
            d9 = 1.0;
        } else {
            d7 = 1.0;
        }
        return new class_238(d0 - (d7 /= 32.0), d2 - (d8 /= 32.0), d3 - (d9 /= 32.0), d0 + d7, d2 + d8, d3 + d9);
    }

    private static <T, R> Function<T, R> combine(Function<T, R> before, BiConsumer<T, ? super R> after) {
        return t -> {
            Object r = before.apply(t);
            after.accept((Object)t, (Object)r);
            return r;
        };
    }

    public static <E extends Entity, M extends class_1297> EntityTypeData<E, M> getEntityTypeData(EntityType entityType) {
        return ENTITY_TYPE_DATA.get(entityType);
    }

    public static <E extends Entity, M extends class_1297> EntityTypeData<E, M> getEntityTypeData(Class<E> entityClass) {
        return CLASS_TYPE_DATA.get(entityClass);
    }

    private CraftEntityTypes() {
    }

    public record EntityTypeData<E extends Entity, M extends class_1297>(EntityType entityType, Class<E> entityClass, BiFunction<CraftServer, M, E> convertFunction, Function<SpawnData, M> spawnFunction) {
    }

    public record SpawnData(class_5281 world, Location location, boolean randomizeData, boolean normalWorld) {
        double x() {
            return this.location().getX();
        }

        double y() {
            return this.location().getY();
        }

        double z() {
            return this.location().getZ();
        }

        float yaw() {
            return this.location().getYaw();
        }

        float pitch() {
            return this.location().getPitch();
        }

        class_1937 minecraftWorld() {
            return (class_3218)this.world();
        }
    }

    private record HangingData(boolean randomize, class_2338 position, class_2350 direction) {
    }
}

