/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.event;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PlayerConnection;
import io.papermc.paper.event.block.BellRingEvent;
import io.papermc.paper.event.connection.PlayerConnectionValidateLoginEvent;
import io.papermc.paper.event.world.PaperWorldGameRuleChangeEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_12279;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftGameRule;
import org.bukkit.craftbukkit.CraftLootTable;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.damage.CraftDamageSource;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.cardboardpowered.BukkitLogger;
import org.cardboardpowered.CardboardMod;
import org.cardboardpowered.extras.PlayerManager_LoginResult;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.entity.LivingEntityImpl;
import org.cardboardpowered.impl.entity.UnknownEntity;
import org.cardboardpowered.impl.inventory.CardboardInventoryView;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IMixinEntity;
import org.cardboardpowered.interfaces.IMixinInventory;
import org.cardboardpowered.interfaces.IMixinLivingEntity;
import org.cardboardpowered.interfaces.IMixinScreenHandler;
import org.cardboardpowered.interfaces.IMixinServerEntityPlayer;
import org.cardboardpowered.interfaces.IMixinWorld;
import org.jetbrains.annotations.Nullable;

public class CraftEventFactory {
    public static class_1297 entityDamage;

    public static void callEvent(Event e) {
        if (!e.isAsynchronous() && !Bukkit.isPrimaryThread()) {
            CraftServer.server.cardboard_runOnMainThread(() -> CraftServer.INSTANCE.getPluginManager().callEvent(e));
            return;
        }
        CraftServer.INSTANCE.getPluginManager().callEvent(e);
    }

    public static ServerListPingEvent callServerListPingEvent(Server craftServer, InetAddress address, String motd, int numPlayers, int maxPlayers) {
        ServerListPingEvent event = new ServerListPingEvent("", address, motd, numPlayers, maxPlayers);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(class_3218 world, class_1657 who, class_1268 hand, BlockState replacedBlockState, int x, int y, int z) {
        CraftWorld CraftWorld2 = world.getCraftWorld();
        CraftServer craftServer = CraftServer.INSTANCE;
        Player player = (Player)((IMixinServerEntityPlayer)who).getBukkitEntity();
        Block blockClicked = CraftWorld2.getBlockAt(x, y, z);
        Block placedBlock = replacedBlockState.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(world, player, placedBlock.getX(), placedBlock.getZ());
        boolean isMainHand = hand == class_1268.field_5808;
        ItemStack item = isMainHand ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        EquipmentSlot equipmentSlot = isMainHand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedBlockState, blockClicked, item, player, canBuild, equipmentSlot);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockBurnEvent callBlockBurnEvent(class_1937 world, class_2338 pos, @Nullable Block ignitingBlock) {
        BlockBurnEvent event = new BlockBurnEvent(world.getCraftWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), ignitingBlock);
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        return event;
    }

    private static boolean canBuild(class_3218 world, Player player, int x, int z) {
        int spawnSize = Bukkit.getServer().getSpawnRadius();
        if (world.method_27983() != class_1937.field_25179) {
            return true;
        }
        if (spawnSize <= 0) {
            return true;
        }
        if (((CraftServer)Bukkit.getServer()).getHandle().method_3760().method_14603().method_14641()) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        if (null == world.method_74854()) {
            return true;
        }
        class_2338 chunkcoordinates = world.method_74854().method_74897();
        int distanceFromSpawn = Math.max(Math.abs(x - chunkcoordinates.method_10263()), Math.abs(z - chunkcoordinates.method_10260()));
        return distanceFromSpawn > spawnSize;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(class_1937 world, int x, int y, int z, class_1927 explosion) {
        CraftWorld bukkitWorld = world.getCraftWorld();
        CraftEntity igniter = explosion.method_46406() == null ? null : explosion.method_46406().getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(x, y, z), BlockIgniteEvent.IgniteCause.EXPLOSION, (Entity)igniter);
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(class_3222 who, Action action, class_1799 itemstack, class_1268 hand) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new AssertionError((Object)String.format("%s performing %s with %s", who, action, itemstack));
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, null, class_2350.field_11035, itemstack, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(class_3222 who, Action action, class_2338 position, class_2350 direction, class_1799 itemstack, class_1268 hand) {
        return CraftEventFactory.callPlayerInteractEvent(who, action, position, direction, itemstack, false, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(class_3222 who, Action action, class_2338 position, class_2350 direction, class_1799 itemstack, boolean cancelledBlock, class_1268 hand) {
        Player player = who == null ? null : (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        assert (player != null);
        CraftWorld CraftWorld2 = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = null;
        if (position != null) {
            blockClicked = CraftWorld2.getBlockAt(position.method_10263(), position.method_10264(), position.method_10260());
        } else {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                    break;
                }
            }
        }
        BlockFace blockFace = CraftBlock.notchToBlockFace(direction);
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, (ItemStack)itemInHand, blockClicked, blockFace, hand == null ? null : (hand == class_1268.field_5810 ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
        if (cancelledBlock) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(class_3222 who, int x, int y, int z, class_1799 itemstack, boolean instaBreak) {
        Player player = who == null ? null : (Player)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        assert (player != null);
        CraftWorld CraftWorld2 = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = CraftWorld2.getBlockAt(x, y, z);
        BlockDamageEvent event = new BlockDamageEvent(player, blockClicked, (ItemStack)itemInHand, instaBreak);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockRedstoneEvent callRedstoneChange(class_1937 world, class_2338 pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(world.getCraftWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), oldCurrent, newCurrent);
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handlePlayerRecipeListUpdateEvent(class_1657 who, class_2960 recipe) {
        PlayerRecipeDiscoverEvent event = new PlayerRecipeDiscoverEvent((Player)((IMixinServerEntityPlayer)who).getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipe), true);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static void callProjectileHitEvent(class_1297 entity, class_239 position) {
        CraftEntity e;
        if (position.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.method_17783() == class_239.class_240.field_1332) {
            class_3965 positionBlock = (class_3965)position;
            hitBlock = CraftBlock.at((class_3218)entity.method_73183(), positionBlock.method_17777());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.method_17780());
        }
        CraftEntity hitEntity = null;
        if (position.method_17783() == class_239.class_240.field_1331) {
            assert (position instanceof class_3966);
            hitEntity = ((class_3966)position).method_17782().getBukkitEntity();
        }
        if (!((e = entity.getBukkitEntity()) instanceof Projectile)) {
            BukkitLogger.getLogger().warning("Entity \"" + e.nms.method_5477().getString() + "\" is not an instance of Projectile! Can not fire ProjectileHitEvent!");
            return;
        }
        ProjectileHitEvent event = new ProjectileHitEvent((Projectile)entity.getBukkitEntity(), (Entity)hitEntity, (Block)hitBlock, hitFace);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    public static class_1703 callInventoryOpenEvent(class_3222 player, class_1703 container) {
        return CraftEventFactory.callInventoryOpenEvent(player, container, false);
    }

    public static class_1703 callInventoryOpenEvent(class_3222 player, class_1703 container, boolean cancelled) {
        CraftPlayer CraftPlayer2 = (CraftPlayer)player.getBukkitEntity();
        if (!(player.field_7512 instanceof IMixinScreenHandler)) {
            return container;
        }
        CardboardInventoryView bv = ((IMixinScreenHandler)container).getBukkitView();
        bv.setPlayerIfNotSet((CraftPlayer)player.getBukkitEntity());
        try {
            ((IMixinScreenHandler)player.field_7512).transferTo(container, CraftPlayer2);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return container;
        }
        InventoryOpenEvent event = new InventoryOpenEvent((InventoryView)bv);
        event.setCancelled(cancelled);
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ((IMixinScreenHandler)container).transferTo(player.field_7512, CraftPlayer2);
            return null;
        }
        return container;
    }

    public static FireworkExplodeEvent callFireworkExplodeEvent(class_1671 firework) {
        FireworkExplodeEvent event = new FireworkExplodeEvent((Firework)firework.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VillagerCareerChangeEvent callVillagerCareerChangeEvent(class_1646 vilager, Villager.Profession future, VillagerCareerChangeEvent.ChangeReason reason) {
        VillagerCareerChangeEvent event = new VillagerCareerChangeEvent((Villager)vilager.getBukkitEntity(), future, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockFormEvent(class_1937 world, class_2338 pos, class_2680 block, class_1297 entity) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3, entity);
    }

    public static boolean handleBlockFormEvent(class_1937 world, class_2338 pos, class_2680 block, int flag, class_1297 entity) {
        CraftBlockState blockState = CraftBlockState.getBlockState(world, pos, flag);
        blockState.setData(block);
        BlockFormEvent event = entity == null ? new BlockFormEvent((Block)blockState.getBlock(), (BlockState)blockState) : new EntityBlockFormEvent((Entity)entity.getBukkitEntity(), (Block)blockState.getBlock(), (BlockState)blockState);
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            blockState.update(true);
        }
        return !event.isCancelled();
    }

    public static Cancellable handleStatisticsIncrease(class_1657 entityHuman, class_3445<?> statistic, int current, int newValue) {
        PlayerStatisticIncrementEvent event;
        Player player = (Player)((IMixinServerEntityPlayer)entityHuman).getBukkitEntity();
        if (!Arrays.asList(Statistic.values()).contains(statistic)) {
            return null;
        }
        Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
        if (stat == null) {
            System.err.println("Unhandled statistic: " + String.valueOf(statistic));
            return null;
        }
        switch (stat) {
            case FALL_ONE_CM: 
            case BOAT_ONE_CM: 
            case CLIMB_ONE_CM: 
            case WALK_ON_WATER_ONE_CM: 
            case WALK_UNDER_WATER_ONE_CM: 
            case FLY_ONE_CM: 
            case HORSE_ONE_CM: 
            case MINECART_ONE_CM: 
            case PIG_ONE_CM: 
            case PLAY_ONE_MINUTE: 
            case SWIM_ONE_CM: 
            case WALK_ONE_CM: 
            case SPRINT_ONE_CM: 
            case CROUCH_ONE_CM: 
            case TIME_SINCE_DEATH: 
            case SNEAK_TIME: {
                return null;
            }
        }
        if (stat.getType() == Statistic.Type.UNTYPED) {
            event = new PlayerStatisticIncrementEvent(player, stat, current, newValue);
        } else if (stat.getType() == Statistic.Type.ENTITY) {
            EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent(player, stat, current, newValue, entityType);
        } else {
            Material material = CraftStatistic.getMaterialFromStatistic(statistic);
            assert (material != null);
            event = new PlayerStatisticIncrementEvent(player, stat, current, newValue, material);
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        return (Cancellable)event;
    }

    public static EntityPickupItemEvent callEntityPickupItemEvent(class_1297 who, class_1542 item, int remaining, boolean cancelled) {
        EntityPickupItemEvent event = new EntityPickupItemEvent((LivingEntity)who.getBukkitEntity(), (Item)item.getBukkitEntity(), remaining);
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityEnterLoveModeEvent callEntityEnterLoveModeEvent(class_1657 entityHuman, class_1429 entityAnimal, int loveTicks) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = new EntityEnterLoveModeEvent((Animals)entityAnimal.getBukkitEntity(), entityHuman != null ? (HumanEntity)entityHuman.getBukkitEntity() : null, loveTicks);
        Bukkit.getPluginManager().callEvent((Event)entityEnterLoveModeEvent);
        return entityEnterLoveModeEvent;
    }

    public static class_1799 callPreCraftEvent(class_1263 matrix, class_1263 resultInventory, class_1799 result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent((CraftingInventory)inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent((Event)event);
        ItemStack bitem = event.getInventory().getResult();
        return CraftItemStack.asNMSCopy(bitem);
    }

    public static EntityTransformEvent callEntityTransformEvent(class_1309 original, class_1309 coverted, EntityTransformEvent.TransformReason transformReason) {
        return CraftEventFactory.callEntityTransformEvent(original, Collections.singletonList(coverted), transformReason);
    }

    public static EntityTransformEvent callEntityTransformEvent(class_1309 original, List<class_1309> convertedList, EntityTransformEvent.TransformReason convertType) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (class_1309 entityLiving : convertedList) {
            list.add(entityLiving.getBukkitEntity());
        }
        if (list.size() <= 0) {
            return null;
        }
        EntityTransformEvent event = new EntityTransformEvent((Entity)original.getBukkitEntity(), list, convertType);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityPlaceEvent callEntityPlaceEvent(class_1838 itemactioncontext, class_1297 entity) {
        return CraftEventFactory.callEntityPlaceEvent(itemactioncontext.method_8045(), itemactioncontext.method_8037(), itemactioncontext.method_8038(), itemactioncontext.method_8036(), entity);
    }

    public static EntityPlaceEvent callEntityPlaceEvent(class_1937 world, class_2338 clickPosition, class_2350 clickedFace, class_1657 human, class_1297 entity) {
        Player who = human == null ? null : (Player)human.getBukkitEntity();
        CraftBlock blockClicked = CraftBlock.at((class_3218)world, clickPosition);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent((Entity)entity.getBukkitEntity(), who, (Block)blockClicked, blockFace);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityPlaceEvent callEntityPlaceEvent(class_1937 world, class_2338 clickPosition, class_2350 clickedFace, class_1657 human, class_1297 entity, class_1268 enumhand) {
        Player who = human == null ? null : (Player)human.getBukkitEntity();
        CraftBlock blockClicked = CraftBlock.at((class_3218)world, clickPosition);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent((Entity)entity.getBukkitEntity(), who, (Block)blockClicked, blockFace);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static CreeperPowerEvent callCreeperPowerEvent(class_1297 creeper, class_1297 lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)creeper.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerItemBreakEvent(class_1657 human, class_1799 brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)human.getBukkitEntity(), (ItemStack)item);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(class_1297 entity, class_1309 target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), target == null ? null : (LivingEntity)entity.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static HorseJumpEvent callHorseJumpEvent(class_1297 horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((AbstractHorse)horse.getBukkitEntity(), power);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemMergeEvent callItemMergeEvent(class_1542 merging, class_1542 mergingWith) {
        Item entityMerging = (Item)merging.getBukkitEntity();
        Item entityMergingWith = (Item)mergingWith.getBukkitEntity();
        ItemMergeEvent event = new ItemMergeEvent(entityMerging, entityMergingWith);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(class_3222 victim, class_1282 damageSource, List<ItemStack> drops, String deathMessage, boolean keepInventory) {
        CraftPlayer entity = (CraftPlayer)victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        PlayerDeathEvent event = new PlayerDeathEvent((Player)entity, (DamageSource)bukkitDamageSource, drops, ((IMixinLivingEntity)victim).getExpReward(), 0, deathMessage);
        event.setKeepInventory(keepInventory);
        World world = entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            world.dropItem(entity.getLocation(), stack);
        }
        return event;
    }

    public static LootGenerateEvent callLootGenerateEvent(class_1263 inventory, class_52 lootTable, class_47 lootInfo, List<class_1799> loot, boolean plugin) {
        CraftWorld world = lootInfo.method_299().getCraftWorld();
        class_1297 entity = (class_1297)lootInfo.method_65013(class_181.field_1226);
        NamespacedKey key = null;
        class_2378 reg = CraftServer.server.method_30611().method_30530(class_7924.field_50079);
        Optional opt = reg.method_29113((Object)lootTable);
        if (opt.isPresent()) {
            key = CraftLootTable.minecraftToBukkitKey((class_5321<class_52>)((class_5321)opt.get()));
        }
        CraftLootTable craftLootTable = new CraftLootTable(key, lootTable);
        List bukkitLoot = loot.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        LootGenerateEvent event = new LootGenerateEvent((World)world, (Entity)(entity != null ? entity.getBukkitEntity() : null), ((IMixinInventory)inventory).getOwner(), (LootTable)craftLootTable, CraftLootTable.convertContext(lootInfo), bukkitLoot, plugin);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityDeathEvent callEntityDeathEvent(class_1309 victim, class_1282 damageSource, List<ItemStack> drops) {
        if (victim.getBukkitEntity() instanceof UnknownEntity) {
            UnknownEntity uk = (UnknownEntity)victim.getBukkitEntity();
            CardboardMod.LOGGER.info("Oh no! " + class_1299.method_5890((class_1299)uk.nms.method_5864()).toString() + " is an unknown bukkit entity!");
        }
        LivingEntityImpl entity = (LivingEntityImpl)victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        EntityDeathEvent event = new EntityDeathEvent((LivingEntity)entity, (DamageSource)bukkitDamageSource, drops, ((IMixinLivingEntity)victim).getExpReward());
        if (null == entity || null == entity.getWorld()) {
            boolean e = null == entity;
            CardboardMod.LOGGER.info("WARNING: Null " + (e ? "entity" : "world") + "!");
            return event;
        }
        CraftWorld world = (CraftWorld)entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
            world.dropItem(entity.getLocation(), stack);
            if (!(stack instanceof CraftItemStack)) continue;
            stack.setAmount(0);
        }
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(class_1297 entity, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)entity.getBukkitEntity();
        ExpBottleEvent event = new ExpBottleEvent(bottle, exp);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(class_1309 who, class_1799 bow, class_1799 consumableItem, class_1297 entityArrow, class_1268 hand, float force, boolean consumeItem) {
        EquipmentSlot handSlot;
        LivingEntity shooter = (LivingEntity)who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(bow);
        CraftItemStack itemConsumable = CraftItemStack.asCraftMirror(consumableItem);
        CraftEntity arrow = entityArrow.getBukkitEntity();
        EquipmentSlot equipmentSlot = handSlot = hand == class_1268.field_5808 ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, (ItemStack)itemInHand, (ItemStack)itemConsumable, (Entity)arrow, handSlot, force, consumeItem);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(class_3218 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemInHand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, who, changed, clicked, clickedFace, itemInHand, class_1802.field_8550);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(class_3218 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemInHand, class_1792 bucket) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, who, clicked, changed, clickedFace, itemInHand, bucket);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, class_3218 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemstack, class_1792 item) {
        return CraftEventFactory.getPlayerBucketEvent(isFilling, (class_1937)world, who, changed, clicked, clickedFace, itemstack, item, null);
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(class_1937 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemstack, class_1268 enumHand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, who, changed, clicked, clickedFace, itemstack, class_1802.field_8550, enumHand);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(class_1937 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemInHand, class_1792 bucket, class_1268 enumHand) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, who, clicked, changed, clickedFace, itemInHand, bucket, enumHand);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, class_1937 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemstack, class_1792 item, class_1268 enumHand) {
        PlayerBucketFillEvent event;
        Player player = (Player)((IMixinServerEntityPlayer)who).getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucket = CraftMagicNumbers.getMaterial(itemstack.method_7909());
        CraftServer craftServer = (CraftServer)player.getServer();
        CraftBlock block = CraftBlock.at((class_3218)world, changed);
        CraftBlock blockClicked = CraftBlock.at((class_3218)world, clicked);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        if (isFilling) {
            event = new PlayerBucketFillEvent(player, (Block)block, (Block)blockClicked, blockFace, bucket, (ItemStack)itemInHand);
            event.setCancelled(!CraftEventFactory.canBuild((class_3218)world, player, changed.method_10263(), changed.method_10260()));
        } else {
            event = new PlayerBucketEmptyEvent(player, (Block)block, (Block)blockClicked, blockFace, bucket, (ItemStack)itemInHand);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild((class_3218)world, player, changed.method_10263(), changed.method_10260()));
        }
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(class_1937 world, class_2338 pos, BlockIgniteEvent.IgniteCause cause, class_1297 igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent(world.getCraftWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), cause, (Entity)igniter.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Deprecated
    public static PlayerExpChangeEvent callPlayerExpChangeEvent1(class_1657 entity, int expAmount) {
        Player player = (Player)entity.getBukkitEntity();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(class_1657 entity, class_1303 entityOrb, int expAmount) {
        Player player = (Player)entity.getBukkitEntity();
        ExperienceOrb source = (ExperienceOrb)entityOrb.getBukkitEntity();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, (Entity)source, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Deprecated
    public static PlayerExpChangeEvent callPlayerExpChangeEvent_old(class_1657 entity, class_1303 entityOrb) {
        Player player = (Player)entity.getBukkitEntity();
        ExperienceOrb source = (ExperienceOrb)entityOrb.getBukkitEntity();
        int expAmount = source.getExperience();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerItemMendEvent callPlayerItemMendEvent(class_1657 entity, class_1303 orb, class_1799 nmsMendedItem, int repairAmount) {
        Player player = (Player)entity.getBukkitEntity();
        CraftItemStack bukkitStack = CraftItemStack.asCraftMirror(nmsMendedItem);
        PlayerItemMendEvent event = new PlayerItemMendEvent(player, (ItemStack)bukkitStack, (ExperienceOrb)orb.getBukkitEntity(), repairAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handlePlayerShearEntityEvent(class_1309 player, class_1297 sheared, class_1799 shears, class_1268 hand) {
        if (!(player instanceof class_1657)) {
            return true;
        }
        PlayerShearEntityEvent event = new PlayerShearEntityEvent((Player)player.getBukkitEntity(), (Entity)sheared.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(shears), hand == class_1268.field_5810 ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND, Lists.transform(Collections.emptyList(), CraftItemStack::asCraftMirror));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PlayerUnleashEntityEvent callPlayerUnleashEntityEvent(class_1308 entity, class_1657 player) {
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent((Entity)entity.getBukkitEntity(), (Player)player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(class_1308 entity, class_1297 leashHolder, class_1657 player) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent((Entity)entity.getBukkitEntity(), (Entity)leashHolder.getBukkitEntity(), (Player)player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(class_1297 entity, class_2338 pos) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at((class_3218)entity.method_73183(), pos);
        CraftBlockData bd = CraftBlockData.createData(block.getNMS());
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)entity1, (Block)block, (BlockData)bd);
        entity1.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(class_1297 entity, class_2338 pos, BlockState newState) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at((class_3218)entity.method_73183(), pos);
        CraftBlockData bd = CraftBlockData.createData(block.getNMS());
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)entity1, (Block)block, (BlockData)bd);
        entity1.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockSpreadEvent(class_1937 world, class_2338 source, class_2338 target, class_2680 block, int flag) {
        if (!(world instanceof class_1937)) {
            world.method_8652(target, block, flag);
            return true;
        }
        CraftBlockState state = CraftBlockState.getBlockState(world, target, flag);
        state.setData(block);
        BlockSpreadEvent event = new BlockSpreadEvent(world.getCraftWorld().getBlockAt(target.method_10263(), target.method_10264(), target.method_10260()), world.getCraftWorld().getBlockAt(source.method_10263(), source.method_10264(), source.method_10260()), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(class_1297 entity, class_2338 position, class_2680 newBlock) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, position, newBlock, false);
    }

    public static EntityChangeBlockEvent callEntityChangeBlockEvent(class_1297 entity, class_2338 position, class_2680 newBlock, boolean cancelled) {
        Block block = ((IMixinWorld)entity).getCraftWorld().getBlockAt(position.method_10263(), position.method_10264(), position.method_10260());
        EntityChangeBlockEvent event = new EntityChangeBlockEvent((Entity)entity.getBukkitEntity(), block, (BlockData)CraftBlockData.fromData(newBlock));
        event.setCancelled(cancelled);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockGrowEvent(class_1937 world, class_2338 pos, class_2680 block) {
        return CraftEventFactory.handleBlockGrowEvent(world, pos, block, 3);
    }

    public static boolean handleBlockGrowEvent(class_1937 world, class_2338 pos, class_2680 newData, int flag) {
        Block block = world.getCraftWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockGrowEvent event = new BlockGrowEvent(block, (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static BlockFadeEvent callBlockFadeEvent(class_1936 world, class_2338 pos, class_2680 newBlock) {
        CraftBlockState state = CraftBlockState.getBlockState(world, pos);
        state.setData(newBlock);
        BlockFadeEvent event = new BlockFadeEvent((Block)state.getBlock(), (BlockState)state);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Deprecated
    public static boolean handleBellRingEvent_(class_3218 world, class_2338 pos, class_1297 entity) {
        return false;
    }

    public static boolean handleBellRingEvent(class_3218 world, class_2338 position, class_2350 direction, class_1297 entity) {
        CraftBlock block = CraftBlock.at(world, position);
        BlockFace bukkitDirection = CraftBlock.notchToBlockFace(direction);
        BellRingEvent event = new BellRingEvent((Block)block, bukkitDirection, (Entity)(entity != null ? entity.getBukkitEntity() : null));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityBreedEvent callEntityBreedEvent(LivingEntity child, LivingEntity mother, LivingEntity father, LivingEntity breeder, class_1799 bredWith, int experience) {
        LivingEntity breederEntity = (LivingEntity)(breeder == null ? null : ((IMixinEntity)breeder).getBukkitEntity());
        CraftItemStack bredWithStack = bredWith == null ? null : CraftItemStack.asCraftMirror(bredWith).clone();
        EntityBreedEvent event = new EntityBreedEvent((LivingEntity)((IMixinEntity)child).getBukkitEntity(), (LivingEntity)((IMixinEntity)mother).getBukkitEntity(), (LivingEntity)((IMixinEntity)father).getBukkitEntity(), breederEntity, (ItemStack)bredWithStack, experience);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callPlayerSignOpenEvent(class_1657 player, class_2625 tileEntitySign, boolean front, PlayerSignOpenEvent.Cause cause) {
        CraftBlock block = CraftBlock.at((class_3218)tileEntitySign.method_10997(), tileEntitySign.method_11016());
        Sign sign = (Sign)CraftBlockStates.getBlockState(block);
        Side side = front ? Side.FRONT : Side.BACK;
        return CraftEventFactory.callPlayerSignOpenEvent((Player)player.getBukkitEntity(), sign, side, cause);
    }

    public static boolean callPlayerSignOpenEvent(Player player, Sign sign, Side side, PlayerSignOpenEvent.Cause cause) {
        PlayerSignOpenEvent event = new PlayerSignOpenEvent(player, sign, side, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static class_2561 handleLoginResult(PlayerManager_LoginResult result, PlayerConnection paperConnection, class_2535 connection, GameProfile profile, MinecraftServer server, boolean loginPhase) {
        PlayerConnectionValidateLoginEvent event = new PlayerConnectionValidateLoginEvent(paperConnection, result.isAllowed() ? null : PaperAdventure.asAdventure(result.message()));
        event.callEvent();
        if (null == event.getKickMessage()) {
            return null;
        }
        class_2561 disconnectReason = PaperAdventure.asVanilla(event.getKickMessage());
        return disconnectReason;
    }

    public static PlayerExpCooldownChangeEvent callPlayerXpCooldownEvent(class_1657 entity, int newCooldown, PlayerExpCooldownChangeEvent.ChangeReason changeReason) {
        Player player = (Player)((IMixinServerEntityPlayer)entity).getBukkitEntity();
        PlayerExpCooldownChangeEvent event = new PlayerExpCooldownChangeEvent(player, newCooldown, changeReason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static <T> GameRuleSetResult<T> handleGameRuleSet(class_12279<T> rule, T value, class_3218 level, @Nullable CommandSender sender) {
        String valueStr = rule.method_76146(value);
        PaperWorldGameRuleChangeEvent event = new PaperWorldGameRuleChangeEvent(level.getWorld(), sender, CraftGameRule.minecraftToBukkit(rule), valueStr);
        if (event.callEvent()) {
            if (!event.getValue().equals(valueStr)) {
                value = rule.method_76147(event.getValue()).getOrThrow();
            }
            level.method_64395().method_76186(rule, value, level.method_8503());
            return new GameRuleSetResult<T>(value, false);
        }
        return new GameRuleSetResult<Object>(level.method_64395().method_76185(rule), true);
    }

    public record GameRuleSetResult<T>(T value, boolean cancelled) {
    }
}

