/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.generator;

import com.javazilla.bukkitfabric.Utils;
import io.papermc.paper.world.flag.PaperFeatureFlagProviderImpl;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1959;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7699;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.bukkit.FeatureFlag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CraftWorldInfo
implements WorldInfo {
    private final String name;
    private final UUID uuid;
    private final World.Environment environment;
    private final long seed;
    private final int minHeight;
    private final int maxHeight;
    private final class_7699 enabledFeatures;
    private final class_2794 vanillaChunkGenerator;
    private final class_5455.class_6890 registryAccess;

    public CraftWorldInfo(class_31 worldDataServer, class_32.class_5143 session, World.Environment environment, class_2874 dimensionManager, class_2794 chunkGenerator, class_5455.class_6890 registryAccess) {
        this.registryAccess = registryAccess;
        this.vanillaChunkGenerator = chunkGenerator;
        this.name = worldDataServer.method_150();
        this.uuid = Utils.getWorldUUID(session.field_23768.comp_732().toFile());
        this.environment = environment;
        this.seed = worldDataServer.method_28057().method_28028();
        this.minHeight = dimensionManager.comp_651();
        this.maxHeight = dimensionManager.comp_651() + dimensionManager.comp_652();
        this.enabledFeatures = worldDataServer.method_45560();
    }

    public String getName() {
        return this.name;
    }

    public UUID getUID() {
        return this.uuid;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public BiomeProvider vanillaBiomeProvider() {
        class_7138 randomState;
        class_2794 class_27942 = this.vanillaChunkGenerator;
        if (class_27942 instanceof class_3754) {
            class_3754 noiseBasedChunkGenerator = (class_3754)class_27942;
            randomState = class_7138.method_41556((class_5284)((class_5284)noiseBasedChunkGenerator.method_41541().comp_349()), (class_7871)this.registryAccess.method_30530(class_7924.field_41244), (long)this.getSeed());
        } else {
            randomState = class_7138.method_41556((class_5284)class_5284.method_44323(), (class_7871)this.registryAccess.method_30530(class_7924.field_41244), (long)this.getSeed());
        }
        final List<Biome> possibleBiomes = this.vanillaChunkGenerator.method_12098().method_28443().stream().map(biome -> CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)biome)).toList();
        return new BiomeProvider(){

            public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                return CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)CraftWorldInfo.this.vanillaChunkGenerator.method_12098().method_38109(x >> 2, y >> 2, z >> 2, randomState.method_42371()));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return PaperFeatureFlagProviderImpl.fromNms(this.enabledFeatures);
    }
}

