/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.inventory.CraftMetaSuspiciousStew;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="ItemMeta")
public final class SerializableMeta
implements ConfigurationSerializable {
    static final String TYPE_FIELD = "meta-type";
    static final ImmutableMap<Class<? extends CraftMetaItem>, String> classMap = ImmutableMap.builder().put(CraftMetaArmorStand.class, (Object)"ARMOR_STAND").put(CraftMetaBanner.class, (Object)"BANNER").put(CraftMetaBlockState.class, (Object)"TILE_ENTITY").put(CraftMetaBook.class, (Object)"BOOK").put(CraftMetaBookSigned.class, (Object)"BOOK_SIGNED").put(CraftMetaSkull.class, (Object)"SKULL").put(CraftMetaLeatherArmor.class, (Object)"LEATHER_ARMOR").put(CraftMetaMap.class, (Object)"MAP").put(CraftMetaPotion.class, (Object)"POTION").put(CraftMetaSpawnEgg.class, (Object)"SPAWN_EGG").put(CraftMetaEnchantedBook.class, (Object)"ENCHANTED").put(CraftMetaFirework.class, (Object)"FIREWORK").put(CraftMetaCharge.class, (Object)"FIREWORK_EFFECT").put(CraftMetaKnowledgeBook.class, (Object)"KNOWLEDGE_BOOK").put(CraftMetaCrossbow.class, (Object)"CROSSBOW").put(CraftMetaSuspiciousStew.class, (Object)"SUSPICIOUS_STEW").put(CraftMetaEntityTag.class, (Object)"ENTITY_TAG").put(CraftMetaItem.class, (Object)"UNSPECIFIC").build();
    static final ImmutableMap<String, Constructor<? extends CraftMetaItem>> constructorMap;

    private SerializableMeta() {
    }

    public static ItemMeta deserialize(Map<String, Object> map) throws Throwable {
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (Object)"Cannot deserialize null map");
        String type = SerializableMeta.getString(map, TYPE_FIELD, false);
        Constructor constructor = (Constructor)constructorMap.get((Object)type);
        if (constructor == null) {
            throw new IllegalArgumentException(type + " is not a valid meta-type");
        }
        try {
            return (ItemMeta)constructor.newInstance(map);
        }
        catch (InstantiationException e2) {
            throw new AssertionError((Object)e2);
        }
        catch (IllegalAccessException e3) {
            throw new AssertionError((Object)e3);
        }
        catch (InvocationTargetException e4) {
            throw e4.getCause();
        }
    }

    public Map<String, Object> serialize() {
        throw new AssertionError();
    }

    public static String getString(Map<?, ?> map, Object field, boolean nullable) {
        return SerializableMeta.getObject(String.class, map, field, nullable);
    }

    public static boolean getBoolean(Map<?, ?> map, Object field) {
        Boolean value = SerializableMeta.getObject(Boolean.class, map, field, true);
        return value != null && value != false;
    }

    public static <T> T getObject(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
        Object object = map.get(field);
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if (object == null) {
            if (!nullable) {
                throw new NoSuchElementException(String.valueOf(map) + " does not contain " + String.valueOf(field));
            }
            return null;
        }
        throw new IllegalArgumentException(String.valueOf(field) + "(" + String.valueOf(object) + ") is not a valid " + String.valueOf(clazz));
    }

    public static <T> Optional<T> getObjectOptionally(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
        Object object = map.get(field);
        if (clazz.isInstance(object)) {
            return Optional.of(clazz.cast(object));
        }
        if (object == null) {
            if (!nullable) {
                throw new NoSuchElementException(String.valueOf(map) + " does not contain " + String.valueOf(field));
            }
            return Optional.empty();
        }
        throw new IllegalArgumentException(String.valueOf(field) + "(" + String.valueOf(object) + ") is not a valid " + String.valueOf(clazz));
    }

    public static <T> List<T> getList(Class<T> clazz, Map<?, ?> map, Object field) {
        ArrayList<Object> result = new ArrayList<Object>();
        List list = SerializableMeta.getObject(List.class, map, field, true);
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (Object object : list) {
            Object cast = null;
            if (clazz.isInstance(object)) {
                cast = clazz.cast(object);
            }
            if ((clazz == Float.class || clazz == Double.class) && Number.class.isInstance(object)) {
                Number number = (Number)Number.class.cast(object);
                cast = clazz == Float.class ? (Object)clazz.cast(Float.valueOf(number.floatValue())) : (Object)clazz.cast(number.doubleValue());
            }
            if (cast == null) continue;
            result.add(cast);
        }
        return result;
    }

    static {
        ImmutableMap.Builder classConstructorBuilder = ImmutableMap.builder();
        for (Map.Entry mapping : classMap.entrySet()) {
            try {
                classConstructorBuilder.put((Object)((String)mapping.getValue()), ((Class)mapping.getKey()).getDeclaredConstructor(Map.class));
            }
            catch (NoSuchMethodException e2) {
                throw new AssertionError((Object)e2);
            }
        }
        constructorMap = classConstructorBuilder.build();
    }
}

