/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_2751;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_8646;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboard;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.util.WeakCollection;
import org.cardboardpowered.interfaces.IMixinPlayerManager;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CardboardScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CardboardScoreboard> scoreboards = new WeakCollection<CardboardScoreboard>();
    private final Map<CraftPlayer, CardboardScoreboard> playerBoards = new HashMap<CraftPlayer, CardboardScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, class_269 scoreboardServer) {
        this.mainScoreboard = new CardboardScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    public CardboardScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    public CardboardScoreboard getNewScoreboard() {
        CardboardScoreboard scoreboard = new CardboardScoreboard((class_269)new class_2995(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CardboardScoreboard getPlayerBoard(CraftPlayer player) {
        CardboardScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, Scoreboard bukkitScoreboard) throws IllegalArgumentException {
        Validate.isTrue(bukkitScoreboard instanceof CardboardScoreboard, "Cannot set player scoreboard to an unregistered Scoreboard");
        CardboardScoreboard scoreboard = (CardboardScoreboard)bukkitScoreboard;
        class_269 oldboard = this.getPlayerBoard(player).getHandle();
        class_269 newboard = scoreboard.getHandle();
        class_3222 entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<class_266> removed = new HashSet<class_266>();
        for (int i = 0; i < 3; ++i) {
            class_266 scoreboardobjective = oldboard.method_1189(class_8646.values()[i]);
            if (scoreboardobjective == null || removed.contains(scoreboardobjective)) continue;
            entityplayer.field_13987.method_14364((class_2596)new class_2751(scoreboardobjective, 1));
            removed.add(scoreboardobjective);
        }
        Iterator iterator = oldboard.method_1159().iterator();
        ((IMixinPlayerManager)this.server.method_3760()).sendScoreboardBF((class_2995)newboard, player.getHandle());
    }

    public void removePlayer(Player player) {
        this.playerBoards.remove(player);
    }

    public void getScoreboardScores(class_274 criteria, class_9015 holder, Consumer<class_9014> consumer) {
        for (CardboardScoreboard scoreboard : this.scoreboards) {
            class_269 board = scoreboard.board;
            board.method_1162(criteria, holder, consumer::accept);
        }
    }
}

