/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.cardboardpowered.impl.CardboardPotionEffectType;

public class CardboardPotionUtil {
    private static final BiMap<PotionType, String> regular = ImmutableBiMap.builder().put((Object)PotionType.WATER, (Object)"water").put((Object)PotionType.MUNDANE, (Object)"mundane").put((Object)PotionType.THICK, (Object)"thick").put((Object)PotionType.AWKWARD, (Object)"awkward").put((Object)PotionType.NIGHT_VISION, (Object)"night_vision").put((Object)PotionType.INVISIBILITY, (Object)"invisibility").put((Object)PotionType.LEAPING, (Object)"leaping").put((Object)PotionType.FIRE_RESISTANCE, (Object)"fire_resistance").put((Object)PotionType.SWIFTNESS, (Object)"swiftness").put((Object)PotionType.SLOWNESS, (Object)"slowness").put((Object)PotionType.WATER_BREATHING, (Object)"water_breathing").put((Object)PotionType.HEALING, (Object)"healing").put((Object)PotionType.HARMING, (Object)"harming").put((Object)PotionType.POISON, (Object)"poison").put((Object)PotionType.REGENERATION, (Object)"regeneration").put((Object)PotionType.STRENGTH, (Object)"strength").put((Object)PotionType.WEAKNESS, (Object)"weakness").put((Object)PotionType.LUCK, (Object)"luck").put((Object)PotionType.TURTLE_MASTER, (Object)"turtle_master").put((Object)PotionType.SLOW_FALLING, (Object)"slow_falling").build();
    private static final BiMap<PotionType, String> upgradeable = ImmutableBiMap.builder().put((Object)PotionType.LEAPING, (Object)"strong_leaping").put((Object)PotionType.SWIFTNESS, (Object)"strong_swiftness").put((Object)PotionType.HEALING, (Object)"strong_healing").put((Object)PotionType.HARMING, (Object)"strong_harming").put((Object)PotionType.POISON, (Object)"strong_poison").put((Object)PotionType.REGENERATION, (Object)"strong_regeneration").put((Object)PotionType.STRENGTH, (Object)"strong_strength").put((Object)PotionType.SLOWNESS, (Object)"strong_slowness").put((Object)PotionType.TURTLE_MASTER, (Object)"strong_turtle_master").build();
    private static final BiMap<PotionType, String> extendable = ImmutableBiMap.builder().put((Object)PotionType.NIGHT_VISION, (Object)"long_night_vision").put((Object)PotionType.INVISIBILITY, (Object)"long_invisibility").put((Object)PotionType.LEAPING, (Object)"long_leaping").put((Object)PotionType.FIRE_RESISTANCE, (Object)"long_fire_resistance").put((Object)PotionType.SWIFTNESS, (Object)"long_swiftness").put((Object)PotionType.SLOWNESS, (Object)"long_slowness").put((Object)PotionType.WATER_BREATHING, (Object)"long_water_breathing").put((Object)PotionType.POISON, (Object)"long_poison").put((Object)PotionType.REGENERATION, (Object)"long_regeneration").put((Object)PotionType.STRENGTH, (Object)"long_strength").put((Object)PotionType.WEAKNESS, (Object)"long_weakness").put((Object)PotionType.TURTLE_MASTER, (Object)"long_turtle_master").put((Object)PotionType.SLOW_FALLING, (Object)"long_slow_falling").build();

    public static String fromBukkit(PotionData data) {
        String type = data.isUpgraded() ? (String)upgradeable.get((Object)data.getType()) : (data.isExtended() ? (String)extendable.get((Object)data.getType()) : (String)regular.get((Object)data.getType()));
        Preconditions.checkNotNull((Object)type, (Object)("Unknown potion type from data " + String.valueOf(data)));
        return "minecraft:" + type;
    }

    public static PotionData toBukkit(String type) {
        if (type == null) {
            return new PotionData(PotionType.AWKWARD, false, false);
        }
        if (type.startsWith("minecraft:")) {
            type = type.substring(10);
        }
        PotionType potionType = null;
        potionType = (PotionType)extendable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, true, false);
        }
        potionType = (PotionType)upgradeable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, false, true);
        }
        potionType = (PotionType)regular.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, false, false);
        }
        return new PotionData(PotionType.AWKWARD, false, false);
    }

    public static class_1293 fromBukkit_New(PotionEffect effect) {
        class_6880<class_1291> type = CardboardPotionEffectType.bukkitToMinecraftHolder(effect.getType());
        return new class_1293(type, effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static class_1293 fromBukkit(PotionEffect effect) {
        return new class_1293((class_6880)class_7923.field_41174.method_40265(effect.getType().getId()).get(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static PotionEffect toBukkit(class_1293 effect) {
        PotionEffectType type = PotionEffectType.getById((int)class_7923.field_41174.method_10206((Object)((class_1291)effect.method_5579().comp_349())));
        return new PotionEffect(type, effect.method_5584(), effect.method_5578(), effect.method_5591(), effect.method_5581());
    }

    public static boolean equals(class_1291 mobEffect, PotionEffectType type) {
        return PotionEffectType.getById((int)class_7923.field_41174.method_10206((Object)mobEffect)).equals(type);
    }
}

