/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.block;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2387;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.JukeboxInventory;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.impl.inventory.CraftInventoryJukebox;
import org.cardboardpowered.impl.world.CraftWorld;
import org.jetbrains.annotations.NotNull;

public class CardboardJukebox
extends CardboardBlockEntityState<class_2619>
implements Jukebox {
    public CardboardJukebox(World world, class_2619 tileEntity) {
        super(world, tileEntity);
    }

    protected CardboardJukebox(CardboardJukebox state, Location location) {
        super(state, location);
    }

    @Override
    public CardboardJukebox copy() {
        return new CardboardJukebox(this, null);
    }

    @Override
    public CardboardJukebox copy(Location location) {
        return new CardboardJukebox(this, location);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            CraftWorld world = (CraftWorld)this.getWorld();
            Material record = this.getPlaying();
            world.getHandle().method_8652(this.getPosition(), (class_2680)class_2246.field_10223.method_9564().method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(record != Material.AIR)), 3);
            world.playEffect(this.getLocation(), Effect.RECORD_PLAY, record);
        }
        return result;
    }

    public Material getPlaying() {
        return this.getRecord().getType();
    }

    public void setPlaying(Material record) {
        if (record == null || CraftMagicNumbers.getItem(record) == null) {
            record = Material.AIR;
        }
        this.setRecord(new ItemStack(record));
    }

    public ItemStack getRecord() {
        class_1799 record = ((class_2619)this.getSnapshot()).method_54079();
        return CraftItemStack.asBukkitCopy(record);
    }

    public void setRecord(ItemStack record) {
        class_1799 nms = CraftItemStack.asNMSCopy(record);
        ((class_2619)this.getSnapshot()).method_54077(nms);
        this.data = (class_2680)this.data.method_11657((class_2769)class_2387.field_11180, (Comparable)Boolean.valueOf(!nms.method_7960()));
    }

    public boolean isPlaying() {
        return (Boolean)this.getHandle().method_11654((class_2769)class_2387.field_11180);
    }

    public boolean eject() {
        this.requirePlaced();
        class_2586 tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof class_2619)) {
            return false;
        }
        class_2619 jukebox = (class_2619)tileEntity;
        boolean result = !jukebox.method_54079().method_7960();
        jukebox.method_49213();
        return result;
    }

    public void stopPlaying() {
        this.requirePlaced();
        class_2586 tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof class_2619)) {
            return;
        }
        class_2619 jukebox = (class_2619)tileEntity;
        jukebox.method_60784().method_60755((class_1936)tileEntity.method_10997(), tileEntity.method_11010());
    }

    @NotNull
    public JukeboxInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryJukebox((class_1263)this.getTileEntity());
    }

    @NotNull
    public JukeboxInventory getSnapshotInventory() {
        return new CraftInventoryJukebox((class_1263)this.getSnapshot());
    }

    public boolean hasRecord() {
        return (Boolean)this.getHandle().method_11654((class_2769)class_2387.field_11180) != false && !this.getPlaying().isAir();
    }

    public boolean startPlaying() {
        this.requirePlaced();
        class_2586 tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof class_2619)) {
            return false;
        }
        class_2619 jukebox = (class_2619)tileEntity;
        class_1799 record = jukebox.method_54079();
        if (record.method_7960() || this.isPlaying()) {
            return false;
        }
        jukebox.method_60786();
        return true;
    }
}

