/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.entity;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PlayerGameConnection;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.entity.PaperPlayerGiveResult;
import io.papermc.paper.entity.PlayerGiveResult;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.isaiah.common.GameVersion;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11560;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1702;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2625;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2663;
import net.minecraft.class_2668;
import net.minecraft.class_2673;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2693;
import net.minecraft.class_2720;
import net.minecraft.class_2748;
import net.minecraft.class_2749;
import net.minecraft.class_2770;
import net.minecraft.class_2772;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3340;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4076;
import net.minecraft.class_4208;
import net.minecraft.class_5134;
import net.minecraft.class_5217;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5888;
import net.minecraft.class_5894;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_7225;
import net.minecraft.class_7597;
import net.minecraft.class_8043;
import net.minecraft.class_8942;
import net.minecraft.class_9053;
import net.minecraft.class_9782;
import net.minecraft.class_9815;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Input;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.ServerLinks;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.craftbukkit.CraftInput;
import org.bukkit.craftbukkit.CraftOfflinePlayer;
import org.bukkit.craftbukkit.CraftParticle;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftServerLinks;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.scoreboard.CardboardScoreboard;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.cardboardpowered.CardboardMod;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.cardboardpowered.impl.block.CardboardSign;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IChunkDeltaUpdateS2CPacket;
import org.cardboardpowered.interfaces.IMixinClientConnection;
import org.cardboardpowered.interfaces.IMixinEntity;
import org.cardboardpowered.interfaces.IMixinPlayNetworkHandler;
import org.cardboardpowered.interfaces.IMixinPlayerManager;
import org.cardboardpowered.interfaces.IMixinSignBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.UnmodifiableView;
import org.spigotmc.AsyncCatcher;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private final Set<String> channels = new HashSet<String>();
    public class_3222 nms;
    private final Player.Spigot spigot = new Player.Spigot(){
        int err = 0;

        public InetSocketAddress getRawAddress() {
            try {
                return CraftPlayer.this.getRawAddress_BF();
            }
            catch (NullPointerException ex) {
                if (this.err > 3) {
                    System.exit(0);
                    return null;
                }
                ++this.err;
                ex.printStackTrace();
                return CraftPlayer.this.getAddress();
            }
        }

        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.isCollidable();
        }

        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.setCollidable(collides);
        }

        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.nms.method_51469().method_8503().method_3760().method_14556(CraftPlayer.this.getHandle(), false, class_1297.class_5529.field_26998);
            }
        }

        public Set<Player> getHiddenPlayers() {
            return Collections.emptySet();
        }

        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        public void sendMessage(BaseComponent ... components) {
            if (null == CraftPlayer.this.getHandle().field_13987) {
                return;
            }
            CraftPlayer.this.getHandle().method_64398((class_2561)class_2561.method_43470((String)BaseComponent.toLegacyText((BaseComponent[])components)));
        }

        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            if (null == CraftPlayer.this.getHandle().field_13987) {
                return;
            }
            CraftPlayer.this.getHandle().method_64398((class_2561)class_2561.method_43470((String)BaseComponent.toLegacyText((BaseComponent[])components)));
        }
    };
    private static final Component DEFAULT_KICK_COMPONENT = Component.translatable((String)"multiplayer.disconnect.kicked");
    private Component playerListHeader;
    private Component playerListFooter;

    public CraftPlayer(class_3222 entity) {
        super((class_1657)entity);
        ((CraftHumanEntity)this).nms = entity;
        this.nms = entity;
    }

    public class_3222 getHandle() {
        return this.nms;
    }

    @Override
    public UUID getUniqueId() {
        return super.getUniqueId();
    }

    public void abandonConversation(Conversation arg0) {
    }

    public void abandonConversation(Conversation arg0, ConversationAbandonedEvent arg1) {
    }

    public void acceptConversationInput(String arg0) {
    }

    public boolean beginConversation(Conversation arg0) {
        return false;
    }

    public boolean isConversing() {
        return false;
    }

    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic);
    }

    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic);
    }

    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().method_14248(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, amount);
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, amount);
    }

    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().method_14248(), statistic, newValue);
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, material);
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, material);
    }

    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().method_14248(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, material, amount);
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, material, amount);
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().method_14248(), statistic, material, newValue);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, entityType);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, entityType);
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().method_14248(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().method_14248(), statistic, entityType, amount);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().method_14248(), statistic, entityType, amount);
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().method_14248(), statistic, entityType, newValue);
    }

    public long getFirstPlayed() {
        return 0L;
    }

    public long getLastPlayed() {
        return 0L;
    }

    @Override
    public void sendMessage(String message) {
        this.nms.method_64398((class_2561)class_2561.method_43470((String)message));
    }

    public CraftPlayer getPlayer() {
        return this;
    }

    public boolean hasPlayedBefore() {
        return true;
    }

    public boolean isBanned() {
        return this.getServer().getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @Override
    public String getName() {
        return this.nms.method_5820();
    }

    public boolean isOnline() {
        return this.getServer().getPlayer(this.getUniqueId()) != null;
    }

    public boolean isWhitelisted() {
        return CraftServer.server.method_13949().method_14590().method_14653(this.getHandle().method_72498());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            CraftServer.server.method_13949().method_14590().method_74008(new class_3340(this.getHandle().method_72498()));
        } else {
            CraftServer.server.method_13949().method_14590().method_74009(this.getHandle().method_72498());
        }
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public void addChannel(String channel) {
        Preconditions.checkState((this.channels.size() < 128 ? 1 : 0) != 0, (String)"Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel((String)channel))) {
            this.server.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    CardboardMod.LOGGER.log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.sendPayload(class_2960.method_60656((String)"register"), stream.toByteArray());
        }
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)Bukkit.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            channel = StandardMessenger.validateAndCorrectChannel((String)channel);
            this.sendPayload(class_2960.method_60656((String)channel), message);
        }
    }

    private void sendPayload(class_2960 id, byte[] message) {
    }

    public boolean canSee(Player arg0) {
        return true;
    }

    public void chat(String message) {
        ((IMixinPlayNetworkHandler)this.nms.field_13987).chat(message, false);
    }

    public InetSocketAddress getAddress() {
        if (this.nms.field_13987 == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().field_13987.method_48107();
        return addr instanceof InetSocketAddress ? (InetSocketAddress)addr : null;
    }

    public AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        class_2985 data = this.getHandle().method_14236();
        class_167 progress = data.method_12882(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    public boolean getAllowFlight() {
        return this.getHandle().method_31549().field_7478;
    }

    public int getClientViewDistance() {
        return Bukkit.getViewDistance();
    }

    public Location getCompassTarget() {
        return null;
    }

    public String getDisplayName() {
        return null == this.nms.method_5797() ? this.getName() : this.nms.method_5797().getString();
    }

    @Override
    public float getExhaustion() {
        return this.nms.method_7344().field_7752;
    }

    public float getExp() {
        return this.nms.field_7510;
    }

    public float getFlySpeed() {
        return this.getHandle().method_31549().method_7252() * 2.0f;
    }

    @Override
    public int getFoodLevel() {
        return this.nms.method_7344().method_7586();
    }

    public double getHealthScale() {
        return 20.0;
    }

    public int getLevel() {
        return this.nms.field_7520;
    }

    public String getLocale() {
        return "en_US";
    }

    public String getPlayerListFooter() {
        return null;
    }

    public String getPlayerListHeader() {
        return null;
    }

    public String getPlayerListName() {
        return this.getHandle().method_14206() == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().method_14206());
    }

    public long getPlayerTime() {
        return 0L;
    }

    public long getPlayerTimeOffset() {
        return 0L;
    }

    public WeatherType getPlayerWeather() {
        return WeatherType.CLEAR;
    }

    @Override
    public float getSaturation() {
        return this.nms.method_7344().method_7589();
    }

    public CardboardScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    public Entity getSpectatorTarget() {
        class_1297 followed = this.getHandle().method_14242();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    public int getTotalExperience() {
        return this.nms.field_7495;
    }

    public float getWalkSpeed() {
        return this.getHandle().method_31549().field_7482 * 2.0f;
    }

    public void giveExp(int arg0) {
        this.nms.method_7255(arg0);
    }

    public void giveExpLevels(int arg0) {
        this.nms.method_7316(arg0);
    }

    public void hidePlayer(Player arg0) {
    }

    public void hidePlayer(Plugin arg0, Player arg1) {
    }

    public boolean isFlying() {
        return this.nms.method_31549().field_7479;
    }

    public boolean isHealthScaled() {
        return false;
    }

    public boolean isPlayerTimeRelative() {
        return false;
    }

    public boolean isSleepingIgnored() {
        return false;
    }

    @Override
    public boolean isSneaking() {
        return this.nms.method_5715();
    }

    public boolean isSprinting() {
        return this.nms.method_5624();
    }

    public void kickPlayer(String arg0) {
        this.nms.field_13987.method_52396(class_2561.method_30163((String)arg0));
    }

    public void loadData() {
        CraftServer.server.getSaveHandler_BF().method_55789(this.getHandle().method_72498()).map(tag -> class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)this.server.getServer().method_30611(), (class_2487)tag)).ifPresent(arg_0 -> ((class_3222)this.getHandle()).method_5651(arg_0));
    }

    public void openBook(ItemStack book) {
        ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().method_7315(CraftItemStack.asNMSCopy(book), class_1268.field_5808);
        this.getInventory().setItemInMainHand(hand);
    }

    public boolean performCommand(String arg0) {
        return this.getServer().dispatchCommand((CommandSender)this, arg0);
    }

    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        int packetData = effect.getId();
        class_2673 packet = new class_2673(packetData, new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), data, false);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public <T> void playEffect(Location arg0, Effect arg1, T arg2) {
    }

    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        String name = null;
        switch (instrument) {
            case 0: {
                name = "harp";
                break;
            }
            case 1: {
                name = "basedrum";
                break;
            }
            case 2: {
                name = "snare";
                break;
            }
            case 3: {
                name = "hat";
                break;
            }
            case 4: {
                name = "bass";
                break;
            }
            case 5: {
                name = "flute";
                break;
            }
            case 6: {
                name = "bell";
                break;
            }
            case 7: {
                name = "guitar";
                break;
            }
            case 8: {
                name = "chime";
                break;
            }
            case 9: {
                name = "xylophone";
            }
        }
        float f = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument.ordinal()) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
                break;
            }
            case 10: {
                instrumentName = "iron_xylophone";
                break;
            }
            case 11: {
                instrumentName = "cow_bell";
                break;
            }
            case 12: {
                instrumentName = "didgeridoo";
                break;
            }
            case 13: {
                instrumentName = "bit";
                break;
            }
            case 14: {
                instrumentName = "banjo";
                break;
            }
            case 15: {
                instrumentName = "pling";
                break;
            }
            case 16: {
                instrumentName = "xylophone";
            }
        }
        float f = (float)Math.pow(2.0, ((double)note.getId() - 12.0) / 12.0);
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().field_13987 == null) {
            return;
        }
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().field_13987 == null) {
            return;
        }
    }

    public void resetPlayerTime() {
    }

    public void resetPlayerWeather() {
    }

    public void resetTitle() {
        this.nms.field_13987.method_14364((class_2596)new class_5888(true));
    }

    public void saveData() {
        CraftServer.server.getSaveHandler_BF().method_262((class_1657)this.nms);
    }

    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2626 packet = new class_2626(new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), ((CraftBlockData)block).getState());
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2626 packet = new class_2626(new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public boolean sendChunkChange(Location arg0, int arg1, int arg2, int arg3, byte[] arg4) {
        throw new NotImplementedException("Also not in Spigot");
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2748 packet = new class_2748(progress, this.getTotalExperience(), level);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public void sendMap(MapView map) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
    }

    public void sendRawMessage(String arg0) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        for (class_2561 component : CraftChatMessage.fromString(arg0)) {
            this.getHandle().method_64398(component);
        }
    }

    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (lines == null) {
            lines = new String[4];
        }
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        class_2561[] components = CardboardSign.sanitizeLines(lines);
        class_2625 sign = new class_2625(new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), null);
        sign.method_49853().method_49862(class_1767.method_7791((int)dyeColor.getWoolData()));
        System.arraycopy(components, 0, ((IMixinSignBlockEntity)sign).getTextBF(), 0, ((IMixinSignBlockEntity)sign).getTextBF().length);
        this.getHandle().field_13987.method_14364((class_2596)sign.method_38249());
    }

    public void sendTitle(String arg0, String arg1) {
        this.sendTitle(arg0, arg1, 10, 70, 20);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        class_5905 times = new class_5905(fadeIn, stay, fadeOut);
        this.getHandle().field_13987.method_14364((class_2596)times);
        if (title != null) {
            class_5904 packetTitle = new class_5904(CraftChatMessage.fromStringOrNull(title));
            this.getHandle().field_13987.method_14364((class_2596)packetTitle);
        }
        if (subtitle != null) {
            class_5903 packetSubtitle = new class_5903(CraftChatMessage.fromStringOrNull(subtitle));
            this.getHandle().field_13987.method_14364((class_2596)packetSubtitle);
        }
    }

    public void setAllowFlight(boolean arg0) {
        if (this.isFlying() && !arg0) {
            this.getHandle().method_31549().field_7479 = false;
        }
        this.getHandle().method_31549().field_7478 = arg0;
        this.getHandle().method_7355();
    }

    public void setCompassTarget(Location arg0) {
    }

    public void setDisplayName(String arg0) {
        this.nms.method_5880(true);
        this.nms.method_5665((class_2561)class_2561.method_43470((String)arg0));
    }

    @Override
    public void setExhaustion(float arg0) {
        this.nms.method_7322(arg0);
    }

    public void setExp(float arg0) {
        this.nms.method_14228((int)arg0);
    }

    public void setFlySpeed(float arg0) throws IllegalArgumentException {
        class_3222 player = this.getHandle();
        player.method_31549().method_7248(arg0 / 2.0f);
        player.method_7355();
    }

    public void setFlying(boolean arg0) {
        if (!this.getAllowFlight() && arg0) {
            throw new IllegalArgumentException("getAllowFlight() is false, cannot set player flying");
        }
        this.getHandle().method_31549().field_7479 = arg0;
        this.getHandle().method_7355();
    }

    @Override
    public void setFoodLevel(int arg0) {
        this.nms.method_7344().method_7580(arg0);
    }

    public void setHealthScale(double arg0) throws IllegalArgumentException {
    }

    public void setHealthScaled(boolean arg0) {
    }

    public void setLevel(int level) {
        this.nms.method_14252(level);
    }

    public void setPlayerListFooter(String arg0) {
    }

    public void setPlayerListHeader(String arg0) {
    }

    public void setPlayerListHeaderFooter(String arg0, String arg1) {
    }

    public void setPlayerListName(String arg0) {
    }

    public void setPlayerTime(long arg0, boolean arg1) {
    }

    public void setPlayerWeather(WeatherType arg0) {
    }

    public void setResourcePack(@NotNull String url) {
        this.sendPack(url, "null", false, null);
    }

    public void setResourcePack(@NotNull String url, @Nullable byte[] hash) {
        this.sendPack(url, hash == null ? "null" : new String(hash), false, null);
    }

    private void sendPack(String url, String hash, boolean required, String text) {
        UUID id = UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8));
        class_5250 txt = text == null ? null : class_2561.method_43470((String)text);
    }

    @Override
    public void setSaturation(float arg0) {
        this.nms.method_7344().method_7581(arg0);
    }

    public void setScoreboard(Scoreboard scoreboard) {
        class_3244 playerConnection = this.getHandle().field_13987;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        if (((IMixinPlayNetworkHandler)playerConnection).isDisconnected()) {
            throw new IllegalStateException("Cannot set scoreboard for invalid CraftPlayer");
        }
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    public void setSleepingIgnored(boolean arg0) {
    }

    @Override
    public void setSneaking(boolean arg0) {
        this.nms.method_5660(arg0);
    }

    public void setSpectatorTarget(Entity arg0) {
    }

    public void setSprinting(boolean arg0) {
        this.nms.method_5728(arg0);
    }

    public void setTexturePack(String arg0) {
        this.setResourcePack(arg0);
    }

    public void setTotalExperience(int arg0) {
        this.nms.field_7495 = arg0;
    }

    private void validateSpeed(float value) {
        Preconditions.checkArgument((value <= 1.0f && value >= -1.0f ? 1 : 0) != 0, (String)"Speed value (%s) need to be between -1f and 1f", (Object)Float.valueOf(value));
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        class_3222 player = this.getHandle();
        player.method_31549().field_7482 = value / 2.0f;
        player.method_7355();
        this.getHandle().method_5996(class_5134.field_23719).method_6192((double)player.method_31549().field_7482);
    }

    public void showPlayer(Player arg0) {
    }

    public void showPlayer(Plugin arg0, Player arg1) {
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + String.valueOf(particle.getDataType()) + " got " + String.valueOf(data.getClass()));
        }
        boolean force = false;
        class_2675 packetplayoutworldparticles = new class_2675(CraftParticle.createParticleParam(particle, data), false, force, x, y, z, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().field_13987.method_14364((class_2596)packetplayoutworldparticles);
    }

    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(CraftSound.getSound(sound), category);
    }

    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2770(class_2960.method_60656((String)sound), category == null ? class_3419.field_15250 : class_3419.valueOf((String)category.name())));
    }

    public void updateCommands() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.nms.method_51469().method_8503().method_3734().method_9241(this.nms);
    }

    public void updateInventory() {
        this.getHandle().field_7512.method_34252();
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().field_13974.method_14257().method_8379());
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("GameMode cannot be null");
        }
        this.getHandle().method_7336(class_1934.method_8384((int)mode.getValue()));
    }

    public GameProfile getProfile() {
        return this.getHandle().method_7334();
    }

    @Override
    public boolean isOp() {
        try {
            return CraftServer.server.method_13949().method_14569(this.getHandle().method_72498());
        }
        catch (NullPointerException e) {
            try {
                return CraftServer.INSTANCE.getOperatorList().contains(this.getUniqueId().toString());
            }
            catch (IOException ex) {
                class_11560 gp = new class_11560(super.getUniqueId(), this.getName());
                return CraftServer.server.method_13949().method_14569(gp);
            }
        }
    }

    @Override
    public void setOp(boolean value) {
        if (value != this.isOp()) {
            if (value) {
                CraftServer.server.method_13949().method_14582(this.getHandle().method_72498());
            } else {
                CraftServer.server.method_13949().method_14604(this.getHandle().method_72498());
            }
            this.perm.recalculatePermissions();
        }
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        location.checkFinite();
        class_3222 entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.method_31481() || entity.field_13987 == null || entity.method_5782()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)this, from, to, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        entity.method_5848();
        from = event.getFrom();
        to = event.getTo();
        class_3218 toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().field_7514 != this.getHandle().field_7514) {
            this.getHandle().method_7346();
        }
        System.out.println("Hello! " + String.valueOf(from.getWorld()) + " / " + String.valueOf(to.getWorld()));
        if (from.getWorld().equals((Object)to.getWorld())) {
            ((IMixinPlayNetworkHandler)entity.field_13987).teleport(to);
        } else {
            ((IMixinPlayerManager)CraftServer.server.method_13949()).moveToWorld(entity, toWorld, true, to, true);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    public InetSocketAddress getRawAddress_BF() {
        IMixinPlayNetworkHandler im = (IMixinPlayNetworkHandler)this.nms.field_13987;
        return (InetSocketAddress)((IMixinClientConnection)im.cb_get_connection()).getRawAddress();
    }

    public Player.Spigot spigot() {
        return this.spigot;
    }

    public Location getBedSpawnLocation() {
        return this.getRespawnLocation(true);
    }

    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    public void setRespawnLocation(Location location) {
        this.setRespawnLocation(location, false);
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        this.setRespawnLocation(location, override);
    }

    public void setRespawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().method_26284(null, false);
        } else {
            this.getHandle().method_26284(new class_3222.class_10766(new class_5217.class_12064(class_4208.method_19443((class_5321)((CraftWorld)location.getWorld()).getHandle().method_27983(), (class_2338)CraftLocation.toBlockPosition(location)), location.getYaw(), location.getPitch()), override), false);
        }
    }

    public void setFirstPlayed(long modified) {
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    public void updateScaledHealth() {
    }

    public void sendRawMessage(UUID uuid, String msg) {
        this.sendRawMessage(msg);
    }

    public void setHandle(class_3222 plr) {
        this.nms = plr;
        ((CraftHumanEntity)this).nms = plr;
    }

    public void setTitleTimes(int fadeInTicks, int stayTicks, int fadeOutTicks) {
    }

    public void showTitle(BaseComponent[] title) {
    }

    public void setSubtitle(BaseComponent[] subtitle) {
    }

    public void showTitle(BaseComponent title) {
        this.showTitle(new BaseComponent[]{title});
    }

    public void setSubtitle(BaseComponent subtitle) {
        this.showTitle(new BaseComponent[]{subtitle});
    }

    public void showTitle(BaseComponent[] title, BaseComponent[] subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void showTitle(BaseComponent title, BaseComponent subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void sendTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        this.setSubtitle(title.getSubtitle() == null ? new BaseComponent[]{} : title.getSubtitle());
        this.showTitle(title.getTitle());
    }

    public void updateTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        if (title.getSubtitle() != null) {
            this.setSubtitle(title.getSubtitle());
        }
        this.showTitle(title.getTitle());
    }

    public void sendActionBar(BaseComponent[] message) {
        if (this.getHandle().field_13987 != null && message != null) {
            class_5894 packet = new class_5894(CraftChatMessage.bungeeToVanilla(message));
            this.getHandle().field_13987.method_14364((class_2596)packet);
        }
    }

    public void sendActionBar(String message) {
        if (this.getHandle().field_13987 != null && message != null && !message.isEmpty()) {
            this.getHandle().field_13987.method_14364((class_2596)new class_5894(CraftChatMessage.fromStringOrNull(message)));
        }
    }

    public void sendActionBar(char alternateChar, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.sendActionBar(ChatColor.translateAlternateColorCodes((char)alternateChar, (String)message));
    }

    public int getViewDistance() {
        throw new NotImplementedException("Was Removed from Paper");
    }

    public void setViewDistance(int viewDistance) {
        throw new NotImplementedException("Was Removed from Paper");
    }

    @Override
    public void closeInventory(InventoryCloseEvent.Reason arg0) {
    }

    @Override
    public Location getPotentialBedLocation() {
        return null;
    }

    @Override
    public InventoryView openAnvil(Location arg0, boolean arg1) {
        return null;
    }

    @Override
    public InventoryView openCartographyTable(Location arg0, boolean arg1) {
        return null;
    }

    @Override
    public InventoryView openGrindstone(Location arg0, boolean arg1) {
        return null;
    }

    @Override
    public InventoryView openLoom(Location arg0, boolean arg1) {
        return null;
    }

    @Override
    public void openSign(Sign arg0) {
    }

    @Override
    public InventoryView openSmithingTable(Location arg0, boolean arg1) {
        return null;
    }

    @Override
    public InventoryView openStonecutter(Location arg0, boolean arg1) {
        return null;
    }

    @Override
    public Entity releaseLeftShoulderEntity() {
        return null;
    }

    @Override
    public Entity releaseRightShoulderEntity() {
        return null;
    }

    public long getLastLogin() {
        return 0L;
    }

    public long getLastSeen() {
        if (this.isOnline()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public int getProtocolVersion() {
        return GameVersion.INSTANCE.getProtocolVersion();
    }

    public InetSocketAddress getVirtualHost() {
        return null;
    }

    public int applyMending(int arg0) {
        return 0;
    }

    public Firework boostElytra(ItemStack arg0) {
        return null;
    }

    public boolean getAffectsSpawning() {
        return false;
    }

    public String getClientBrandName() {
        return "Vanilla";
    }

    public <T> T getClientOption(ClientOption<T> arg0) {
        return null;
    }

    public float getCooldownPeriod() {
        return this.getHandle().method_7279();
    }

    public float getCooledAttackStrength(float adjustTicks) {
        return this.getHandle().method_7261(adjustTicks);
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this);
    }

    public String getResourcePackHash() {
        return null;
    }

    public PlayerResourcePackStatusEvent.Status getResourcePackStatus() {
        return PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED;
    }

    public void giveExp(int exp, boolean applyMending) {
        if (applyMending) {
            exp = this.applyMending(exp);
        }
        this.getHandle().method_7255(exp);
    }

    public boolean hasResourcePack() {
        return false;
    }

    public void hideTitle() {
        this.getHandle().field_13987.method_14364((class_2596)new class_5888(false));
    }

    public void resetCooldown() {
        this.getHandle().method_7350();
    }

    public void setAffectsSpawning(boolean arg0) {
    }

    public void setPlayerListHeaderFooter(BaseComponent[] arg0, BaseComponent[] arg1) {
    }

    public void setPlayerListHeaderFooter(BaseComponent arg0, BaseComponent arg1) {
    }

    public void setPlayerProfile(PlayerProfile arg0) {
    }

    public void setResourcePack(String arg0, String arg1) {
    }

    @NotNull
    public Component displayName() {
        return Component.text((String)this.getDisplayName());
    }

    public void displayName(@Nullable Component arg0) {
        if (arg0 instanceof TextComponent) {
            this.setDisplayName(((TextComponent)arg0).content());
        }
    }

    public int getPing() {
        return this.getHandle().field_13987.method_52405();
    }

    @Override
    @NotNull
    public Set<Player> getTrackedPlayers() {
        return null;
    }

    public void kick(Component message) {
        this.kick(message, PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick(Component message, PlayerKickEvent.Cause cause) {
        AsyncCatcher.catchOp("player kick");
        class_3244 connection = this.getHandle().field_13987;
        if (connection != null) {
            if (null != message) {
                connection.method_52396(CardboardAdventure.asVanilla((Component)Component.empty()));
            }
            connection.method_52396(CardboardAdventure.asVanilla(message));
        }
    }

    @NotNull
    public Locale locale() {
        return Locale.ENGLISH;
    }

    @Nullable
    public Component playerListFooter() {
        return null;
    }

    @Nullable
    public Component playerListHeader() {
        return null;
    }

    @Nullable
    public Component playerListName() {
        return null;
    }

    public void playerListName(@Nullable Component arg0) {
    }

    public void sendBlockDamage(@NotNull Location loc, float progress) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().field_13987 == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        class_2620 packet = new class_2620(this.getHandle().method_5628(), new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), stage);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public void sendOpLevel(byte level) {
        Preconditions.checkArgument((level >= 0 && level <= 4 ? 1 : 0) != 0, (String)"Level must be within [%s, %s]", (int)0, (int)4);
    }

    public void sendSignChange(@NotNull Location arg0, @Nullable List<? extends Component> arg1) throws IllegalArgumentException {
    }

    public void sendSignChange(@NotNull Location arg0, @Nullable List<? extends Component> arg1, @NotNull DyeColor arg2) throws IllegalArgumentException {
    }

    public boolean breakBlock(@NotNull Block b) {
        return this.nms.field_13974.method_14266(new class_2338(b.getX(), b.getY(), b.getZ()));
    }

    public int getNoTickViewDistance() {
        return 0;
    }

    public int getSendViewDistance() {
        return 0;
    }

    public void sendSignChange(@NotNull Location arg0, @Nullable List<? extends Component> arg1, @NotNull DyeColor arg2, boolean arg3) throws IllegalArgumentException {
    }

    public void sendSignChange(@NotNull Location arg0, @Nullable String[] arg1, @NotNull DyeColor arg2, boolean arg3) throws IllegalArgumentException {
    }

    public void setNoTickViewDistance(int i) {
    }

    public void setResourcePack(@NotNull String arg0, @NotNull String arg1, boolean arg2) {
    }

    public void setResourcePack(@NotNull String arg0, @NotNull String arg1, boolean arg2, @Nullable Component arg3) {
        this.setResourcePack(arg0, arg1, arg2);
    }

    public void setSendViewDistance(int i) {
    }

    public void stopAllSounds() {
    }

    public boolean canSee(@NotNull Entity arg0) {
        return true;
    }

    @Nullable
    public GameMode getPreviousGameMode() {
        class_1934 previousGameMode = this.getHandle().field_13974.method_30119();
        return previousGameMode == null ? null : GameMode.getByValue((int)previousGameMode.method_8379());
    }

    public int getSimulationDistance() {
        return 0;
    }

    @Nullable
    public WorldBorder getWorldBorder() {
        return null;
    }

    public void hideEntity(@NotNull Plugin arg0, @NotNull Entity arg1) {
    }

    public boolean isAllowingServerListings() {
        return false;
    }

    public void kick() {
        this.kick(DEFAULT_KICK_COMPONENT);
    }

    public void playSound(@NotNull Entity arg0, @NotNull Sound arg1, float arg2, float arg3) {
    }

    public void playSound(@NotNull Entity arg0, @NotNull Sound arg1, @NotNull SoundCategory arg2, float arg3, float arg4) {
    }

    public void sendEquipmentChange(@NotNull LivingEntity arg0, @NotNull EquipmentSlot arg1, @NotNull ItemStack arg2) {
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    public void sendHealthUpdate() {
        class_1702 foodData = this.getHandle().method_7344();
        class_2749 packet = new class_2749(this.getScaledHealth(), foodData.method_7586(), foodData.method_7589());
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturation) {
        this.getHandle().field_13987.method_14364((class_2596)new class_2749((float)health, foodLevel, saturation));
    }

    public void sendMultiBlockChange(@NotNull Map<? extends Position, BlockData> arg0, boolean arg1) {
    }

    public void setResourcePack(@NotNull String arg0, @Nullable byte[] arg1, @Nullable String arg2) {
    }

    public void setResourcePack(@NotNull String arg0, @Nullable byte[] arg1, boolean arg2) {
    }

    public void setResourcePack(@NotNull String arg0, @Nullable byte[] arg1, @Nullable String arg2, boolean arg3) {
    }

    public void setResourcePack(@NotNull String arg0, byte @Nullable [] arg1, @Nullable Component arg2, boolean arg3) {
    }

    public void setSimulationDistance(int arg0) {
    }

    public void setWorldBorder(@Nullable WorldBorder arg0) {
    }

    public void showDemoScreen() {
    }

    public void showEntity(@NotNull Plugin arg0, @NotNull Entity arg1) {
    }

    public void addAdditionalChatCompletions(@NotNull Collection<String> arg0) {
        this.getHandle().field_13987.method_14364((class_2596)new class_7597(class_7597.class_7598.field_39801, new ArrayList<String>(arg0)));
    }

    public int getWardenTimeSinceLastWarning() {
        return 0;
    }

    public int getWardenWarningCooldown() {
        return 0;
    }

    public int getWardenWarningLevel() {
        return 0;
    }

    public void increaseWardenWarningLevel() {
    }

    public void removeAdditionalChatCompletions(@NotNull Collection<String> arg0) {
        this.getHandle().field_13987.method_14364((class_2596)new class_7597(class_7597.class_7598.field_39802, new ArrayList<String>(arg0)));
    }

    public void sendBlockChanges(@NotNull Collection<BlockState> arg0, boolean arg1) {
        this.sendBlockChanges(arg0);
    }

    public void sendBlockDamage(Location loc, float progress, int sourceId) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        if (progress == 0.0f) {
            stage = -1;
        }
        class_2620 packet = new class_2620(sourceId, CraftLocation.toBlockPosition(loc), stage);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public void setWardenTimeSinceLastWarning(int arg0) {
    }

    public void setWardenWarningCooldown(int arg0) {
    }

    public void setWardenWarningLevel(int arg0) {
    }

    public void showElderGuardian(boolean silent) {
        if (this.getHandle().field_13987 != null) {
            this.getHandle().field_13987.method_14364((class_2596)new class_2668(class_2668.field_25655, silent ? 0.0f : 1.0f));
        }
    }

    public void stopSound(@NotNull SoundCategory arg0) {
    }

    public void addCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, class_7597.class_7598.field_39801);
    }

    public void removeCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, class_7597.class_7598.field_39802);
    }

    public void setCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, class_7597.class_7598.field_39803);
    }

    private void sendCustomChatCompletionPacket(Collection<String> completions, class_7597.class_7598 action) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_7597 packet = new class_7597(action, new ArrayList<String>(completions));
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public int getExpCooldown() {
        return this.getHandle().field_7504;
    }

    @NotNull
    public TriState hasFlyingFallDamage() {
        return TriState.NOT_SET;
    }

    public boolean hasSeenWinScreen() {
        return this.getHandle().field_13969;
    }

    @Override
    public void openSign(@NotNull Sign arg0, @NotNull Side arg1) {
    }

    public void playSound(@NotNull Entity arg0, @NotNull String arg1, float arg2, float arg3) {
    }

    public void playSound(@NotNull Entity arg0, @NotNull String arg1, @NotNull SoundCategory arg2, float arg3, float arg4) {
    }

    public void sendBlockDamage(@NotNull Location arg0, float arg1, @NotNull Entity arg2) {
    }

    public void sendEquipmentChange(@NotNull LivingEntity arg0, @NotNull Map<EquipmentSlot, ItemStack> arg1) {
    }

    public void sendHurtAnimation(float yaw) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().field_13987.method_14364((class_2596)new class_8043(this.getEntityId(), actualYaw));
    }

    public void sendHurtAnimation(float yaw, Entity target) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().field_13987.method_14364((class_2596)new class_8043(target.getEntityId(), actualYaw));
    }

    public void setExpCooldown(int ticks) {
    }

    public void setFlyingFallDamage(@NotNull TriState arg0) {
    }

    public void setHasSeenWinScreen(boolean hasSeenWinScreen) {
        this.getHandle().field_13969 = hasSeenWinScreen;
    }

    public void showWinScreen() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        class_2668 packet = new class_2668(class_2668.field_25649, 1.0f);
        this.getHandle().field_13987.method_14364((class_2596)packet);
    }

    public boolean isConnected() {
        return !this.getHandle().method_14239();
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return null;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Instant expires, @Nullable String source) {
        return null;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Duration duration, @Nullable String source) {
        return null;
    }

    public @UnmodifiableView @NotNull Iterable<? extends BossBar> activeBossBars() {
        return null;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Date expires, @Nullable String source, boolean kickPlayer) {
        return null;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Instant expires, @Nullable String source, boolean kickPlayer) {
        return null;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Duration duration, @Nullable String source, boolean kickPlayer) {
        return null;
    }

    @Nullable
    public BanEntry<InetAddress> banIp(@Nullable String reason, @Nullable Date expires, @Nullable String source, boolean kickPlayer) {
        return null;
    }

    @Nullable
    public BanEntry<InetAddress> banIp(@Nullable String reason, @Nullable Instant expires, @Nullable String source, boolean kickPlayer) {
        return null;
    }

    @Nullable
    public BanEntry<InetAddress> banIp(@Nullable String reason, @Nullable Duration duration, @Nullable String source, boolean kickPlayer) {
        return null;
    }

    public void sendBlockChanges(Collection<BlockState> blocks) {
        Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
        if (this.getHandle().field_13987 == null || blocks.isEmpty()) {
            return;
        }
        HashMap<class_4076, ChunkSectionChanges> changes = new HashMap<class_4076, ChunkSectionChanges>();
        for (BlockState blockState : blocks) {
            CraftBlockState cstate = (CraftBlockState)blockState;
            class_2338 blockPosition = cstate.getPosition();
            class_4076 sectionPosition = class_4076.method_18682((class_2338)blockPosition);
            ChunkSectionChanges sectionChanges = changes.computeIfAbsent(sectionPosition, ignore -> new ChunkSectionChanges());
            sectionChanges.positions().add(class_4076.method_19454((class_2338)blockPosition));
            sectionChanges.blockData().add(cstate.getHandle());
        }
        for (Map.Entry entry : changes.entrySet()) {
            ChunkSectionChanges chunkChanges = (ChunkSectionChanges)entry.getValue();
            class_2637 packet = new class_2637((class_4076)entry.getKey(), chunkChanges.positions(), null);
            class_2680[] states = (class_2680[])chunkChanges.blockData().toArray(class_2680[]::new);
            ((IChunkDeltaUpdateS2CPacket)packet).cardboard$set_block_states(states);
            this.getHandle().field_13987.method_14364((class_2596)packet);
        }
    }

    public void sendMultiBlockChange(@NotNull Map<? extends Position, BlockData> blockChanges) {
    }

    public void sendBlockUpdate(@NotNull Location loc, @NotNull TileState tileState) throws IllegalArgumentException {
    }

    public boolean isListed(@NotNull Player other) {
        return false;
    }

    public boolean unlistPlayer(@NotNull Player other) {
        return false;
    }

    public boolean listPlayer(@NotNull Player other) {
        return false;
    }

    public void resetIdleDuration() {
        this.getHandle().method_14234();
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    public void playSound(@NotNull Location location, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    public void playSound(@NotNull Entity entity, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    public void playSound(@NotNull Entity entity, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    @NotNull
    public Duration getIdleDuration() {
        return Duration.ofMillis(class_156.method_658() - this.getHandle().method_14219());
    }

    public void setResourcePack(@NotNull UUID id, @NotNull String url, @Nullable byte[] hash, @Nullable String prompt, boolean force) {
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        if (null == prompt) {
            prompt = "hello";
        }
        Optional<class_2561> opt = Optional.of(CraftChatMessage.fromStringOrNull(prompt));
        this.handlePushResourcePack(new class_2720(id, url, hashStr, force, opt), true);
    }

    public void removeResourcePacks() {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_9053(Optional.empty()));
    }

    private void handlePushResourcePack(class_2720 resourcePackPushPacket, boolean resetBeforePush) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        if (resetBeforePush) {
            this.removeResourcePacks();
        }
        this.getHandle().field_13987.method_14364((class_2596)resourcePackPushPacket);
    }

    public Location getRespawnLocation() {
        return this.getRespawnLocation(false);
    }

    public Location getRespawnLocation(boolean loadLocationAndValidate) {
        class_3222.class_10766 respawnConfig = this.getHandle().method_67564();
        if (respawnConfig == null) {
            return null;
        }
        class_5217.class_12064 respawnData = respawnConfig.comp_4913();
        class_3218 world = this.server.getServer().method_3847(respawnData.method_74894());
        if (world == null) {
            return null;
        }
        return !loadLocationAndValidate ? CraftLocation.toBukkit(respawnData.method_74897(), world, respawnData.comp_4916(), respawnData.comp_4917()) : (Location)class_3222.method_60588((class_3218)world, (class_3222.class_10766)respawnConfig, (boolean)false).map(pos -> CraftLocation.toBukkit(pos.comp_2811(), (class_1937)world, pos.comp_2812(), pos.comp_4914())).orElse(null);
    }

    public void sendPotionEffectChange(@NotNull LivingEntity entity, @NotNull PotionEffect effect) {
    }

    public void sendPotionEffectChangeRemove(@NotNull LivingEntity entity, @NotNull PotionEffectType type) {
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int calculateTotalExperiencePoints() {
        return 0;
    }

    public void setExperienceLevelAndProgress(int totalExperience) {
        int level = this.calculateLevelsForExperiencePoints(totalExperience);
        int remainingPoints = totalExperience - this.calculateTotalExperiencePoints(level);
        this.getHandle().field_7520 = level;
        this.getHandle().field_7510 = (float)remainingPoints / (float)this.getExperiencePointsNeededForNextLevel();
        this.getHandle().field_13978 = -1;
    }

    private int calculateTotalExperiencePoints(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    private int calculateLevelsForExperiencePoints(int points) {
        if (points <= 352) {
            return (int)Math.floor(Math.sqrt(points + 9) - 3.0);
        }
        if (points <= 1507) {
            return (int)Math.floor(8.1 + Math.sqrt(0.4 * ((double)points - 195.975)));
        }
        return (int)Math.floor(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)points - 752.9861111111111)));
    }

    public int getExperiencePointsNeededForNextLevel() {
        return this.getHandle().method_7349();
    }

    public void setResourcePack(UUID uuid, String url, byte[] hashBytes, Component prompt, boolean force) {
        String hash = hashBytes != null ? BaseEncoding.base16().lowerCase().encode(hashBytes) : "";
        this.getHandle().field_13987.method_14364((class_2596)new class_9053(Optional.empty()));
        this.getHandle().field_13987.method_14364((class_2596)new class_2720(uuid, url, hash, force, Optional.ofNullable(prompt).map(PaperAdventure::asVanilla)));
    }

    public void addResourcePack(UUID id, String url, byte[] hash, String prompt, boolean force) {
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new class_2720(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), false);
    }

    public void removeResourcePack(@NotNull UUID id) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_9053(Optional.of(id)));
    }

    public Set<Long> getSentChunkKeys() {
        AsyncCatcher.catchOp("accessing sent chunks");
        return LongSets.EMPTY_SET;
    }

    public Set<Chunk> getSentChunks() {
        return null;
    }

    public boolean isChunkSent(long chunkKey) {
        return false;
    }

    @Nullable
    public InetSocketAddress getHAProxyAddress() {
        return null;
    }

    public boolean isTransferred() {
        return false;
    }

    @NotNull
    public CompletableFuture<byte[]> retrieveCookie(@NotNull NamespacedKey key) {
        return null;
    }

    public void storeCookie(@NotNull NamespacedKey key, @NotNull byte[] value) {
    }

    public void transfer(String host, int port) {
    }

    public <T> void spawnParticle(@NotNull Particle particle, @NotNull Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
    }

    public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data, boolean force) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + String.valueOf(particle.getDataType()) + " got " + String.valueOf(data.getClass()));
        }
        class_2675 packetplayoutworldparticles = new class_2675(CraftParticle.createParticleParam(particle, data), false, force, x, y, z, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().field_13987.method_14364((class_2596)packetplayoutworldparticles);
    }

    public void sendLinks(ServerLinks links) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        Preconditions.checkArgument((links != null ? 1 : 0) != 0, (Object)"links cannot be null");
        class_9782 nms = ((CraftServerLinks)links).getServerLinks();
        this.getHandle().field_13987.method_14364((class_2596)new class_9815(nms.method_60938()));
    }

    @Override
    public void startRiptideAttack(int duration, float attackStrength, @Nullable ItemStack attackItem) {
    }

    public void sendEntityEffect(EntityEffect effect, Entity target) {
        if (this.getHandle().field_13987 == null || !effect.isApplicableTo(target)) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2663(((CraftEntity)target).getHandle(), effect.getData()));
    }

    public int getPlayerListOrder() {
        return this.getHandle().method_61272();
    }

    public void setPlayerListOrder(int order) {
    }

    @NotNull
    public Collection<EnderPearl> getEnderPearls() {
        return this.getHandle().method_64128().stream().map(e -> (EnderPearl)e.getBukkitEntity()).collect(Collectors.toList());
    }

    @NotNull
    public Input getCurrentInput() {
        return new CraftInput(this.getHandle().method_63562());
    }

    public void lookAt(@NotNull Entity entity, @NotNull LookAnchor playerAnchor, @NotNull LookAnchor entityAnchor) {
        this.getHandle().method_14222(CraftPlayer.toNmsAnchor(playerAnchor), ((CraftEntity)entity).getHandle(), CraftPlayer.toNmsAnchor(entityAnchor));
    }

    public PlayerGiveResult give(Collection<ItemStack> items, boolean dropIfFull) {
        if (items.isEmpty()) {
            return PaperPlayerGiveResult.EMPTY;
        }
        class_3222 handle = this.getHandle();
        ImmutableList.Builder drops = ImmutableList.builder();
        ImmutableList.Builder leftovers = ImmutableList.builder();
        for (ItemStack item : items) {
            Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
            Preconditions.checkArgument((!item.isEmpty() ? 1 : 0) != 0, (Object)"ItemStack cannot be empty");
            Preconditions.checkArgument((item.getAmount() <= item.getMaxStackSize() ? 1 : 0) != 0, (Object)"ItemStack amount cannot be greater than its max stack size");
        }
        for (ItemStack item : items) {
            class_1542 entity;
            class_1799 nmsStack = CraftItemStack.asNMSCopy(item);
            boolean added = handle.method_31548().method_7394(nmsStack);
            if (added && nmsStack.method_7960()) continue;
            leftovers.add((Object)CraftItemStack.asBukkitCopy(nmsStack));
            if (!dropIfFull || (entity = handle.method_7329(nmsStack, false, true)) == null) continue;
            drops.add((Object)((Item)entity.getBukkitEntity()));
        }
        handle.field_7512.method_7623();
        return new PaperPlayerGiveResult((Collection<ItemStack>)leftovers.build(), (Collection<Item>)drops.build());
    }

    public int getDeathScreenScore() {
        return this.getHandle().method_7272();
    }

    public void setDeathScreenScore(int score) {
        this.getHandle().method_7320(score);
    }

    public void openVirtualSign(Position block, Side side) {
        if (this.getHandle().field_13987 == null) {
            return;
        }
        this.getHandle().field_13987.method_14364((class_2596)new class_2693(MCUtil.toBlockPos(block), side == Side.FRONT));
    }

    public PlayerGameConnection getConnection() {
        return ((IMixinPlayNetworkHandler)this.getHandle().field_13987).cardboard$playerGameConnection();
    }

    @Override
    public Entity getShoulderEntityRight() {
        if (!this.getHandle().method_74075().method_33133()) {
            Entity var2;
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.getHandle().method_71370(), LOGGER);){
                var2 = class_1299.method_5892((class_11368)class_11352.method_71417((class_8942)scopedCollector.method_54946(() -> ".shoulder"), (class_7225.class_7874)this.getHandle().method_56673(), (class_2487)this.getHandle().method_74075()), (class_1937)this.getHandle().method_51469(), (class_3730)class_3730.field_52444).map(IMixinEntity::getBukkitEntity).orElse(null);
            }
            return var2;
        }
        return null;
    }

    @Override
    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().method_74074().method_33133()) {
            Entity var2;
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.getHandle().method_71370(), LOGGER);){
                var2 = class_1299.method_5892((class_11368)class_11352.method_71417((class_8942)scopedCollector.method_54946(() -> ".shoulder"), (class_7225.class_7874)this.getHandle().method_56673(), (class_2487)this.getHandle().method_74074()), (class_1937)this.getHandle().method_51469(), (class_3730)class_3730.field_52444).map(IMixinEntity::getBukkitEntity).orElse(null);
            }
            return var2;
        }
        return null;
    }

    public void sendPlayerListHeader(Component header) {
        this.playerListHeader = header;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListFooter(Component footer) {
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.playerListHeader = header;
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    private void adventure$sendPlayerListHeaderAndFooter() {
        class_3244 connection = this.getHandle().field_13987;
        if (connection != null) {
            class_2772 packet = new class_2772(PaperAdventure.asVanillaNullToEmpty(this.playerListHeader), PaperAdventure.asVanillaNullToEmpty(this.playerListFooter));
            connection.method_14364((class_2596)packet);
        }
    }

    private record ChunkSectionChanges(ShortSet positions, List<class_2680> blockData) {
        public ChunkSectionChanges() {
            this((ShortSet)new ShortArraySet(), new ArrayList<class_2680>());
        }
    }
}

