/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.inventory;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1706;
import org.bukkit.Location;
import org.bukkit.craftbukkit.inventory.CraftResultInventory;
import org.bukkit.craftbukkit.inventory.view.CraftAnvilView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.cardboardpowered.interfaces.IMixinAnvilScreenHandler;

public class CardboardAnvilInventory
extends CraftResultInventory
implements AnvilInventory {
    private static final int DEFAULT_REPAIR_COST = 0;
    private static final int DEFAULT_REPAIR_COST_AMOUNT = 0;
    private static final int DEFAULT_MAXIMUM_REPAIR_COST = 40;
    private final Location location;
    private final class_1706 container;
    private int repairCost;
    private int repairCostAmount;
    private int maximumRepairCost;

    public CardboardAnvilInventory(Location location, class_1263 inventory, class_1263 resultInventory, class_1706 container) {
        super(inventory, resultInventory);
        this.location = location;
        this.container = container;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String getRenameText() {
        return ((IMixinAnvilScreenHandler)this.container).getNewItemName_BF();
    }

    public int getRepairCost() {
        return ((IMixinAnvilScreenHandler)this.container).getLevelCost_BF();
    }

    public void setRepairCost(int i) {
        ((IMixinAnvilScreenHandler)this.container).setLevelCost_BF(i);
    }

    public int getMaximumRepairCost() {
        return ((IMixinAnvilScreenHandler)this.container).getMaxRepairCost_BF();
    }

    public void setMaximumRepairCost(int levels) {
        Preconditions.checkArgument((levels >= 0 ? 1 : 0) != 0, (Object)"Maximum repair cost must be positive (or 0)");
        ((IMixinAnvilScreenHandler)this.container).setMaxRepairCost_BF(levels);
    }

    public int getRepairCostAmount() {
        return 0;
    }

    public void setRepairCostAmount(int arg0) {
    }

    private void syncWithArbitraryViewValue(Consumer<CraftAnvilView> consumer) {
        InventoryView inventoryView;
        if (this.getViewers().isEmpty()) {
            return;
        }
        HumanEntity entity = this.getViewers().get(0);
        if (entity != null && (inventoryView = entity.getOpenInventory()) instanceof CraftAnvilView) {
            CraftAnvilView cav = (CraftAnvilView)inventoryView;
            consumer.accept(cav);
        }
    }

    public boolean isRepairCostSet() {
        return this.repairCost != 0;
    }

    public boolean isRepairCostAmountSet() {
        return this.repairCostAmount != 0;
    }

    public boolean isMaximumRepairCostSet() {
        return this.maximumRepairCost != 40;
    }
}

