/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.inventory;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.cardboardpowered.impl.inventory.BlockInventoryConverter;
import org.cardboardpowered.impl.inventory.CustomInventoryConverter;

public final class InventoryCreator {
    public static final InventoryCreator INSTANCE = new InventoryCreator();
    private final CustomInventoryConverter DEFAULT_CONVERTER = new CustomInventoryConverter();
    private final Map<InventoryType, InventoryConverter> converterMap = new HashMap<InventoryType, InventoryConverter>();

    private InventoryCreator() {
        this.converterMap.put(InventoryType.CHEST, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.DISPENSER, new BlockInventoryConverter.Dispenser());
        this.converterMap.put(InventoryType.DROPPER, new BlockInventoryConverter.Dropper());
        this.converterMap.put(InventoryType.FURNACE, new BlockInventoryConverter.Furnace());
        this.converterMap.put(InventoryType.WORKBENCH, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.ENCHANTING, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BREWING, new BlockInventoryConverter.BrewingStand());
        this.converterMap.put(InventoryType.PLAYER, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.MERCHANT, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.ENDER_CHEST, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.ANVIL, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BEACON, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.HOPPER, new BlockInventoryConverter.Hopper());
        this.converterMap.put(InventoryType.SHULKER_BOX, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BARREL, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BLAST_FURNACE, new BlockInventoryConverter.BlastFurnace());
        this.converterMap.put(InventoryType.LECTERN, new BlockInventoryConverter.Lectern());
        this.converterMap.put(InventoryType.SMOKER, new BlockInventoryConverter.Smoker());
        this.converterMap.put(InventoryType.LOOM, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.CARTOGRAPHY, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.GRINDSTONE, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.STONECUTTER, this.DEFAULT_CONVERTER);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.converterMap.get(type).createInventory(holder, type);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        return this.converterMap.get(type).createInventory(holder, type, title);
    }

    public Inventory createInventory(InventoryHolder holder, int size) {
        return this.DEFAULT_CONVERTER.createInventory(holder, size);
    }

    public Inventory createInventory(InventoryHolder holder, int size, String title) {
        return this.DEFAULT_CONVERTER.createInventory(holder, size, title);
    }

    public static interface InventoryConverter {
        public Inventory createInventory(InventoryHolder var1, InventoryType var2);

        public Inventory createInventory(InventoryHolder var1, InventoryType var2, String var3);
    }
}

