/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import net.minecraft.class_22;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.map.MapCanvasImpl;
import org.cardboardpowered.impl.map.MapRendererImpl;
import org.cardboardpowered.impl.map.RenderData;

public final class MapViewImpl
implements MapView {
    private final Map<CraftPlayer, RenderData> renderCache = new HashMap<CraftPlayer, RenderData>();
    private final List<MapRenderer> renderers = new ArrayList<MapRenderer>();
    private final Map<MapRenderer, Map<CraftPlayer, MapCanvasImpl>> canvases = new HashMap<MapRenderer, Map<CraftPlayer, MapCanvasImpl>>();
    protected final class_22 worldMap;

    public MapViewImpl(class_22 worldMap) {
        this.worldMap = worldMap;
        this.addRenderer(new MapRendererImpl(this, worldMap));
    }

    public int getId() {
        String text = this.worldMap.toString();
        if (text.startsWith("map_")) {
            try {
                return Integer.parseInt(text.substring("map_".length()));
            }
            catch (NumberFormatException ex) {
                throw new IllegalStateException("Map has non-numeric ID");
            }
        }
        throw new IllegalStateException("Map has invalid ID");
    }

    public boolean isVirtual() {
        return this.renderers.size() > 0 && !(this.renderers.get(0) instanceof MapRendererImpl);
    }

    @Deprecated
    public MapView.Scale getScale() {
        return Objects.requireNonNull(MapView.Scale.valueOf((byte)this.worldMap.field_119));
    }

    @Deprecated
    public void setScale(MapView.Scale scale) {
    }

    public World getWorld() {
        class_5321 dimension = this.worldMap.field_118;
        class_3218 world = CraftServer.server.method_3847(dimension);
        return world == null ? null : world.getCraftWorld();
    }

    public void setWorld(World world) {
    }

    public int getCenterX() {
        return this.worldMap.field_116;
    }

    public int getCenterZ() {
        return this.worldMap.field_115;
    }

    public void setCenterX(int x) {
    }

    public void setCenterZ(int z) {
    }

    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    public void addRenderer(MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new HashMap());
            renderer.initialize((MapView)this);
        }
    }

    public boolean removeRenderer(MapRenderer renderer) {
        if (this.renderers.contains(renderer)) {
            this.renderers.remove(renderer);
            for (Map.Entry<CraftPlayer, MapCanvasImpl> entry : this.canvases.get(renderer).entrySet()) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        entry.getValue().setPixel(x, y, (byte)-1);
                    }
                }
            }
            this.canvases.remove(renderer);
            return true;
        }
        return false;
    }

    private boolean isContextual() {
        for (MapRenderer renderer : this.renderers) {
            if (!renderer.isContextual()) continue;
            return true;
        }
        return false;
    }

    public RenderData render(CraftPlayer player) {
        boolean context = this.isContextual();
        RenderData render = this.renderCache.get(context ? player : null);
        if (render == null) {
            render = new RenderData();
            this.renderCache.put(context ? player : null, render);
        }
        if (context && this.renderCache.containsKey(null)) {
            this.renderCache.remove(null);
        }
        Arrays.fill(render.buffer, (byte)0);
        render.cursors.clear();
        Iterator<MapRenderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            int i;
            MapRenderer renderer;
            MapCanvasImpl canvas = this.canvases.get(renderer).get((renderer = iterator.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new MapCanvasImpl(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            canvas.setBase(render.buffer);
            try {
                renderer.render((MapView)this, (MapCanvas)canvas, (Player)player);
            }
            catch (Throwable ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Could not render map using renderer " + renderer.getClass().getName(), ex);
            }
            byte[] buf = canvas.getBuffer();
            for (i = 0; i < buf.length; ++i) {
                byte color = buf[i];
                if (color < 0 && color > -21) continue;
                render.buffer[i] = color;
            }
            for (i = 0; i < canvas.getCursors().size(); ++i) {
                render.cursors.add(canvas.getCursors().getCursor(i));
            }
        }
        return render;
    }

    public boolean isTrackingPosition() {
        return false;
    }

    public void setTrackingPosition(boolean trackingPosition) {
    }

    public boolean isUnlimitedTracking() {
        return false;
    }

    public void setUnlimitedTracking(boolean unlimited) {
    }

    public boolean isLocked() {
        return this.worldMap.field_17403;
    }

    public void setLocked(boolean locked) {
    }
}

