/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.world;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.math.Position;
import io.papermc.paper.raytracing.PositionedRayTraceConfigurationBuilder;
import io.papermc.paper.world.MoonPhase;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.isaiah.common.cmixin.IMixinWorld;
import net.kyori.adventure.util.TriState;
import net.minecraft.class_12195;
import net.minecraft.class_12206;
import net.minecraft.class_12279;
import net.minecraft.class_1267;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1530;
import net.minecraft.class_1531;
import net.minecraft.class_1532;
import net.minecraft.class_1533;
import net.minecraft.class_1538;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1642;
import net.minecraft.class_1665;
import net.minecraft.class_1669;
import net.minecraft.class_1671;
import net.minecraft.class_1694;
import net.minecraft.class_1695;
import net.minecraft.class_1696;
import net.minecraft.class_1697;
import net.minecraft.class_1699;
import net.minecraft.class_1700;
import net.minecraft.class_1701;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2673;
import net.minecraft.class_2680;
import net.minecraft.class_2761;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_3193;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_4538;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang.Validate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FeatureFlag;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.CraftFeatureFlag;
import org.bukkit.craftbukkit.CraftGameRule;
import org.bukkit.craftbukkit.CraftRegionAccessor;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.generator.structure.CraftGeneratedStructure;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftBiomeSearchResult;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataStoreBase;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.cardboardpowered.ChunkTicketBridge;
import org.cardboardpowered.impl.CardboardPotionUtil;
import org.cardboardpowered.impl.MetadataStoreImpl;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.util.CardboardFluidRaytraceMode;
import org.cardboardpowered.impl.util.CardboardRayTraceResult;
import org.cardboardpowered.impl.world.CardboardChunk;
import org.cardboardpowered.impl.world.CraftWorldBorder;
import org.cardboardpowered.interfaces.IMixinArrowEntity;
import org.cardboardpowered.interfaces.IMixinChunkHolder;
import org.cardboardpowered.interfaces.IMixinServerEntityPlayer;
import org.cardboardpowered.interfaces.IMixinThreadedAnvilChunkStorage;
import org.cardboardpowered.interfaces.IWorldChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private final MetadataStoreBase<Block> blockMetadata = MetadataStoreImpl.newBlockMetadataStore(this);
    private class_3218 nms;
    private String name;
    private WorldBorder worldBorder;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private static final Random rand = new Random();
    public TriState pvpMode = TriState.NOT_SET;

    public CraftWorld(String name, class_3218 world) {
        this.nms = world;
        this.name = name;
    }

    public CraftWorld(class_3218 world) {
        this(((class_5268)world.method_8401()).method_150(), world);
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public void sendPluginMessage(Plugin plugin, String channel, byte[] message) {
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(plugin, channel, message);
        }
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        CraftServer.INSTANCE.getWorldMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return CraftServer.INSTANCE.getWorldMetadata().getMetadata((Object)this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return CraftServer.INSTANCE.getWorldMetadata().hasMetadata((Object)this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        CraftServer.INSTANCE.getWorldMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
    }

    public boolean addPluginChunkTicket(int arg0, int arg1, Plugin arg2) {
        return false;
    }

    public boolean canGenerateStructures() {
        class_31 prop;
        class_5217 class_52172 = this.nms.method_8401();
        return class_52172 instanceof class_31 && (prop = (class_31)class_52172).method_28057().method_28029();
    }

    public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x, y, z, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        this.nms.method_8537(source == null ? null : ((CraftEntity)source).getHandle(), x, y, z, power, setFire, breakBlocks ? class_1937.class_7867.field_40890 : class_1937.class_7867.field_40888);
        return true;
    }

    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    public Item dropItem(Location loc, ItemStack arg1) {
        class_1542 entity = new class_1542((class_1937)this.nms, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(arg1));
        entity.field_7202 = 10;
        this.nms.method_14175((class_1297)entity);
        return (Item)entity.getBukkitEntity();
    }

    public Item dropItemNaturally(Location loc, ItemStack arg1) {
        double xs = (double)(this.nms.field_9229.method_43057() * 0.5f) + 0.25;
        double ys = (double)(this.nms.field_9229.method_43057() * 0.5f) + 0.25;
        double zs = (double)(this.nms.field_9229.method_43057() * 0.5f) + 0.25;
        loc = loc.clone();
        loc.setX(loc.getX() + xs);
        loc.setY(loc.getY() + ys);
        loc.setZ(loc.getZ() + zs);
        return this.dropItem(loc, arg1);
    }

    public boolean generateTree(Location loc, TreeType type) {
        class_2338 pos = new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        return false;
    }

    public boolean generateTree(Location loc, TreeType arg1, BlockChangeDelegate arg2) {
        class_2338 pos = new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        Object gen = null;
        return false;
    }

    public boolean getAllowAnimals() {
        return true;
    }

    public boolean getAllowMonsters() {
        return true;
    }

    public int getAmbientSpawnLimit() {
        return 0;
    }

    public int getAnimalSpawnLimit() {
        return 0;
    }

    public Biome getBiome(int arg0, int arg1) {
        return this.getBiome(arg0, 0, arg1);
    }

    @Override
    public Biome getBiome(int arg0, int arg1, int arg2) {
        try {
            return CraftBlock.biomeBaseToBiome((class_2378<class_1959>)this.getHandle().method_30349().method_30530(class_7924.field_41236), (class_1959)this.nms.method_16359(arg0 >> 2, arg1 >> 2, arg2 >> 2).comp_349());
        }
        catch (Exception e) {
            return CraftBlock.biomeBaseToBiome((class_2378<class_1959>)this.getHandle().method_30349().method_30530(class_7924.field_41236), (class_1959)this.nms.method_16359(arg0 >> 2, arg1 >> 2, arg2 >> 2));
        }
    }

    public Block getBlockAt(Location loc) {
        return this.getBlockAt(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public Block getBlockAt(int x, int y, int z) {
        return CraftBlock.at(this.nms, new class_2338(x, y, z));
    }

    public Chunk getChunkAt(Location arg0) {
        return this.getChunkAt(arg0.getBlockX() >> 4, arg0.getBlockZ() >> 4);
    }

    public Chunk getChunkAt(Block arg0) {
        return this.getChunkAt(arg0.getX() >> 4, arg0.getZ() >> 4);
    }

    public Chunk getChunkAt(int x, int z) {
        return ((IWorldChunk)this.nms.method_14178().method_12126(x, z, true)).getBukkitChunk();
    }

    public Difficulty getDifficulty() {
        return Difficulty.valueOf((String)this.nms.method_8407().method_5460().toUpperCase());
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int arg0, int arg1, boolean arg2, boolean arg3) {
        return CardboardChunk.getEmptyChunkSnapshot(arg0, arg1, this, arg2, arg3);
    }

    public DragonBattle getEnderDragonBattle() {
        return null;
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.nms.method_27909().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && bukkitEntity.isValid()) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... arg0) {
        return this.getEntitiesByClasses(arg0);
    }

    @Override
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> arg0) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (Object entity : this.nms.method_27909()) {
            Class bukkitClass;
            CraftEntity bukkitEntity;
            if (!(entity instanceof class_1297) || (bukkitEntity = ((class_1297)entity).getBukkitEntity()) == null || !arg0.isAssignableFrom(bukkitClass = bukkitEntity.getClass()) || !bukkitEntity.isValid()) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    @Override
    public Collection<Entity> getEntitiesByClasses(Class<?> ... arg0) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        block0: for (Object entity : this.nms.method_27909()) {
            CraftEntity bukkitEntity;
            if (!(entity instanceof class_1297) || (bukkitEntity = ((class_1297)entity).getBukkitEntity()) == null) continue;
            Class bukkitClass = bukkitEntity.getClass();
            for (Class<?> clazz : arg0) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (!bukkitEntity.isValid()) continue block0;
                list.add(bukkitEntity);
                continue block0;
            }
        }
        return list;
    }

    public World.Environment getEnvironment() {
        class_6880 type = this.nms.method_40134();
        if (type.method_40225(class_7134.field_37666)) {
            return World.Environment.NORMAL;
        }
        if (type.method_40225(class_7134.field_37667)) {
            return World.Environment.NETHER;
        }
        if (type.method_40225(class_7134.field_37668)) {
            return World.Environment.THE_END;
        }
        return World.Environment.CUSTOM;
    }

    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        LongIterator longIterator = this.nms.method_17984().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(this.getChunkAt(class_1923.method_8325((long)coord), class_1923.method_8332((long)coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    public long getFullTime() {
        return this.nms.method_8532();
    }

    public static <T> T shimLegacyValue(T value, GameRule<?> gameRule) {
        Object object;
        if (gameRule instanceof CraftGameRule.LegacyGameRuleWrapper) {
            CraftGameRule.LegacyGameRuleWrapper legacyGameRuleWrapper = (CraftGameRule.LegacyGameRuleWrapper)gameRule;
            object = legacyGameRuleWrapper.getToLegacyFromModern().apply(value);
        } else {
            object = value;
        }
        return object;
    }

    public <T> T getGameRuleDefault(@NotNull GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Object value = CraftGameRule.bukkitToMinecraft(rule).method_76156();
        return (T)CraftWorld.shimLegacyValue(value, rule);
    }

    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        GameRule bukkit = GameRule.getByName((String)rule);
        if (bukkit == null) {
            throw new IllegalArgumentException("Unknown gamerule: " + rule);
        }
        return this.getHandle().method_64395().method_76200(CraftGameRule.bukkitToMinecraft(bukkit));
    }

    public <T> T getGameRuleValue(@NotNull GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Object value = this.getHandle().method_64395().method_76185(CraftGameRule.bukkitToMinecraft(rule));
        return (T)CraftWorld.shimLegacyValue(value, rule);
    }

    public String[] getGameRules() {
        return (String[])this.getHandle().method_64395().method_76181().map(class_12279::method_76144).toArray(String[]::new);
    }

    public ChunkGenerator getGenerator() {
        return null;
    }

    public Block getHighestBlockAt(Location arg0) {
        return this.getHighestBlockAt(arg0.getBlockX(), arg0.getBlockY());
    }

    public Block getHighestBlockAt(int x, int z) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z), z);
    }

    public Block getHighestBlockAt(Location arg0, HeightMap arg1) {
        return this.getHighestBlockAt(arg0.getBlockX(), arg0.getBlockY());
    }

    public Block getHighestBlockAt(int x, int z, HeightMap heightMap) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z, heightMap), z);
    }

    @Override
    public int getHighestBlockYAt(Location arg0) {
        return this.getHighestBlockYAt(arg0.getBlockX(), arg0.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(int arg0, int arg1) {
        return this.getHighestBlockYAt(arg0, arg1, HeightMap.MOTION_BLOCKING);
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap map) {
        return this.nms.method_8624(switch (map) {
            default -> throw new MatchException(null, null);
            case HeightMap.WORLD_SURFACE -> class_2902.class_2903.field_13202;
            case HeightMap.OCEAN_FLOOR -> class_2902.class_2903.field_13200;
            case HeightMap.MOTION_BLOCKING -> class_2902.class_2903.field_13197;
            case HeightMap.WORLD_SURFACE_WG -> class_2902.class_2903.field_13194;
            case HeightMap.OCEAN_FLOOR_WG -> class_2902.class_2903.field_13195;
            case HeightMap.MOTION_BLOCKING_NO_LEAVES -> class_2902.class_2903.field_13203;
        }, x, z);
    }

    @Override
    public int getHighestBlockYAt(Location loc, HeightMap heightMap) {
        return this.getHighestBlockYAt(loc.getBlockX(), loc.getBlockZ());
    }

    public double getHumidity(int x, int z) {
        return this.getHumidity(x, 0, z);
    }

    public double getHumidity(int x, int y, int z) {
        try {
            return 0.0;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public boolean getKeepSpawnInMemory() {
        return false;
    }

    @Override
    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (Object o : this.nms.method_27909()) {
            class_1297 mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof class_1297) || (bukkitEntity = (mcEnt = (class_1297)o).getBukkitEntity()) == null || !(bukkitEntity instanceof LivingEntity) || !bukkitEntity.isValid()) continue;
            list.add((LivingEntity)bukkitEntity);
        }
        return list;
    }

    public Chunk[] getLoadedChunks() {
        Long2ObjectLinkedOpenHashMap<class_3193> chunks = ((IMixinThreadedAnvilChunkStorage)this.nms.method_14178().field_17254).getChunkHoldersBF();
        return (Chunk[])chunks.values().stream().map(IMixinChunkHolder::getFullChunkNow).filter(Objects::nonNull).map(CraftWorld::getBukkitChunkForChunk).toArray(Chunk[]::new);
    }

    private static Chunk getBukkitChunkForChunk(class_2818 mc) {
        return ((IWorldChunk)mc).getBukkitChunk();
    }

    public int getMaxHeight() {
        return this.nms.method_31605();
    }

    public int getMonsterSpawnLimit() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        return this.getNearbyEntities(location, x, y, z, null);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<? super Entity> filter) {
        BoundingBox aabb = BoundingBox.of((Location)location, (double)x, (double)y, (double)z);
        return this.getNearbyEntities(aabb, filter);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<? super Entity> filter) {
        class_238 bb = new class_238(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List entityList = this.nms.method_8333((class_1297)null, bb, null);
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (class_1297 entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    public boolean getPVP() {
        return (Boolean)this.nms.method_64395().method_76185(class_1928.field_62434);
    }

    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.nms.method_18456().size());
        for (class_3222 player : this.nms.method_18456()) {
            list.add((Player)player.getBukkitEntity());
        }
        return list;
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        return Collections.emptyMap();
    }

    public Collection<Plugin> getPluginChunkTickets(int arg0, int arg1) {
        return Collections.emptySet();
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    public List<Raid> getRaids() {
        return Collections.emptyList();
    }

    public int getSeaLevel() {
        return this.nms.method_8615();
    }

    public long getSeed() {
        return this.nms.method_8412();
    }

    public Location getSpawnLocation() {
        class_2338 pos = this.nms.method_74854().method_74897();
        return new Location((World)this, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public double getTemperature(int x, int z) {
        return this.getTemperature(x, 0, z);
    }

    public double getTemperature(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        IMixinWorld icommon = (IMixinWorld)this.nms;
        return icommon.I_get_biome_for_noise_gen(x >> 2, y >> 2, z >> 2).method_21740(pos, this.nms.method_8615());
    }

    public int getThunderDuration() {
        int n;
        class_5217 class_52172 = this.nms.method_8401();
        if (class_52172 instanceof class_31) {
            class_31 prop = (class_31)class_52172;
            n = prop.method_145();
        } else {
            n = 0;
        }
        return n;
    }

    public long getTicksPerAmbientSpawns() {
        return 0L;
    }

    public long getTicksPerAnimalSpawns() {
        return 0L;
    }

    public long getTicksPerMonsterSpawns() {
        return 0L;
    }

    public long getTicksPerWaterSpawns() {
        return 0L;
    }

    public long getTime() {
        return this.nms.method_75260();
    }

    public UUID getUID() {
        return this.nms.cardboard$get_uuid();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.getName().equals(((CraftWorld)obj).getName());
    }

    public int getWaterAnimalSpawnLimit() {
        return 0;
    }

    public int getWeatherDuration() {
        int n;
        class_5217 class_52172 = this.nms.method_8401();
        if (class_52172 instanceof class_31) {
            class_31 prop = (class_31)class_52172;
            n = prop.method_190();
        } else {
            n = 0;
        }
        return n;
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    public File getWorldFolder() {
        return this.nms.method_8503().method_3831().toFile();
    }

    public WorldType getWorldType() {
        return this.nms.method_28125() ? WorldType.FLAT : WorldType.NORMAL;
    }

    public boolean hasStorm() {
        return this.nms.method_8401().method_156();
    }

    public boolean isAutoSave() {
        return !this.nms.method_8458();
    }

    public boolean isChunkForceLoaded(int arg0, int arg1) {
        return this.nms.method_17984().contains(class_1923.method_8331((int)arg0, (int)arg1));
    }

    public boolean isChunkGenerated(int x, int z) {
        try {
            return this.isChunkLoaded(x, z) || this.nms.method_14178().field_17254.method_23696(new class_1923(x, z)) != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isChunkInUse(int arg0, int arg1) {
        return this.isChunkLoaded(arg0, arg1);
    }

    public boolean isChunkLoaded(Chunk arg0) {
        return this.isChunkLoaded(arg0.getX(), arg0.getZ());
    }

    public boolean isChunkLoaded(int x, int z) {
        return null != this.nms.method_14178().method_12126(x, z, false);
    }

    public boolean isGameRule(String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"String rule cannot be null");
        Preconditions.checkArgument((!rule.isEmpty() ? 1 : 0) != 0, (Object)"String rule cannot be empty");
        GameRule bukkit = GameRule.getByName((String)rule);
        return bukkit == null ? false : this.getHandle().method_64395().field_9196.method_76164(CraftGameRule.bukkitToMinecraft(bukkit));
    }

    public boolean isHardcore() {
        return this.nms.method_8401().method_152();
    }

    public boolean isThundering() {
        return this.nms.method_8401().method_203();
    }

    public void loadChunk(Chunk arg0) {
        this.loadChunk(arg0.getX(), arg0.getZ());
    }

    public void loadChunk(int arg0, int arg1) {
        this.loadChunk(arg0, arg1, true);
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        class_2791 chunk = this.nms.method_14178().method_12121(x, z, generate ? class_2806.field_12803 : class_2806.field_12798, true);
        if (chunk instanceof class_2821) {
            chunk = this.nms.method_14178().method_12121(x, z, class_2806.field_12803, true);
        }
        if (chunk instanceof class_2818) {
            this.nms.method_14178().method_66009(ChunkTicketBridge.PLUGIN_TICKET, new class_1923(x, z), 1);
            return true;
        }
        return false;
    }

    public Raid locateNearestRaid(Location arg0, int arg1) {
        return null;
    }

    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        return null;
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Validate.isTrue(effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()), "Wrong kind of data for this effect!");
        } else {
            Validate.isTrue(effect.getData() == null || effect == Effect.ELECTRIC_SPARK, "Wrong kind of data for this effect!");
        }
        int datavalue = 0;
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Validate.notNull(location, "Location cannot be null");
        Validate.notNull(effect, "Effect cannot be null");
        Validate.notNull(location.getWorld(), "World cannot be null");
        int packetData = effect.getId();
        class_2673 packet = new class_2673(packetData, new class_2338(location.getBlockX(), location.getBlockY(), location.getBlockZ()), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            if (((CraftPlayer)player).getHandle().field_13987 == null || !location.getWorld().equals((Object)player.getWorld()) || (int)player.getLocation().distanceSquared(location) > radius) continue;
            ((CraftPlayer)player).getHandle().field_13987.method_14364((class_2596)packet);
        }
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        this.getHandle().method_43128(null, x, y, z, CraftSound.getSoundEffect(CraftSound.getSound(sound)), class_3419.valueOf((String)category.name()), volume, pitch);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().field_9229.method_43055());
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode mode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, mode, ignorePassableBlocks);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        return entityHitDistanceSquared < blockHitDistance * blockHitDistance ? entityHit : blockHit;
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode mode, boolean ignorePassableBlocks) {
        Validate.notNull(start, "Start location equals null");
        Validate.isTrue(this.equals(start.getWorld()), "Start location a different world");
        start.checkFinite();
        Validate.notNull(direction, "Direction equals null");
        direction.checkFinite();
        Validate.isTrue(direction.lengthSquared() > 0.0, "Direction's magnitude is 0");
        Validate.notNull(mode, "mode equals null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        class_243 startPos = new class_243(start.getX(), start.getY(), start.getZ());
        class_243 endPos = new class_243(start.getX() + dir.getX(), start.getY() + dir.getY(), start.getZ() + dir.getZ());
        class_3965 nmsHitResult = this.getHandle().method_17742(new class_3959(startPos, endPos, ignorePassableBlocks ? class_3959.class_3960.field_17558 : class_3959.class_3960.field_17559, CardboardFluidRaytraceMode.toMc(mode), (class_1297)null));
        return CardboardRayTraceResult.fromNMS(this, (class_239)nmsHitResult);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<? super Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        Validate.notNull(start, "Start location is null!");
        Validate.isTrue(this.equals(start.getWorld()), "Start location is from different world!");
        start.checkFinite();
        Validate.notNull(direction, "Direction is null!");
        direction.checkFinite();
        Validate.isTrue(direction.lengthSquared() > 0.0, "Direction's magnitude is 0!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    public boolean refreshChunk(int x, int z) {
        if (!this.isChunkLoaded(x, z)) {
            return false;
        }
        int px = x << 4;
        int pz = z << 4;
        int height = this.getMaxHeight() / 16;
        for (int idx = 0; idx < 64; ++idx) {
            this.nms.method_8413(new class_2338(px + idx / height, idx % height * 16, pz), class_2246.field_10124.method_9564(), class_2246.field_10340.method_9564(), 3);
        }
        this.nms.method_8413(new class_2338(px + 15, height * 16 - 1, pz + 15), class_2246.field_10124.method_9564(), class_2246.field_10340.method_9564(), 3);
        return true;
    }

    public boolean regenerateChunk(int arg0, int arg1) {
        throw new UnsupportedOperationException("Not supported in Spigot 1.17");
    }

    public boolean removePluginChunkTicket(int arg0, int arg1, Plugin arg2) {
        return false;
    }

    public void removePluginChunkTickets(Plugin arg0) {
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean flush) {
        boolean oldSave = this.nms.field_13957;
        this.nms.field_13957 = false;
        this.nms.method_14176(null, flush, false);
        this.nms.field_13957 = oldSave;
    }

    public void setAmbientSpawnLimit(int arg0) {
    }

    public void setAnimalSpawnLimit(int arg0) {
    }

    public void setAutoSave(boolean arg0) {
        this.nms.field_13957 = !arg0;
    }

    public void setBiome(int arg0, int arg1, Biome arg2) {
        for (int y = 0; y < this.getMaxHeight(); ++y) {
            this.setBiome(arg0, y, arg1, arg2);
        }
    }

    @Override
    public void setBiome(int x, int y, int z, Biome bio) {
    }

    public void setChunkForceLoaded(int arg0, int arg1, boolean arg2) {
    }

    public void setDifficulty(Difficulty diff) {
        class_1267 mc = class_1267.field_5802;
        switch (diff) {
            case EASY: {
                mc = class_1267.field_5805;
                break;
            }
            case HARD: {
                mc = class_1267.field_5807;
                break;
            }
            case NORMAL: {
                mc = class_1267.field_5802;
                break;
            }
            case PEACEFUL: {
                mc = class_1267.field_5801;
                break;
            }
        }
        this.getHandle().method_8503().method_3776(mc, true);
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.nms.method_8532());
        CraftServer.INSTANCE.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.nms.method_29199(this.nms.method_8532() + event.getSkipAmount());
        for (Player p : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p;
            if (cp.getHandle().field_13987 == null) continue;
            cp.getHandle().field_13987.method_14364((class_2596)new class_2761(cp.getHandle().method_51469().method_75260(), cp.getHandle().method_51469().method_75260(), ((Boolean)cp.getHandle().method_51469().method_64395().method_76185(class_1928.field_19396)).booleanValue()));
        }
    }

    public <T> boolean setGameRule(GameRule<T> rule, @NotNull T newValue) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"GameRule value cannot be null");
        class_12279<T> nms = CraftGameRule.bukkitToMinecraft(rule);
        if (!this.getHandle().method_64395().field_9196.method_76164(nms)) {
            return false;
        }
        if (rule instanceof CraftGameRule.LegacyGameRuleWrapper) {
            CraftGameRule.LegacyGameRuleWrapper legacyGameRuleWrapper = (CraftGameRule.LegacyGameRuleWrapper)rule;
            newValue = legacyGameRuleWrapper.getFromLegacyToModern().apply(newValue);
        }
        return !CraftEventFactory.handleGameRuleSet(nms, newValue, this.getHandle(), null).cancelled();
    }

    public boolean setGameRuleValue(String arg0, String arg1) {
        return false;
    }

    public void setHardcore(boolean arg0) {
    }

    public void setKeepSpawnInMemory(boolean arg0) {
    }

    public void setMonsterSpawnLimit(int arg0) {
    }

    public void setPVP(boolean pvp) {
        if ((Boolean)this.nms.method_64395().method_76185(class_1928.field_62434) != pvp) {
            this.pvpMode = TriState.byBoolean((boolean)pvp);
        }
    }

    public void setSpawnFlags(boolean arg0, boolean arg1) {
    }

    public boolean setSpawnLocation(Location location) {
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ()) : false;
    }

    public boolean setSpawnLocation(int x, int y, int z) {
        return this.setSpawnLocation(x, y, z, 0.0f, 0.0f);
    }

    public void setStorm(boolean arg0) {
        this.nms.method_8401().method_157(arg0);
    }

    public void setThunderDuration(int arg0) {
        this.worldProperties().method_173(arg0);
    }

    public void setThundering(boolean arg0) {
        this.worldProperties().method_147(arg0);
    }

    public void setTicksPerAmbientSpawns(int arg0) {
    }

    public void setTicksPerAnimalSpawns(int arg0) {
    }

    public void setTicksPerMonsterSpawns(int arg0) {
    }

    public void setTicksPerWaterSpawns(int arg0) {
    }

    public void setTime(long arg0) {
        this.nms.method_29199(arg0);
    }

    public void setWaterAnimalSpawnLimit(int arg0) {
    }

    public void setWeatherDuration(int arg0) {
        this.worldProperties().method_164(arg0);
    }

    private class_5268 worldProperties() {
        return this.nms.cardboard_worldProperties();
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, (Consumer<T>)null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, java.util.function.Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        class_1297 entity = this.createEntity_Old(location, clazz);
        return this.addEntity(entity, reason, function);
    }

    @Override
    public class_1297 createEntity_Old(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        if (location == null || clazz == null) {
            throw new IllegalArgumentException("Location or entity class cannot be null");
        }
        Object entity = null;
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        float pitch = location.getPitch();
        float yaw = location.getYaw();
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = class_1299.field_54410.method_5883((class_1937)this.nms, class_3730.field_16462);
            entity.method_5814(x, y, z);
            entity.method_5808(x, y, z, yaw, pitch);
        } else if (!FallingBlock.class.isAssignableFrom(clazz)) {
            if (Projectile.class.isAssignableFrom(clazz)) {
                if (Snowball.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6068.method_5883((class_1937)this.nms, class_3730.field_16462);
                    entity.method_5814(x, y, z);
                } else if (Egg.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6144.method_5883((class_1937)this.nms, class_3730.field_16462);
                    entity.method_5814(x, y, z);
                } else if (AbstractArrow.class.isAssignableFrom(clazz)) {
                    entity = TippedArrow.class.isAssignableFrom(clazz) ? class_1299.field_6122.method_5883((class_1937)this.nms, class_3730.field_16462) : (SpectralArrow.class.isAssignableFrom(clazz) ? class_1299.field_6135.method_5883((class_1937)this.nms, class_3730.field_16462) : (Trident.class.isAssignableFrom(clazz) ? class_1299.field_6127.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6122.method_5883((class_1937)this.nms, class_3730.field_16462)));
                    entity.method_5808(x, y, z, 0.0f, 0.0f);
                } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6064.method_5883((class_1937)this.nms, class_3730.field_16462);
                    entity.method_5808(x, y, z, 0.0f, 0.0f);
                } else if (EnderPearl.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6082.method_5883((class_1937)this.nms, class_3730.field_16462);
                    entity.method_5808(x, y, z, 0.0f, 0.0f);
                } else if (!ThrownPotion.class.isAssignableFrom(clazz) && !Fireball.class.isAssignableFrom(clazz)) {
                    if (ShulkerBullet.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6100.method_5883((class_1937)this.nms, class_3730.field_16462);
                        entity.method_5808(x, y, z, yaw, pitch);
                    } else if (LlamaSpit.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6124.method_5883((class_1937)this.nms, class_3730.field_16462);
                        entity.method_5808(x, y, z, yaw, pitch);
                    } else if (Firework.class.isAssignableFrom(clazz)) {
                        entity = new class_1671((class_1937)this.nms, x, y, z, class_1799.field_8037);
                    }
                }
            } else if (Minecart.class.isAssignableFrom(clazz)) {
                if (PoweredMinecart.class.isAssignableFrom(clazz)) {
                    entity = new class_1696(class_1299.field_6080, (class_1937)this.nms);
                    entity.method_5814(x, y, z);
                } else if (StorageMinecart.class.isAssignableFrom(clazz)) {
                    entity = new class_1694(class_1299.field_6126, (class_1937)this.nms);
                    entity.method_5814(x, y, z);
                } else if (ExplosiveMinecart.class.isAssignableFrom(clazz)) {
                    entity = new class_1701(class_1299.field_6053, (class_1937)this.nms);
                    entity.method_5814(x, y, z);
                } else if (HopperMinecart.class.isAssignableFrom(clazz)) {
                    entity = new class_1700(class_1299.field_6058, (class_1937)this.nms);
                    entity.method_5814(x, y, z);
                } else if (SpawnerMinecart.class.isAssignableFrom(clazz)) {
                    entity = new class_1699(class_1299.field_6142, (class_1937)this.nms);
                    entity.method_5814(x, y, z);
                } else if (CommandMinecart.class.isAssignableFrom(clazz)) {
                    entity = new class_1697(class_1299.field_6136, (class_1937)this.nms);
                    entity.method_5814(x, y, z);
                } else {
                    entity = new class_1695(class_1299.field_6096, (class_1937)this.nms);
                    entity.method_5814(x, y, z);
                }
            } else if (!EnderSignal.class.isAssignableFrom(clazz)) {
                if (EnderCrystal.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6110.method_5883((class_1937)this.nms, class_3730.field_16462);
                    entity.method_5808(x, y, z, 0.0f, 0.0f);
                } else if (LivingEntity.class.isAssignableFrom(clazz)) {
                    if (Chicken.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6132.method_5883((class_1937)this.nms, class_3730.field_16462);
                    } else if (Cow.class.isAssignableFrom(clazz)) {
                        entity = MushroomCow.class.isAssignableFrom(clazz) ? class_1299.field_6143.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6085.method_5883((class_1937)this.nms, class_3730.field_16462);
                    } else if (Golem.class.isAssignableFrom(clazz)) {
                        if (Snowman.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6047.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (IronGolem.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6147.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Shulker.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6109.method_5883((class_1937)this.nms, class_3730.field_16462);
                        }
                    } else if (Creeper.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6046.method_5883((class_1937)this.nms, class_3730.field_16462);
                    } else if (Ghast.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6107.method_5883((class_1937)this.nms, class_3730.field_16462);
                    } else if (Pig.class.isAssignableFrom(clazz)) {
                        entity = class_1299.field_6093.method_5883((class_1937)this.nms, class_3730.field_16462);
                    } else if (!Player.class.isAssignableFrom(clazz)) {
                        if (Sheep.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6115.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (AbstractHorse.class.isAssignableFrom(clazz)) {
                            if (ChestedHorse.class.isAssignableFrom(clazz)) {
                                if (Donkey.class.isAssignableFrom(clazz)) {
                                    entity = class_1299.field_6067.method_5883((class_1937)this.nms, class_3730.field_16462);
                                } else if (Mule.class.isAssignableFrom(clazz)) {
                                    entity = class_1299.field_6057.method_5883((class_1937)this.nms, class_3730.field_16462);
                                } else if (Llama.class.isAssignableFrom(clazz)) {
                                    entity = TraderLlama.class.isAssignableFrom(clazz) ? class_1299.field_17714.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6074.method_5883((class_1937)this.nms, class_3730.field_16462);
                                }
                            } else {
                                entity = SkeletonHorse.class.isAssignableFrom(clazz) ? class_1299.field_6075.method_5883((class_1937)this.nms, class_3730.field_16462) : (ZombieHorse.class.isAssignableFrom(clazz) ? class_1299.field_6048.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6139.method_5883((class_1937)this.nms, class_3730.field_16462));
                            }
                        } else if (Skeleton.class.isAssignableFrom(clazz)) {
                            entity = Stray.class.isAssignableFrom(clazz) ? class_1299.field_6098.method_5883((class_1937)this.nms, class_3730.field_16462) : (WitherSkeleton.class.isAssignableFrom(clazz) ? class_1299.field_6076.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6137.method_5883((class_1937)this.nms, class_3730.field_16462));
                        } else if (Slime.class.isAssignableFrom(clazz)) {
                            entity = MagmaCube.class.isAssignableFrom(clazz) ? class_1299.field_6102.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6069.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Spider.class.isAssignableFrom(clazz)) {
                            entity = CaveSpider.class.isAssignableFrom(clazz) ? class_1299.field_6084.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6079.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Squid.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6114.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Tameable.class.isAssignableFrom(clazz)) {
                            if (Wolf.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6055.method_5883((class_1937)this.nms, class_3730.field_16462);
                            } else if (Parrot.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6104.method_5883((class_1937)this.nms, class_3730.field_16462);
                            } else if (Cat.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_16281.method_5883((class_1937)this.nms, class_3730.field_16462);
                            }
                        } else if (PigZombie.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6050.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Zombie.class.isAssignableFrom(clazz)) {
                            entity = Husk.class.isAssignableFrom(clazz) ? class_1299.field_6071.method_5883((class_1937)this.nms, class_3730.field_16462) : (ZombieVillager.class.isAssignableFrom(clazz) ? class_1299.field_6054.method_5883((class_1937)this.nms, class_3730.field_16462) : (Drowned.class.isAssignableFrom(clazz) ? class_1299.field_6123.method_5883((class_1937)this.nms, class_3730.field_16462) : new class_1642((class_1937)this.nms)));
                        } else if (Giant.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6095.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Silverfish.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6125.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Enderman.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6091.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Blaze.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6099.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (AbstractVillager.class.isAssignableFrom(clazz)) {
                            if (Villager.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6077.method_5883((class_1937)this.nms, class_3730.field_16462);
                            } else if (WanderingTrader.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_17713.method_5883((class_1937)this.nms, class_3730.field_16462);
                            }
                        } else if (Witch.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6145.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Wither.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6119.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                            if (EnderDragon.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6116.method_5883((class_1937)this.nms, class_3730.field_16462);
                            }
                        } else if (Ambient.class.isAssignableFrom(clazz)) {
                            if (Bat.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6108.method_5883((class_1937)this.nms, class_3730.field_16462);
                            }
                        } else if (Rabbit.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6140.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Endermite.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6128.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Guardian.class.isAssignableFrom(clazz)) {
                            entity = ElderGuardian.class.isAssignableFrom(clazz) ? class_1299.field_6086.method_5883((class_1937)this.nms, class_3730.field_16462) : class_1299.field_6118.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (ArmorStand.class.isAssignableFrom(clazz)) {
                            entity = new class_1531((class_1937)this.nms, x, y, z);
                        } else if (PolarBear.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6042.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Vex.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6059.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Illager.class.isAssignableFrom(clazz)) {
                            if (Spellcaster.class.isAssignableFrom(clazz)) {
                                if (Evoker.class.isAssignableFrom(clazz)) {
                                    entity = class_1299.field_6090.method_5883((class_1937)this.nms, class_3730.field_16462);
                                } else if (Illusioner.class.isAssignableFrom(clazz)) {
                                    entity = class_1299.field_6065.method_5883((class_1937)this.nms, class_3730.field_16462);
                                }
                            } else if (Vindicator.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6117.method_5883((class_1937)this.nms, class_3730.field_16462);
                            } else if (Pillager.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6105.method_5883((class_1937)this.nms, class_3730.field_16462);
                            }
                        } else if (Turtle.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6113.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Phantom.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6078.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Fish.class.isAssignableFrom(clazz)) {
                            if (Cod.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6070.method_5883((class_1937)this.nms, class_3730.field_16462);
                            } else if (PufferFish.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6062.method_5883((class_1937)this.nms, class_3730.field_16462);
                            } else if (Salmon.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6073.method_5883((class_1937)this.nms, class_3730.field_16462);
                            } else if (TropicalFish.class.isAssignableFrom(clazz)) {
                                entity = class_1299.field_6111.method_5883((class_1937)this.nms, class_3730.field_16462);
                            }
                        } else if (Dolphin.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6087.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Ocelot.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6081.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Ravager.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6134.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Panda.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_6146.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Fox.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_17943.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Bee.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_20346.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Hoglin.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_21973.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Piglin.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_22281.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (PiglinBrute.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_25751.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Strider.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_23214.method_5883((class_1937)this.nms, class_3730.field_16462);
                        } else if (Zoglin.class.isAssignableFrom(clazz)) {
                            entity = class_1299.field_23696.method_5883((class_1937)this.nms, class_3730.field_16462);
                        }
                    }
                    if (entity != null) {
                        entity.method_5641(x, y, z, yaw, pitch);
                        entity.method_5847(yaw);
                    }
                } else if (Hanging.class.isAssignableFrom(clazz)) {
                    BlockFace face = BlockFace.SELF;
                    int width = 16;
                    int height = 16;
                    if (ItemFrame.class.isAssignableFrom(clazz)) {
                        width = 12;
                        height = 12;
                    } else if (LeashHitch.class.isAssignableFrom(clazz)) {
                        width = 9;
                        height = 9;
                    }
                    BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};
                    class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                    for (BlockFace dir : faces) {
                        class_2680 nmsBlock = this.nms.method_8320(pos.method_10093(CraftBlock.blockFaceToNotch(dir)));
                        if (!nmsBlock.method_51367() && !class_2312.method_9999((class_2680)nmsBlock)) continue;
                    }
                    if (LeashHitch.class.isAssignableFrom(clazz)) {
                        entity = new class_1532((class_1937)this.nms, class_2338.method_49637((double)x, (double)y, (double)z));
                    } else {
                        Preconditions.checkArgument((face != BlockFace.SELF ? 1 : 0) != 0, (String)"Cannot spawn hanging entity for %s at %s (no free face)", (Object)clazz.getName(), (Object)location);
                        class_2350 dir = CraftBlock.blockFaceToNotch(face).method_10153();
                        if (!Painting.class.isAssignableFrom(clazz) && ItemFrame.class.isAssignableFrom(clazz)) {
                            entity = new class_1533((class_1937)this.nms, class_2338.method_49637((double)x, (double)y, (double)z), dir);
                        }
                    }
                    if (entity != null && !((class_1530)entity).method_6888()) {
                        throw new IllegalArgumentException("Cannot spawn hanging entity for " + clazz.getName() + " at " + String.valueOf(location));
                    }
                } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
                    entity = new class_1541((class_1937)this.nms, x, y, z, null);
                } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
                    entity = new class_1303((class_1937)this.nms, x, y, z, 0);
                } else if (LightningStrike.class.isAssignableFrom(clazz)) {
                    entity = class_1299.field_6112.method_5883((class_1937)this.nms, class_3730.field_16462);
                } else if (AreaEffectCloud.class.isAssignableFrom(clazz)) {
                    entity = new class_1295((class_1937)this.nms, x, y, z);
                } else if (EvokerFangs.class.isAssignableFrom(clazz)) {
                    entity = new class_1669((class_1937)this.nms, x, y, z, (float)Math.toRadians(yaw), 0, null);
                }
            }
        }
        if (entity != null) {
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    @Override
    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null);
    }

    public <T extends Entity> T addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason, Consumer<T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (function != null) {
            function.accept((Object)entity.getBukkitEntity());
        }
        this.nms.method_14175(entity);
        return (T)entity.getBukkitEntity();
    }

    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    public <T extends AbstractArrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        class_1665 arrow;
        Validate.notNull(loc, "Cant spawn arrow with a null location");
        Validate.notNull(velocity, "Cant spawn arrow with a null velocity");
        Validate.notNull(clazz, "Cant spawn an arrow with no class");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = (class_1665)class_1299.field_6122.method_5883((class_1937)this.nms, class_3730.field_16462);
            ((IMixinArrowEntity)arrow).setType(CardboardPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (class_1665)class_1299.field_6135.method_5883((class_1937)this.nms, class_3730.field_16462) : (Trident.class.isAssignableFrom(clazz) ? (class_1665)class_1299.field_6127.method_5883((class_1937)this.nms, class_3730.field_16462) : (class_1665)class_1299.field_6122.method_5883((class_1937)this.nms, class_3730.field_16462));
        }
        arrow.method_5808(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.method_7485(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.nms.method_8649((class_1297)arrow);
        return (T)((AbstractArrow)arrow.getBukkitEntity());
    }

    @Override
    public Entity spawnEntity(Location loc, EntityType entityType) {
        return this.spawn(loc, entityType.getEntityClass());
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Validate.notNull(data, "MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Validate.notNull(location, "Location cannot be null");
        Validate.notNull(data, "Material cannot be null");
        class_1540 entity = class_1540.method_40005((class_1937)this.nms, (class_2338)class_2338.method_49637((double)location.getX(), (double)location.getY(), (double)location.getZ()), (class_2680)((CraftBlockData)data).getState());
        entity.field_7192 = 1;
        this.nms.method_14175((class_1297)entity);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Validate.notNull(location, "Location cannot be null");
        Validate.notNull(material, "Material cannot be null");
        Validate.isTrue(material.isBlock(), "Material must be a block");
        class_1540 entity = class_1540.method_40005((class_1937)this.nms, (class_2338)class_2338.method_49637((double)location.getX(), (double)location.getY(), (double)location.getZ()), (class_2680)CraftMagicNumbers.getBlock(material).method_9564());
        entity.field_7192 = 1;
        this.nms.method_14175((class_1297)entity);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + String.valueOf(particle.getDataType()) + " got " + String.valueOf(data.getClass()));
        }
    }

    public LightningStrike strikeLightning(Location loc) {
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)this.nms, class_3730.field_16462);
        lightning.method_24203(loc.getX(), loc.getY(), loc.getZ());
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public LightningStrike strikeLightningEffect(Location arg0) {
        return this.strikeLightning0(arg0, true);
    }

    private LightningStrike strikeLightning0(Location loc, boolean isVisual) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)this.nms, class_3730.field_16462);
        lightning.method_24203(loc.getX(), loc.getY(), loc.getZ());
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int x, int z, boolean save) {
        return this.unloadChunk0(x, z, save);
    }

    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk0(chunk.getX(), chunk.getZ(), true);
    }

    private boolean unloadChunk0(int x, int z, boolean save) {
        if (this.isChunkInUse(x, z)) {
            return false;
        }
        class_2818 chunk = this.nms.method_8497(x, z);
        if (chunk == null) {
            return true;
        }
        this.unloadChunkRequest(x, z);
        this.nms.method_14178().method_19492();
        return !this.isChunkLoaded(x, z);
    }

    public boolean unloadChunkRequest(int arg0, int arg1) {
        return false;
    }

    public class_3218 getHandle() {
        return this.nms;
    }

    public int getViewDistance() {
        return 8;
    }

    public void setWaterAmbientSpawnLimit(int i) {
    }

    public World.Spigot spigot() {
        return new World.Spigot(this){};
    }

    public MetadataStoreBase<Block> getBlockMetadata() {
        return this.blockMetadata;
    }

    public long getTicksPerWaterAmbientSpawns() {
        return 0L;
    }

    public int getWaterAmbientSpawnLimit() {
        return 0;
    }

    public void setTicksPerWaterAmbientSpawns(int arg0) {
    }

    private boolean setSpawnLocation(int x, int y, int z, float yaw, float pitch) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.nms.method_27873(new class_5217.class_12064(class_4208.method_19443((class_5321)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.nms.method_27983().method_29177()), (class_2338)new class_2338(x, y, z)), class_3532.method_15393((float)yaw), class_3532.method_15393((float)pitch)));
            CraftServer.INSTANCE.getServer().method_74946();
            new SpawnChangeEvent((World)this, previousLocation).callEvent();
            return true;
        }
        catch (Exception var7) {
            return false;
        }
    }

    public boolean setSpawnLocation(int x, int y, int z, float yaw) {
        return this.setSpawnLocation(x, y, z, yaw, 0.0f);
    }

    public boolean createExplosion(Entity arg0, Location arg1, float arg2, boolean arg3, boolean arg4) {
        return false;
    }

    public CompletableFuture<Chunk> getChunkAtAsync(int arg0, int arg1, boolean arg2, boolean arg3) {
        Chunk c = this.getChunkAt(arg0, arg1);
        return CompletableFuture.completedFuture(c);
    }

    public int getChunkCount() {
        return this.nms.method_14178().method_14151();
    }

    public int getClearWeatherDuration() {
        return 0;
    }

    public Entity getEntity(UUID arg0) {
        return this.nms.method_66347(arg0).getBukkitEntity();
    }

    public int getEntityCount() {
        return (int)this.nms.method_27909().spliterator().getExactSizeIfKnown();
    }

    @Override
    public MoonPhase getMoonPhase() {
        return MoonPhase.FIRST_QUARTER;
    }

    public int getNoTickViewDistance() {
        return 0;
    }

    public int getPlayerCount() {
        return this.nms.method_18456().size();
    }

    public int getTickableTileEntityCount() {
        return 0;
    }

    public int getTileEntityCount() {
        return 0;
    }

    public boolean isClearWeather() {
        return !this.nms.method_8419();
    }

    public boolean isDayTime() {
        return this.nms.method_8530();
    }

    public void setClearWeatherDuration(int arg0) {
        this.nms.method_27910(arg0, 0, false, false);
    }

    public void setNoTickViewDistance(int arg0) {
    }

    public void setViewDistance(int arg0) {
    }

    public <T> void spawnParticle(Particle arg0, List<Player> arg1, Player arg2, double arg3, double arg4, double arg5, int arg6, double arg7, double arg8, double arg9, double arg10, T arg11, boolean arg12) {
    }

    public boolean doesBedWork() {
        return false;
    }

    public boolean doesRespawnAnchorWork() {
        return false;
    }

    public Item dropItem(Location location, ItemStack item, java.util.function.Consumer<? super Item> function) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        class_1542 entity = new class_1542((class_1937)this.nms, location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy(item));
        Item itemEntity = (Item)entity.getBukkitEntity();
        entity.field_7202 = 10;
        if (function != null) {
            function.accept((Item)itemEntity);
        }
        this.nms.method_14175((class_1297)entity);
        return itemEntity;
    }

    @NotNull
    public Item dropItemNaturally(@NotNull Location arg0, @NotNull ItemStack arg1, @Nullable java.util.function.Consumer<? super Item> arg2) {
        return null;
    }

    public double getCoordinateScale() {
        return 0.0;
    }

    public long getGameTime() {
        return this.nms.method_8401().method_188();
    }

    @NotNull
    public Collection<Material> getInfiniburn() {
        return null;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.nms.method_27983().method_29177());
    }

    public int getMinHeight() {
        return this.nms.method_31607();
    }

    public boolean hasBedrockCeiling() {
        return false;
    }

    public boolean hasRaids() {
        return (Boolean)this.nms.method_75728().method_75694(class_12206.field_63754);
    }

    public boolean hasSkylight() {
        return false;
    }

    public boolean isFixedTime() {
        return this.getHandle().method_8597().comp_5219();
    }

    public boolean isNatural() {
        throw new UnsupportedOperationException("// TODO - snapshot");
    }

    public boolean isPiglinSafe() {
        return (Boolean)this.nms.method_75728().method_75694(class_12206.field_63761) == false;
    }

    public boolean isUltraWarm() {
        return (Boolean)this.nms.method_75728().method_75694(class_12206.field_63755) != false && (Boolean)this.nms.method_75728().method_75694(class_12206.field_63759) != false && ((class_2394)this.nms.method_75728().method_75694(class_12206.field_63749)).equals((Object)class_2398.field_28076);
    }

    @Override
    public boolean lineOfSightExists(@NotNull Location arg0, @NotNull Location arg1) {
        return false;
    }

    @Nullable
    public Location locateNearestBiome(@NotNull Location arg0, @NotNull Biome arg1, int arg2) {
        return null;
    }

    @Nullable
    public Location locateNearestBiome(@NotNull Location arg0, @NotNull Biome arg1, int arg2, int arg3) {
        return null;
    }

    @Override
    public boolean generateTree(@NotNull Location arg0, @NotNull Random arg1, @NotNull TreeType arg2) {
        return false;
    }

    @Override
    public boolean generateTree(@NotNull Location arg0, @NotNull Random arg1, @NotNull TreeType arg2, @Nullable java.util.function.Consumer<? super BlockState> arg3) {
        return false;
    }

    @Override
    @NotNull
    public Biome getBiome(@NotNull Location arg0) {
        return null;
    }

    @Override
    @NotNull
    public BlockData getBlockData(@NotNull Location l) {
        return CraftBlockData.fromData(this.getData(l.getBlockX(), l.getBlockY(), l.getBlockZ()));
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getData(x, y, z));
    }

    @Override
    @NotNull
    public BlockState getBlockState(@NotNull Location arg0) {
        return null;
    }

    @Override
    @NotNull
    public BlockState getBlockState(int x, int y, int z) {
        return CraftBlock.at(this.getHandle(), new class_2338(x, y, z)).getState();
    }

    @Override
    @NotNull
    public Material getType(@NotNull Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    @NotNull
    public Material getType(int x, int y, int z) {
        return CraftBlockType.minecraftToBukkit(this.getData(x, y, z).method_26204());
    }

    @Override
    public void setBiome(@NotNull Location arg0, @NotNull Biome arg1) {
    }

    @Override
    public void setBlockData(@NotNull Location arg0, @NotNull BlockData arg1) {
        super.setBlockData(arg0, arg1);
    }

    @Override
    public void setBlockData(int arg0, int arg1, int arg2, @NotNull BlockData arg3) {
        super.setBlockData(arg0, arg1, arg2, arg3);
    }

    @Override
    public void setType(@NotNull Location arg0, @NotNull Material arg1) {
        super.setType(arg0, arg1);
    }

    @Override
    public void setType(int arg0, int arg1, int arg2, @NotNull Material arg3) {
        super.setType(arg0, arg1, arg2, arg3);
    }

    @Override
    @NotNull
    public <T extends Entity> T spawn(@NotNull Location arg0, @NotNull Class<T> arg1, boolean arg2, @Nullable java.util.function.Consumer<? super T> arg3) throws IllegalArgumentException {
        return super.spawn(arg0, arg1, arg2, arg3);
    }

    @Override
    @NotNull
    public Entity spawnEntity(@NotNull Location arg0, @NotNull EntityType arg1, boolean arg2) {
        return super.spawnEntity(arg0, arg1, arg2);
    }

    @Nullable
    public Location findLightningRod(@NotNull Location arg0) {
        return null;
    }

    @Nullable
    public Location findLightningTarget(@NotNull Location arg0) {
        return null;
    }

    @Nullable
    public BiomeProvider getBiomeProvider() {
        return null;
    }

    public int getLogicalHeight() {
        return this.nms.method_8597().comp_653();
    }

    public int getSendViewDistance() {
        return 0;
    }

    public long getTicksPerWaterUndergroundCreatureSpawns() {
        return 0L;
    }

    public int getWaterUndergroundCreatureSpawnLimit() {
        return 0;
    }

    public boolean hasCeiling() {
        return false;
    }

    public boolean hasSkyLight() {
        return false;
    }

    public boolean isBedWorks() {
        return ((class_12195)this.nms.method_75728().method_75694(class_12206.field_63756)).comp_5136().method_75646((class_1937)this.nms);
    }

    public boolean isRespawnAnchorWorks() {
        return false;
    }

    public void sendGameEvent(@Nullable Entity sourceEntity, @NotNull GameEvent gameEvent, @NotNull Vector position) {
        this.getHandle().method_33596(sourceEntity != null ? ((CraftEntity)sourceEntity).getHandle() : null, (class_6880)class_7923.field_41171.method_10223(CraftNamespacedKey.toMinecraft(gameEvent.getKey())).orElseThrow(), CraftWorld.CraftVector_toBlockPos(position));
    }

    public static class_2338 CraftVector_toBlockPos(Vector vector) {
        return class_2338.method_49637((double)vector.getX(), (double)vector.getY(), (double)vector.getZ());
    }

    public void setSendViewDistance(int i) {
    }

    public void setTicksPerWaterUndergroundCreatureSpawns(int i) {
    }

    public void setWaterUndergroundCreatureSpawnLimit(int i) {
    }

    @Override
    public boolean generateTree(@NotNull Location arg0, @NotNull Random arg1, @NotNull TreeType arg2, @Nullable Predicate<? super BlockState> arg3) {
        return false;
    }

    @Override
    @NotNull
    public Biome getComputedBiome(int arg0, int arg1, int arg2) {
        return null;
    }

    public BiomeProvider vanillaBiomeProvider() {
        class_3215 serverCache = this.getHandle().method_14178();
        class_2794 gen = serverCache.method_12129();
        final class_1966 biomeSource = gen.method_12098();
        final class_6544.class_6552 sampler = serverCache.method_41248().method_42371();
        final List<Biome> possibleBiomes = biomeSource.method_28443().stream().map(CraftBiome::minecraftHolderToBukkit).toList();
        return new BiomeProvider(this){

            public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                return CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)biomeSource.method_38109(x >> 2, y >> 2, z >> 2, sampler));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return null;
    }

    public int getSimulationDistance() {
        return 8;
    }

    public int getSpawnLimit(@NotNull SpawnCategory arg0) {
        return 0;
    }

    public long getTicksPerSpawns(@NotNull SpawnCategory arg0) {
        return 0L;
    }

    public void playSound(@NotNull Entity arg0, @NotNull Sound arg1, float arg2, float arg3) {
    }

    public void playSound(@NotNull Entity arg0, @NotNull Sound arg1, @NotNull SoundCategory arg2, float arg3, float arg4) {
    }

    public void setSimulationDistance(int arg0) {
    }

    public void setSpawnLimit(@NotNull SpawnCategory arg0, int arg1) {
    }

    public void setTicksPerSpawns(@NotNull SpawnCategory arg0, int arg1) {
    }

    @Override
    public boolean hasCollisionsIn(@NotNull BoundingBox boundingBox) {
        class_238 aabb = new class_238(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        return !this.getHandle().method_18026(aabb);
    }

    @Nullable
    public StructureSearchResult locateNearestStructure(@NotNull Location arg0, @NotNull org.bukkit.generator.structure.StructureType arg1, int arg2, boolean arg3) {
        return null;
    }

    @Nullable
    public StructureSearchResult locateNearestStructure(@NotNull Location arg0, @NotNull Structure arg1, int arg2, boolean arg3) {
        return null;
    }

    public Chunk getChunkAt(int x2, int z2, boolean generate) {
        if (generate) {
            return this.getChunkAt(x2, z2);
        }
        return new CardboardChunk(this.getHandle(), x2, z2);
    }

    public void playSound(@NotNull Entity arg0, @NotNull String arg1, float arg2, float arg3) {
    }

    public void playSound(@NotNull Entity arg0, @NotNull String arg1, @NotNull SoundCategory arg2, float arg3, float arg4) {
    }

    @NotNull
    public Set<FeatureFlag> getFeatureFlags() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().method_45162()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @Nullable java.util.function.Consumer<? super T> function, @NotNull CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return (T)((LivingEntity)this.spawn(location, clazz, function, reason));
    }

    public boolean hasStructureAt(@NotNull Position position, @NotNull Structure structure) {
        class_3195 stru = (class_3195)((class_6880.class_6883)this.getHandle().method_30349().method_30530(class_7924.field_41246).method_10223(CraftNamespacedKey.toMinecraft(structure.getStructureType().getKey())).orElseThrow()).comp_349();
        return this.getHandle().method_27056().method_38854(CraftWorld.MCUtil_toBlockPos(position), stru).method_16657();
    }

    public static class_2338 MCUtil_toBlockPos(Position pos) {
        return new class_2338(pos.blockX(), pos.blockY(), pos.blockZ());
    }

    @Nullable
    public RayTraceResult rayTraceEntities(@NotNull Position start, @NotNull Vector direction, double maxDistance, double raySize, @Nullable Predicate<? super Entity> filter) {
        return null;
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(@NotNull Position start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, @Nullable Predicate<? super Block> canCollide) {
        return null;
    }

    @Nullable
    public RayTraceResult rayTrace(@NotNull Position start, @NotNull Vector direction, double maxDistance, @NotNull FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, @Nullable Predicate<? super Entity> filter, @Nullable Predicate<? super Block> canCollide) {
        return null;
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
    }

    public void playSound(@NotNull Location location, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    public void playSound(@NotNull Location location, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    public void playSound(@NotNull Entity entity, @NotNull Sound sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    public void playSound(@NotNull Entity entity, @NotNull String sound, @NotNull SoundCategory category, float volume, float pitch, long seed) {
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, Biome ... biomes) {
        return this.locateNearestBiome(origin, radius, 32, 64, biomes);
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, int horizontalInterval, int verticalInterval, Biome ... biomes) {
        class_2338 originPos = class_2338.method_49637((double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
        HashSet<class_6880<class_1959>> holders = new HashSet<class_6880<class_1959>>();
        for (Biome biome : biomes) {
            holders.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        class_6544.class_6552 sampler = this.getHandle().method_14178().method_41248().method_42371();
        Pair found = this.getHandle().method_14178().method_12129().method_12098().method_42310(originPos, radius, horizontalInterval, verticalInterval, holders::contains, sampler, (class_4538)this.getHandle());
        if (found == null) {
            return null;
        }
        return new CraftBiomeSearchResult(CraftBiome.minecraftHolderToBukkit((class_6880<class_1959>)((class_6880)found.getSecond())), new Location((World)this, (double)((class_2338)found.getFirst()).method_10263(), (double)((class_2338)found.getFirst()).method_10264(), (double)((class_2338)found.getFirst()).method_10260()));
    }

    @Override
    public void setBiome(int var1, int var2, int var3, class_6880<class_1959> var4) {
    }

    @Override
    public Iterable<class_1297> getNMSEntities() {
        return this.getHandle().cb$get_entity_lookup().method_31803();
    }

    @Override
    public void addEntityToWorld(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().method_8649(entity);
    }

    @Override
    public void addEntityWithPassengers(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().method_30736(entity);
    }

    @Override
    public <T extends Entity> T createEntity(Location location, Class<T> clazz) throws IllegalArgumentException {
        class_1297 entity = this.createEntity(location, clazz, true);
        if (!this.isNormalWorld()) {
            // empty if block
        }
        return (T)entity.getBukkitEntity();
    }

    @NotNull
    public FluidData getFluidData(int x, int y, int z) {
        return null;
    }

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox box) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = NumberConversions.floor((double)box.getMinX()) >> 4;
        int maxX = NumberConversions.floor((double)box.getMaxX()) >> 4;
        int minZ = NumberConversions.floor((double)box.getMinZ()) >> 4;
        int maxZ = NumberConversions.floor((double)box.getMaxZ()) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                chunks.add(this.getChunkAt(x, z, false));
            }
        }
        return chunks;
    }

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @NotNull CreatureSpawnEvent.SpawnReason reason, boolean randomizeData, @Nullable java.util.function.Consumer<? super T> function) throws IllegalArgumentException {
        return (T)((LivingEntity)this.spawn(location, clazz, function, reason));
    }

    @Nullable
    public Raid getRaid(int id) {
        return null;
    }

    @NotNull
    public Collection<GeneratedStructure> getStructures(int x, int z) {
        return this.getStructures(x, z, (class_3195 struct) -> true);
    }

    @NotNull
    public Collection<GeneratedStructure> getStructures(int x, int z, @NotNull Structure structure) {
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41246);
        class_2960 key = registry.method_10221((Object)CraftStructure.bukkitToMinecraft(structure));
        return this.getStructures(x, z, (class_3195 struct) -> registry.method_10221(struct).equals((Object)key));
    }

    private List<GeneratedStructure> getStructures(int x, int z, Predicate<class_3195> predicate) {
        ArrayList<GeneratedStructure> structures = new ArrayList<GeneratedStructure>();
        for (class_3449 start : this.getHandle().method_27056().method_41035(new class_1923(x, z), predicate)) {
            structures.add(new CraftGeneratedStructure(start));
        }
        return structures;
    }

    @NotNull
    public Collection<Player> getPlayersSeeingChunk(@NotNull Chunk chunk) {
        return this.getPlayersSeeingChunk(chunk.getX(), chunk.getZ());
    }

    @NotNull
    public Collection<Player> getPlayersSeeingChunk(int x, int z) {
        if (!this.isChunkLoaded(x, z)) {
            return Collections.emptySet();
        }
        List players = this.getHandle().method_14178().field_17254.method_17210(new class_1923(x, z), false);
        if (players.isEmpty()) {
            return Collections.emptySet();
        }
        return players.stream().filter(Objects::nonNull).map(IMixinServerEntityPlayer::getBukkit).collect(Collectors.toUnmodifiableSet());
    }

    public boolean isVoidDamageEnabled() {
        return false;
    }

    public void setVoidDamageEnabled(boolean enabled) {
    }

    public float getVoidDamageAmount() {
        return 0.0f;
    }

    public void setVoidDamageAmount(float voidDamageAmount) {
    }

    public double getVoidDamageMinBuildHeightOffset() {
        return 0.0;
    }

    public void setVoidDamageMinBuildHeightOffset(double minBuildHeightOffset) {
    }

    public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power, boolean setFire, boolean breakBlocks, boolean excludeSourceFromDamage) {
        this.nms.method_8537(source != null ? ((CraftEntity)source).getHandle() : null, loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks ? class_1937.class_7867.field_40890 : class_1937.class_7867.field_40888);
        return true;
    }

    public void getChunkAtAsync(int x, int z, boolean gen, boolean urgent, @NotNull java.util.function.Consumer<? super Chunk> cb) {
        CompletableFuture<Chunk> cf = this.getChunkAtAsync(x, z, gen, urgent);
        cf.thenAccept(cb);
        try {
            cf.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public void getChunksAtAsync(int minX, int minZ, int maxX, int maxZ, boolean urgent, @NotNull Runnable cb) {
    }

    @Nullable
    public RayTraceResult rayTrace(@NotNull java.util.function.Consumer<PositionedRayTraceConfigurationBuilder> builderConsumer) {
        return null;
    }

    public boolean hasBonusChest() {
        return true;
    }

    @NotNull
    public Path getWorldPath() {
        return this.getWorldFolder().toPath();
    }
}

