/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.library;

import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.cardboardpowered.library.LibraryKey;
import org.cardboardpowered.library.LibraryManager;
import org.jetbrains.annotations.NonNls;

public class Library
implements Comparable<Library> {
    public final LibraryKey libraryKey;
    public final String version;
    public final String repository;
    public final LibraryManager.HashAlgorithm checksumType;
    public final String checksumValue;
    public String checksumValue2;
    public final boolean excludeDependencies;

    public LibraryKey getLibraryKey() {
        return this.libraryKey;
    }

    public Library(@NonNls String groupId, @NonNls String artifactId, @NonNls String version, LibraryManager.HashAlgorithm checksumType, @NonNls String checksumValue, String spigot) {
        this(groupId, artifactId, version, null, checksumType, checksumValue, false, spigot);
    }

    public Library(String groupId, String artifactId, String version, String repository, LibraryManager.HashAlgorithm checksumType, String checksumValue, boolean excludeDependencies, String spigot) {
        this.libraryKey = new LibraryKey(groupId, artifactId, StringUtils.isBlank(spigot) ? null : spigot);
        this.version = version;
        this.repository = StringUtils.isBlank(repository) ? null : repository;
        this.checksumType = checksumType;
        this.checksumValue = checksumValue;
        this.checksumValue2 = null;
        this.excludeDependencies = excludeDependencies;
    }

    public String toString() {
        return this.libraryKey.toString() + ":" + this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Library library = (Library)o;
        return Objects.equals(this.libraryKey, library.libraryKey) && Objects.equals(this.version, library.version);
    }

    public int hashCode() {
        return Objects.hash(this.libraryKey, this.version);
    }

    @Override
    public int compareTo(Library o) {
        return ComparisonChain.start().compare((Comparable)this.libraryKey, (Comparable)o.libraryKey).result();
    }
}

