/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.mixin;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cardboardpowered.CardboardConfig;
import org.cardboardpowered.library.Library;
import org.cardboardpowered.library.LibraryManager;
import org.cardboardpowered.util.GameVersion;
import org.cardboardpowered.util.JarReader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CardboardMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "org.cardboardpowered.mixin.";
    private final Logger logger = LogManager.getLogger((String)"Cardboard");
    public static boolean libload = true;
    private static boolean read_plugins = false;

    public void onLoad(String mixinPackage) {
        try {
            CardboardConfig.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File pl = new File("plugins");
        if (pl.exists()) {
            try {
                JarReader.read_plugins(pl);
                read_plugins = true;
            }
            catch (Exception e) {
                read_plugins = false;
                e.printStackTrace();
            }
        } else {
            pl.mkdirs();
        }
        this.logger.info("Loading Libraries...");
        CardboardMixinPlugin.loadLibs();
    }

    public static void loadLibs() {
        List<Library> libraries = CardboardMixinPlugin.getLibs();
        String repository = "https://repo1.maven.org/maven2/";
        new LibraryManager(repository, "lib", true, 2, libraries).run();
    }

    public static List<Library> getLibs() {
        String mcver = GameVersion.create().getReleaseTarget();
        ArrayList<Library> libraries = new ArrayList<Library>();
        libraries.add(new Library("io.papermc", "paper-api", "25w45a", LibraryManager.HashAlgorithm.SHA1, "c4fcb1d0b7e4dfe630705540d5379291685a5320", "paper"));
        LibraryManager.OVERRIDE_PAPER_API = true;
        LibraryManager.PAPER_API_OVERRIDE = "https://github.com/CardboardPowered/PaperAPI-releases/releases/download/25w45a-8e0412f/paper-api-25w45a-R0.1-SNAPSHOT.jar";
        libraries.add(new Library("org.xerial", "sqlite-jdbc", "3.41.0.0", LibraryManager.HashAlgorithm.MD5, "0d63ee5b583e9a75ea1717ffce63fed8", null));
        libraries.add(new Library("com.mysql", "mysql-connector-j", "8.0.32", LibraryManager.HashAlgorithm.MD5, "25bf3b3cd262065283962078dc82e99c", null));
        libraries.add(new Library("commons-lang", "commons-lang", "2.6", LibraryManager.HashAlgorithm.SHA1, "0ce1edb914c94ebc388f086c6827e8bdeec71ac2", null));
        libraries.add(new Library("org.apache.commons", "commons-collections4", "4.4", LibraryManager.HashAlgorithm.SHA1, "62ebe7544cb7164d87e0637a2a6a2bdc981395e8", null));
        libraries.add(new Library("commons-collections", "commons-collections", "3.2.1", LibraryManager.HashAlgorithm.SHA1, "761ea405b9b37ced573d2df0d1e3a4e0f9edc668", null));
        libraries.add(new Library("net.md-5", "bungeecord-chat", "1.21-R0.2", LibraryManager.HashAlgorithm.SHA1, "64956ff493786f981a15697ce406fe39a2551692", null));
        String adventureVersion = "4.25.0";
        libraries.add(new Library("net.kyori", "adventure-api", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "6bd10494eeb2f8eadce7226db4445e8728985cbb", null));
        libraries.add(new Library("net.kyori", "adventure-key", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "eadeff9eeaa46f76de3f31fdff1d8e952273cf04", null));
        libraries.add(new Library("net.kyori", "adventure-text-serializer-gson", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "e312e240fe82f4207ff2232b33ee4433855bdfff", null));
        libraries.add(new Library("net.kyori", "adventure-text-serializer-json", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "ff6b4381dd8be9a40a1127937a4b71b9b010fcd6", null));
        libraries.add(new Library("net.kyori", "adventure-text-serializer-commons", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "58708c96ea4292800f08360ca1ce8a31ef0cdf97", null));
        libraries.add(new Library("net.kyori", "adventure-text-serializer-legacy", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "b12eaaac78d2534b9b1556049a8d95a046b0812d", null));
        libraries.add(new Library("net.kyori", "adventure-text-serializer-plain", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "82f5d4188f3cb6da9654b4ceea8b4093af5f1243", null));
        libraries.add(new Library("net.kyori", "adventure-text-minimessage", adventureVersion, LibraryManager.HashAlgorithm.SHA1, "38f8f778c92f1ea848f79f992c99c4b98f96f23b", null));
        libraries.add(new Library("net.kyori", "option", "1.1.0", LibraryManager.HashAlgorithm.SHA1, "593fecb9c42688eebc7d8da5d6ea127f4d4c92a2", null));
        System.setProperty("worldedit.bukkit.adapter", "com.sk89q.worldedit.bukkit.adapter.impl.v1_21_9.PaperweightAdapter");
        return libraries;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public static boolean is_event_found(String event) {
        if (!read_plugins) {
            return true;
        }
        return true;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        FabricLoader loader;
        boolean create_mod;
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        if (CardboardConfig.disabledMixins.contains(mixinClassName)) {
            this.logger.info("Disabling mixin '" + mixin + "', was forced disabled in config.");
            return false;
        }
        if (mixin.equals("item.MixinChorusFruitItem") && (create_mod = (loader = FabricLoader.getInstance()).isModLoaded("porting_lib"))) {
            return false;
        }
        if (mixin.equals("network.MixinServerPlayNetworkHandler_ChatEvent") && this.should_force_alternate_chat()) {
            this.logger.info("Architectury Mod detected! Disabling async chat from NetworkHandler.");
            return false;
        }
        String mcver = GameVersion.create().getReleaseTarget();
        if (mcver.contains("1.18") && mixin.endsWith("_1_19")) {
            return false;
        }
        if (mcver.contains("1.19") && mixin.endsWith("_1_18")) {
            return false;
        }
        if (mcver.contains("1.20") && mixin.endsWith("_1_18")) {
            return false;
        }
        if (mixinClassName.contains("ServerPlayNetworkHandler")) {
            return true;
        }
        try {
            URL[] jar = new URL[]{((ModContainer)FabricLoader.getInstance().getModContainer("cardboard").get()).getRootPath().toUri().toURL(), ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getRootPath().toUri().toURL(), ((ModContainer)FabricLoader.getInstance().getModContainer("fabricloader").get()).getRootPath().toUri().toURL(), new File(new File("lib"), "paper-api-1.17-dev.jar").toURI().toURL()};
            Class<?> c = Class.forName(mixinClassName, false, new URLClassLoader(jar));
            for (Annotation a : c.getAnnotations()) {
                String e = a.toString().split("events=")[1].substring(1);
                String[] events = (e = e.substring(0, e.lastIndexOf("}")).replace("\"", "")).split(", ");
                if (events.length <= 0) continue;
                if (events[0].length() < 4) {
                    return true;
                }
                boolean disable = true;
                for (String ev : events) {
                    if (this.not_has_event(mixin, mixin, ev)) continue;
                    disable = false;
                }
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return true;
    }

    public boolean not_has_event(String mix, String mixin, String event) {
        if (mix.contains(mixin)) {
            boolean dev = FabricLoader.getInstance().isDevelopmentEnvironment();
            if (CardboardMixinPlugin.is_event_found(event)) {
                if (dev) {
                    this.logger.info("DEBUG: Status of " + mixin + ": true. (" + event + ")");
                }
                return false;
            }
            if (dev) {
                this.logger.info("DEBUG: Status of " + mixin + ": false. (" + event + ")");
            }
            return true;
        }
        return false;
    }

    public boolean should_force_alternate_chat() {
        String[] bad_mods;
        FabricLoader loader = FabricLoader.getInstance();
        for (String s : bad_mods = new String[]{"architectury", "dynmap"}) {
            if (!loader.getModContainer(s).isPresent()) continue;
            return true;
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String target, ClassNode targetClass, String mixinClass, IMixinInfo info) {
    }

    public void postApply(String targetClass, ClassNode target, String mixinClass, IMixinInfo info) {
    }
}

