/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.mixin;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.PermissionManager;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.PluginCommandYamlParser;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.TimedRegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.cardboardpowered.CardboardConfig;
import org.cardboardpowered.CardboardMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SimplePluginManager.class}, remap=false)
public class MixinSimplePluginManager {
    @Shadow
    private Server server;
    @Shadow
    private File updateDirectory;
    @Shadow
    private Map<Pattern, PluginLoader> fileAssociations = new HashMap<Pattern, PluginLoader>();
    @Shadow
    private List<Plugin> plugins = new ArrayList<Plugin>();
    @Shadow
    private Map<String, Plugin> lookupNames = new HashMap<String, Plugin>();
    @Shadow
    private MutableGraph<String> dependencyGraph = GraphBuilder.directed().build();
    @Shadow
    private SimpleCommandMap commandMap;
    @Shadow
    public Map<String, Permission> permissions = new HashMap<String, Permission>();
    @Shadow
    public Map<Boolean, Set<Permission>> defaultPerms = new LinkedHashMap<Boolean, Set<Permission>>();
    @Shadow
    public Map<String, Map<Permissible, Boolean>> permSubs = new HashMap<String, Map<Permissible, Boolean>>();
    @Shadow
    public Map<Boolean, Map<Permissible, Boolean>> defSubs = new HashMap<Boolean, Map<Permissible, Boolean>>();

    @Inject(at={@At(value="HEAD")}, method={"callEvent(Lorg/bukkit/event/Event;)V"})
    public void cardboard$call_event_debug(Event event, CallbackInfo ci) {
        if (CardboardConfig.DEBUG_EVENT_CALL) {
            String name = event.getEventName();
            if (name.contains("EntityAirChangeEvent") || name.contains("EntityRemoveFromWorldEvent") || name.contains("EntityAddToWorldEvent")) {
                return;
            }
            CardboardMod.LOGGER.info("debug: callEvent: " + event.getEventName());
        }
    }

    @Overwrite(remap=false)
    public Plugin[] loadPlugins(File directory) {
        if (!this.server.getUpdateFolder().equals("")) {
            this.updateDirectory = new File(directory, this.server.getUpdateFolder());
        }
        return this.loadPlugins(directory.listFiles());
    }

    public Plugin[] loadPlugins(File[] files) {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        Set<Pattern> filters = this.fileAssociations.keySet();
        HashMap<String, File> plugins = new HashMap<String, File>();
        HashSet<String> loadedPlugins = new HashSet<String>();
        HashMap<String, String> pluginsProvided = new HashMap<String, String>();
        HashMap dependencies = new HashMap();
        HashMap softDependencies = new HashMap();
        for (File file2 : files) {
            List loadBeforeSet;
            List dependencySet;
            String removedProvided;
            PluginDescriptionFile description;
            block36: {
                PluginLoader loader = null;
                for (Pattern filter : filters) {
                    Matcher match = filter.matcher(file2.getName());
                    if (!match.find()) continue;
                    loader = this.fileAssociations.get(filter);
                }
                if (loader == null) continue;
                description = null;
                try {
                    description = loader.getPluginDescription(file2);
                    String name = description.getName();
                    if (name.equalsIgnoreCase("bukkit") || name.equalsIgnoreCase("minecraft") || name.equalsIgnoreCase("mojang")) {
                        this.server.getLogger().log(Level.SEVERE, "Could not load '" + file2.getPath() + "': Restricted Name");
                        continue;
                    }
                    if (description.getRawName().indexOf(32) != -1) {
                        this.server.getLogger().log(Level.SEVERE, "Could not load '" + file2.getPath() + "': uses the space-character (0x20) in its name");
                    }
                    break block36;
                }
                catch (InvalidDescriptionException ex) {
                    this.server.getLogger().log(Level.SEVERE, "Could not load '" + file2.getPath() + "'", ex);
                }
                continue;
            }
            File replacedFile = plugins.put(description.getName(), file2);
            if (replacedFile != null) {
                this.server.getLogger().severe(String.format("Ambiguous plugin name `%s' for files `%s' and `%s'", description.getName(), file2.getPath(), replacedFile.getPath()));
            }
            if ((removedProvided = (String)pluginsProvided.remove(description.getName())) != null) {
                this.server.getLogger().warning(String.format("Ambiguous plugin name `%s'. It is also provided by `%s'", description.getName(), removedProvided));
            }
            for (Object provided : description.getProvides()) {
                File pluginFile = (File)plugins.get(provided);
                if (pluginFile != null) {
                    this.server.getLogger().warning(String.format("`%s provides `%s' while this is also the name of `%s'", file2.getPath(), provided, pluginFile.getPath()));
                    continue;
                }
                String replacedPlugin = pluginsProvided.put((String)provided, description.getName());
                if (replacedPlugin == null) continue;
                this.server.getLogger().warning(String.format("`%s' is provided by both `%s' and `%s'", provided, description.getName(), replacedPlugin));
            }
            List softDependencySet = description.getSoftDepend();
            if (softDependencySet != null && !softDependencySet.isEmpty()) {
                Object provided;
                if (softDependencies.containsKey(description.getName())) {
                    ((Collection)softDependencies.get(description.getName())).addAll(softDependencySet);
                } else {
                    softDependencies.put(description.getName(), new LinkedList(softDependencySet));
                }
                provided = softDependencySet.iterator();
                while (provided.hasNext()) {
                    String depend = (String)provided.next();
                    this.dependencyGraph.putEdge((Object)description.getName(), (Object)depend);
                }
            }
            if ((dependencySet = description.getDepend()) != null && !dependencySet.isEmpty()) {
                dependencies.put(description.getName(), new LinkedList(dependencySet));
                for (String depend : dependencySet) {
                    this.dependencyGraph.putEdge((Object)description.getName(), (Object)depend);
                }
            }
            if ((loadBeforeSet = description.getLoadBefore()) == null || loadBeforeSet.isEmpty()) continue;
            for (String loadBeforeTarget : loadBeforeSet) {
                if (softDependencies.containsKey(loadBeforeTarget)) {
                    ((Collection)softDependencies.get(loadBeforeTarget)).add(description.getName());
                } else {
                    LinkedList<String> shortSoftDependency = new LinkedList<String>();
                    shortSoftDependency.add(description.getName());
                    softDependencies.put(loadBeforeTarget, shortSoftDependency);
                }
                this.dependencyGraph.putEdge((Object)loadBeforeTarget, (Object)description.getName());
            }
        }
        while (!plugins.isEmpty()) {
            Plugin loadedPlugin;
            File file;
            String plugin;
            boolean missingDependency = true;
            Iterator pluginIterator = plugins.entrySet().iterator();
            while (pluginIterator.hasNext()) {
                Map.Entry entry = pluginIterator.next();
                plugin = (String)entry.getKey();
                if (dependencies.containsKey(plugin)) {
                    Iterator dependencyIterator = ((Collection)dependencies.get(plugin)).iterator();
                    while (dependencyIterator.hasNext()) {
                        String dependency = (String)dependencyIterator.next();
                        if (loadedPlugins.contains(dependency)) {
                            dependencyIterator.remove();
                            continue;
                        }
                        if (plugins.containsKey(dependency) || pluginsProvided.containsKey(dependency)) continue;
                        missingDependency = false;
                        pluginIterator.remove();
                        softDependencies.remove(plugin);
                        dependencies.remove(plugin);
                        this.server.getLogger().log(Level.SEVERE, "Could not load '" + ((File)entry.getValue()).getPath() + "'", (Throwable)new UnknownDependencyException("Unknown dependency " + dependency + ". Please download and install " + dependency + " to run this plugin."));
                        break;
                    }
                    if (dependencies.containsKey(plugin) && ((Collection)dependencies.get(plugin)).isEmpty()) {
                        dependencies.remove(plugin);
                    }
                }
                if (softDependencies.containsKey(plugin)) {
                    Iterator softDependencyIterator = ((Collection)softDependencies.get(plugin)).iterator();
                    while (softDependencyIterator.hasNext()) {
                        String softDependency = (String)softDependencyIterator.next();
                        if (plugins.containsKey(softDependency) || pluginsProvided.containsKey(softDependency)) continue;
                        softDependencyIterator.remove();
                    }
                    if (((Collection)softDependencies.get(plugin)).isEmpty()) {
                        softDependencies.remove(plugin);
                    }
                }
                if (dependencies.containsKey(plugin) || softDependencies.containsKey(plugin) || !plugins.containsKey(plugin)) continue;
                file = (File)plugins.get(plugin);
                pluginIterator.remove();
                missingDependency = false;
                try {
                    loadedPlugin = this.loadPlugin(file);
                    if (loadedPlugin != null) {
                        result.add(loadedPlugin);
                        loadedPlugins.add(loadedPlugin.getName());
                        loadedPlugins.addAll(loadedPlugin.getDescription().getProvides());
                        continue;
                    }
                    this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "'");
                }
                catch (InvalidPluginException ex) {
                    this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "'", ex);
                }
            }
            if (!missingDependency) continue;
            pluginIterator = plugins.entrySet().iterator();
            while (pluginIterator.hasNext()) {
                Map.Entry entry = pluginIterator.next();
                plugin = (String)entry.getKey();
                if (dependencies.containsKey(plugin)) continue;
                softDependencies.remove(plugin);
                missingDependency = false;
                file = (File)entry.getValue();
                pluginIterator.remove();
                try {
                    loadedPlugin = this.loadPlugin(file);
                    if (loadedPlugin != null) {
                        result.add(loadedPlugin);
                        loadedPlugins.add(loadedPlugin.getName());
                        loadedPlugins.addAll(loadedPlugin.getDescription().getProvides());
                        break;
                    }
                    this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "'");
                    break;
                }
                catch (InvalidPluginException ex) {
                    this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "'", ex);
                }
            }
            if (!missingDependency) continue;
            softDependencies.clear();
            dependencies.clear();
            Iterator failedPluginIterator = plugins.values().iterator();
            while (failedPluginIterator.hasNext()) {
                File file2;
                file2 = (File)failedPluginIterator.next();
                failedPluginIterator.remove();
                this.server.getLogger().log(Level.SEVERE, "Could not load '" + file2.getPath() + "': circular dependency detected");
            }
        }
        return result.toArray(new Plugin[result.size()]);
    }

    @Overwrite(remap=false)
    public synchronized Plugin loadPlugin(File file) throws InvalidPluginException, UnknownDependencyException {
        this.checkUpdate(file);
        Set<Pattern> filters = this.fileAssociations.keySet();
        Plugin result = null;
        for (Pattern filter : filters) {
            String name;
            Matcher match = filter.matcher(name = file.getName());
            if (!match.find()) continue;
            PluginLoader loader = this.fileAssociations.get(filter);
            result = loader.loadPlugin(file);
        }
        if (result != null) {
            this.plugins.add(result);
            this.lookupNames.put(result.getDescription().getName(), result);
            for (String provided : result.getDescription().getProvides()) {
                this.lookupNames.putIfAbsent(provided, result);
            }
        }
        return result;
    }

    @Shadow
    private void checkUpdate(File file) {
    }

    @Overwrite(remap=false)
    public synchronized Plugin getPlugin(String name) {
        return this.lookupNames.get(name.replace(' ', '_'));
    }

    @Overwrite(remap=false)
    public synchronized Plugin[] getPlugins() {
        return this.plugins.toArray(new Plugin[this.plugins.size()]);
    }

    @Overwrite(remap=false)
    public boolean isPluginEnabled(String name) {
        Plugin plugin = this.getPlugin(name);
        return this.isPluginEnabled(plugin);
    }

    @Overwrite(remap=false)
    public boolean isPluginEnabled(Plugin plugin) {
        if (plugin != null && this.plugins.contains(plugin)) {
            return plugin.isEnabled();
        }
        return false;
    }

    @Overwrite(remap=false)
    public void enablePlugin(Plugin plugin) {
        if (!plugin.isEnabled()) {
            List pluginCommands = PluginCommandYamlParser.parse((Plugin)plugin);
            if (!pluginCommands.isEmpty()) {
                this.commandMap.registerAll(plugin.getDescription().getName(), pluginCommands);
            }
            try {
                plugin.getPluginLoader().enablePlugin(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while enabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            HandlerList.bakeAll();
        }
    }

    @Overwrite(remap=false)
    public void disablePlugins() {
        Plugin[] plugins = this.getPlugins();
        for (int i = plugins.length - 1; i >= 0; --i) {
            this.disablePlugin(plugins[i]);
        }
    }

    @Overwrite(remap=false)
    public void disablePlugin(Plugin plugin) {
        if (plugin.isEnabled()) {
            try {
                plugin.getPluginLoader().disablePlugin(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while disabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                this.server.getScheduler().cancelTasks(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while cancelling tasks for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                this.server.getServicesManager().unregisterAll(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering services for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                HandlerList.unregisterAll((Plugin)plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering events for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                this.server.getMessenger().unregisterIncomingPluginChannel(plugin);
                this.server.getMessenger().unregisterOutgoingPluginChannel(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering plugin channels for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                for (World world : this.server.getWorlds()) {
                    world.removePluginChunkTickets(plugin);
                }
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while removing chunk tickets for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public void clearPlugins() {
        SimplePluginManager simplePluginManager = (SimplePluginManager)this;
        synchronized (simplePluginManager) {
            this.disablePlugins();
            this.plugins.clear();
            this.lookupNames.clear();
            HandlerList.unregisterAll();
            this.fileAssociations.clear();
            this.permissions.clear();
            this.defaultPerms.get(true).clear();
            this.defaultPerms.get(false).clear();
        }
    }

    @Overwrite(remap=false)
    public void callEvent(Event event) {
        if (event.isAsynchronous()) {
            if (Thread.holdsLock(this)) {
                throw new IllegalStateException(event.getEventName() + " cannot be triggered asynchronously from inside synchronized code.");
            }
            if (this.server.isPrimaryThread()) {
                throw new IllegalStateException(event.getEventName() + " cannot be triggered asynchronously from primary server thread.");
            }
        } else if (!this.server.isPrimaryThread()) {
            throw new IllegalStateException(event.getEventName() + " cannot be triggered asynchronously from another thread.");
        }
        this.fireEvent(event);
    }

    @Shadow
    private void fireEvent(Event event) {
    }

    @Overwrite(remap=false)
    public void registerEvents(Listener listener, Plugin plugin) {
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + String.valueOf(listener) + " while not enabled");
        }
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(listener, plugin).entrySet()) {
            this.getEventListeners(this.getRegistrationClass((Class)entry.getKey())).registerAll((Collection)entry.getValue());
        }
    }

    @Shadow
    private Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        return null;
    }

    @Shadow
    private HandlerList getEventListeners(Class<? extends Event> type) {
        return null;
    }

    @Overwrite(remap=false)
    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin, boolean ignoreCancelled) {
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + String.valueOf(event) + " while not enabled");
        }
        if (this.useTimings()) {
            this.getEventListeners(event).register((RegisteredListener)new TimedRegisteredListener(listener, executor, priority, plugin, ignoreCancelled));
        } else {
            this.getEventListeners(event).register(new RegisteredListener(listener, executor, priority, plugin, ignoreCancelled));
        }
    }

    @Overwrite(remap=false)
    public Permission getPermission(String name) {
        return this.permissions.get(name.toLowerCase(Locale.ROOT));
    }

    @Overwrite(remap=false)
    public void addPermission(Permission perm) {
        this.addPermission(perm, true);
    }

    @Overwrite(remap=false)
    public void addPermission(Permission perm, boolean dirty) {
        String name = perm.getName().toLowerCase(Locale.ROOT);
        if (this.permissions.containsKey(name)) {
            throw new IllegalArgumentException("The permission " + name + " is already defined!");
        }
        this.permissions.put(name, perm);
        this.calculatePermissionDefault(perm, dirty);
    }

    @Overwrite(remap=false)
    public Set<Permission> getDefaultPermissions(boolean op) {
        return ImmutableSet.copyOf((Collection)this.defaultPerms.get(op));
    }

    @Overwrite(remap=false)
    public void removePermission(Permission perm) {
        this.removePermission(perm.getName());
    }

    @Overwrite(remap=false)
    public void removePermission(String name) {
        this.permissions.remove(name.toLowerCase(Locale.ROOT));
    }

    @Overwrite(remap=false)
    public void recalculatePermissionDefaults(Permission perm) {
        if (perm != null && this.permissions.containsKey(perm.getName().toLowerCase(Locale.ROOT))) {
            this.defaultPerms.get(true).remove(perm);
            this.defaultPerms.get(false).remove(perm);
            this.calculatePermissionDefault(perm, true);
        }
    }

    @Overwrite(remap=false)
    private void calculatePermissionDefault(Permission perm, boolean dirty) {
        if (perm.getDefault() == PermissionDefault.OP || perm.getDefault() == PermissionDefault.TRUE) {
            this.defaultPerms.get(true).add(perm);
            if (dirty) {
                this.dirtyPermissibles(true);
            }
        }
        if (perm.getDefault() == PermissionDefault.NOT_OP || perm.getDefault() == PermissionDefault.TRUE) {
            this.defaultPerms.get(false).add(perm);
            if (dirty) {
                this.dirtyPermissibles(false);
            }
        }
    }

    @Overwrite(remap=false)
    public void dirtyPermissibles() {
        this.dirtyPermissibles(true);
        this.dirtyPermissibles(false);
    }

    @Overwrite(remap=false)
    private void dirtyPermissibles(boolean op) {
        Set<Permissible> permissibles = this.getDefaultPermSubscriptions(op);
        for (Permissible p : permissibles) {
            p.recalculatePermissions();
        }
    }

    @Overwrite(remap=false)
    public void subscribeToPermission(String permission, Permissible permissible) {
        String name = permission.toLowerCase(Locale.ROOT);
        Map<Permissible, Boolean> map = this.permSubs.get(name);
        if (map == null) {
            map = new WeakHashMap<Permissible, Boolean>();
            this.permSubs.put(name, map);
        }
        map.put(permissible, true);
    }

    @Overwrite(remap=false)
    public void unsubscribeFromPermission(String permission, Permissible permissible) {
        String name = permission.toLowerCase(Locale.ROOT);
        Map<Permissible, Boolean> map = this.permSubs.get(name);
        if (map != null) {
            map.remove(permissible);
            if (map.isEmpty()) {
                this.permSubs.remove(name);
            }
        }
    }

    @Overwrite(remap=false)
    public Set<Permissible> getPermissionSubscriptions(String permission) {
        String name = permission.toLowerCase(Locale.ROOT);
        Map<Permissible, Boolean> map = this.permSubs.get(name);
        if (map == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(map.keySet());
    }

    @Overwrite(remap=false)
    public void subscribeToDefaultPerms(boolean op, Permissible permissible) {
        Map<Permissible, Boolean> map = this.defSubs.get(op);
        if (map == null) {
            map = new WeakHashMap<Permissible, Boolean>();
            this.defSubs.put(op, map);
        }
        map.put(permissible, true);
    }

    @Overwrite(remap=false)
    public void unsubscribeFromDefaultPerms(boolean op, Permissible permissible) {
        Map<Permissible, Boolean> map = this.defSubs.get(op);
        if (map != null) {
            map.remove(permissible);
            if (map.isEmpty()) {
                this.defSubs.remove(op);
            }
        }
    }

    @Overwrite(remap=false)
    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        Map<Permissible, Boolean> map = this.defSubs.get(op);
        if (map == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(map.keySet());
    }

    @Overwrite(remap=false)
    public Set<Permission> getPermissions() {
        return new HashSet<Permission>(this.permissions.values());
    }

    @Overwrite(remap=false)
    public boolean useTimings() {
        return false;
    }

    @Overwrite(remap=false)
    public void clearPermissions() {
    }

    @Overwrite(remap=false)
    public boolean isTransitiveDependency(PluginMeta pluginMeta, PluginMeta dependencyConfig) {
        return false;
    }

    @Overwrite(remap=false)
    public void overridePermissionManager(Plugin plugin, PermissionManager permissionManager) {
    }

    @Overwrite(remap=false)
    public void addPermissions(List<Permission> perm) {
        for (Permission p : perm) {
            this.addPermission(p);
        }
    }
}

