/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.util.mapping;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;

public class MyMappingResolver
implements MappingResolver {
    private final MemoryMappingTree tree = new MemoryMappingTree();
    private final String fromNamespace;
    private final String toNamespace;
    private final int targetNamespaceId;

    public MyMappingResolver(Path mappingFile, MappingFormat format, String fromNamespace, String toNamespace) throws IOException {
        MappingReader.read((Path)mappingFile, (MappingFormat)format, (MappingVisitor)this.tree);
        this.fromNamespace = Objects.requireNonNull(fromNamespace);
        this.toNamespace = Objects.requireNonNull(toNamespace);
        this.targetNamespaceId = this.tree.getNamespaceId(toNamespace);
    }

    public Collection<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>(this.tree.getDstNamespaces());
        namespaces.add(this.tree.getSrcNamespace());
        return Collections.unmodifiableSet(namespaces);
    }

    public String getCurrentRuntimeNamespace() {
        return this.toNamespace;
    }

    public String mapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return MyMappingResolver.replaceSlashesWithDots(this.tree.mapClassName(MyMappingResolver.replaceDotsWithSlashes(className), this.tree.getNamespaceId(namespace), this.targetNamespaceId));
    }

    public String unmapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return MyMappingResolver.replaceSlashesWithDots(this.tree.mapClassName(MyMappingResolver.replaceDotsWithSlashes(className), this.targetNamespaceId, this.tree.getNamespaceId(namespace)));
    }

    public String mapFieldName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        MappingTree.FieldMapping field = this.tree.getField(MyMappingResolver.replaceDotsWithSlashes(owner), name, descriptor, this.tree.getNamespaceId(namespace));
        return field == null ? name : field.getName(this.targetNamespaceId);
    }

    public String mapMethodName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        MappingTree.MethodMapping method = this.tree.getMethod(MyMappingResolver.replaceDotsWithSlashes(owner), name, descriptor, this.tree.getNamespaceId(namespace));
        return method == null ? name : method.getName(this.targetNamespaceId);
    }

    public String mapMethodNameSafe(String namespace, String ownerClass, String methodName, String methodDesc, String descNamespace) {
        MappingTree.ClassMapping cls;
        String descInFrom = methodDesc;
        if (!descNamespace.equals(namespace)) {
            descInFrom = this.tree.mapDesc((CharSequence)methodDesc, this.tree.getNamespaceId(descNamespace), this.tree.getNamespaceId(namespace));
        }
        if ((cls = this.tree.getClass(ownerClass, this.tree.getNamespaceId(namespace))) == null) {
            return methodName;
        }
        MappingTree.MethodMapping method = cls.getMethod(methodName, descInFrom, this.tree.getNamespaceId(namespace));
        return method != null ? method.getName(this.targetNamespaceId) : methodName;
    }

    private static String replaceSlashesWithDots(String cname) {
        return cname.replace('/', '.');
    }

    private static String replaceDotsWithSlashes(String cname) {
        return cname.replace('.', '/');
    }
}

