/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.nms.remappers;

import com.mohistmc.banner.bukkit.nms.model.ClassMapping;
import com.mohistmc.banner.bukkit.nms.remappers.BannerJarMapping;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.RemappingClassAdapter;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.repo.ClassRepo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class BannerJarRemapper
extends CustomRemapper {
    private RemapperProcessor preProcessor;
    public final BannerJarMapping jarMapping;
    private RemapperProcessor postProcessor;
    private final int writerFlags = 1;
    private int readerFlags = 0;
    private boolean copyResources = true;
    static int meth_len = "method_0".length();

    public String mapSignature(String signature, boolean typeSignature) {
        try {
            return super.mapSignature(signature, typeSignature);
        }
        catch (Exception e) {
            return signature;
        }
    }

    public BannerJarRemapper(RemapperProcessor preProcessor, BannerJarMapping jarMapping, RemapperProcessor postProcessor) {
        this.preProcessor = preProcessor;
        this.jarMapping = jarMapping;
        this.postProcessor = postProcessor;
    }

    public BannerJarRemapper(RemapperProcessor remapperPreprocessor, BannerJarMapping jarMapping) {
        this(remapperPreprocessor, jarMapping, null);
    }

    public BannerJarRemapper(BannerJarMapping jarMapping) {
        this.jarMapping = jarMapping;
    }

    public void setGenerateAPI(boolean generateAPI) {
        if (generateAPI) {
            this.readerFlags |= 1;
            this.copyResources = false;
        } else {
            this.readerFlags &= 0xFFFFFFFE;
            this.copyResources = true;
        }
    }

    public String map(String typeName) {
        return BannerJarRemapper.mapTypeName(typeName, this.jarMapping.packages, this.jarMapping.byNMSSrcName, typeName);
    }

    public static String mapTypeName(String typeName, Map<String, String> packageMap, Map<String, ClassMapping> classMap, String defaultIfUnmapped) {
        String mapped = BannerJarRemapper.mapClassName(typeName, packageMap, classMap);
        return mapped != null ? mapped : defaultIfUnmapped;
    }

    private static String mapClassName(String className, Map<String, String> packageMap, Map<String, ClassMapping> classMap) {
        if (classMap != null && classMap.containsKey(className)) {
            ClassMapping mapping = classMap.get(className);
            return mapping.getMcpSrcName();
        }
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String outer = className.substring(0, index);
            String mapped = BannerJarRemapper.mapClassName(outer, packageMap, classMap);
            if (mapped == null) {
                return null;
            }
            return mapped + className.substring(index);
        }
        if (packageMap != null) {
            for (String oldPackage : packageMap.keySet()) {
                if (!BannerJarRemapper.matchClassPackage(oldPackage, className)) continue;
                String newPackage = packageMap.get(oldPackage);
                return BannerJarRemapper.moveClassPackage(newPackage, BannerJarRemapper.getSimpleName(oldPackage, className));
            }
        }
        return null;
    }

    private static boolean matchClassPackage(String packageName, String className) {
        if (packageName.equals(".")) {
            return BannerJarRemapper.isDefaultPackage(className);
        }
        return className.startsWith(packageName);
    }

    private static String moveClassPackage(String packageName, String classSimpleName) {
        if (packageName.equals(".")) {
            return classSimpleName;
        }
        return packageName + classSimpleName;
    }

    private static boolean isDefaultPackage(String className) {
        return className.indexOf(47) == -1;
    }

    private static String getSimpleName(String oldPackage, String className) {
        if (oldPackage.equals(".")) {
            return className;
        }
        return className.substring(oldPackage.length());
    }

    public String mapFieldName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.fields, NodeType.FIELD, owner, name, access);
        return mapped == null ? name : mapped;
    }

    public String mapMethodName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.methods, NodeType.METHOD, owner, name + " " + desc, access);
        return mapped == null ? name : mapped;
    }

    public byte[] remapClassFile(InputStream is, ClassRepo repo) throws IOException {
        return this.remapClassFile(new ClassReader(is), repo);
    }

    public byte[] remapClassFile(byte[] in, ClassRepo repo) {
        return this.remapClassFile(new ClassReader(in), repo);
    }

    private byte[] remapClassFile(ClassReader reader, ClassRepo repo) {
        byte[] pre;
        if (this.preProcessor != null && (pre = this.preProcessor.process(reader)) != null) {
            reader = new ClassReader(pre);
        }
        ClassNode node = new ClassNode();
        RemappingClassAdapter mapper = new RemappingClassAdapter((ClassVisitor)node, (CustomRemapper)this, repo);
        reader.accept((ClassVisitor)mapper, this.readerFlags);
        ClassWriter wr = new ClassWriter(1);
        node.accept((ClassVisitor)wr);
        if (SpecialSource.identifier != null) {
            wr.newUTF8(SpecialSource.identifier);
        }
        return this.postProcessor != null ? this.postProcessor.process(wr.toByteArray()) : wr.toByteArray();
    }
}

