/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.nms.utils;

import com.mohistmc.banner.bukkit.nms.utils.RemapUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodSignature;

public class Reader3 {
    public static MappingResolver mr = FabricLoader.getInstance().getMappingResolver();

    public static void main(String[] args) throws IOException {
        BufferedReader buf = new BufferedReader(new InputStreamReader(RemapUtils.class.getClassLoader().getResourceAsStream("mappings/spigot2srg-1.20.srg")));
        List<String> lines = Reader3.readLinesStream(buf);
        ArrayList<String> outt = new ArrayList<String>();
        for (String s : lines) {
            if (s.startsWith("CL: ") || s.startsWith("FD: ")) continue;
            if (!s.contains("method_19282")) {
                // empty if block
            }
            String[] spl = s.split(" ");
            String spigotName = spl[1];
            String spigotClaz = spigotName.substring(0, spigotName.lastIndexOf(47));
            String spigotMeth = spigotName.substring(spigotName.lastIndexOf(47) + 1);
            String spigitSig = spl[2];
            String intermedName = spl[3];
            String intermedClaz = intermedName.substring(0, intermedName.lastIndexOf(47));
            String intermedMeth = intermedName.substring(intermedName.lastIndexOf(47) + 1);
            String intermedSig = spl[4];
            String check = intermedClaz + " " + spigotMeth + " " + intermedSig;
            System.out.println("CHECK: " + check);
            String obfClaz = mr.unmapClassName("official", intermedClaz.replace('/', '.'));
            String obfSig = Reader3.remapSig(intermedSig);
            String res = mr.mapMethodName("official", obfClaz, spigotMeth, obfSig);
            System.out.println("AFTER: " + res);
            outt.add(res);
            if (!s.contains("method_19282")) continue;
            break;
        }
        File dir = new File("build");
        File out = new File(dir, "mappings-genn.srg");
        System.out.println(out.toPath().toAbsolutePath().toString());
        Files.write(out.toPath(), outt, new OpenOption[0]);
    }

    public static List<String> readLinesStream(BufferedReader br) {
        ArrayList<String> lines = new ArrayList();
        lines = br.lines().collect(Collectors.toList());
        return lines;
    }

    public static List<String> readLinesStream(String filePath) {
        List<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            lines = br.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            System.err.println("Error reading file (stream): " + e.getMessage());
        }
        return lines;
    }

    public static String remapSig(String desc) {
        String imdesc = RemapUtils.remapMethodDesc(desc);
        MethodSignature sig = MethodSignature.fromDescriptor(imdesc);
        List<JavaType> jts = sig.getParameterTypes();
        Object sigg = "(";
        for (JavaType jt : jts) {
            if (jt.getDescriptor().indexOf("L") != -1 || jt.getDescriptor().indexOf("[[L") != -1) {
                String in = jt.getInternalName().replace('/', '.');
                Object ll = mr.unmapClassName("official", in);
                if (!((String)ll).contains("class_") && ((String)ll).indexOf(36) != -1) {
                    String[] spll = ((String)ll).split(Pattern.quote("$"));
                    String map_ll = RemapUtils.map(spll[0]);
                    ll = map_ll + "$" + spll[1];
                }
                sigg = (String)sigg + jt.getDescriptor().replace(jt.getInternalName(), (CharSequence)ll).replace('.', '/');
                continue;
            }
            sigg = (String)sigg + jt.getDescriptor();
        }
        sigg = (String)sigg + ")";
        JavaType jt = sig.getReturnType();
        if (jt.getDescriptor().startsWith("L") || jt.getDescriptor().contains("[[L")) {
            String in = jt.getInternalName().replace('/', '.');
            Object ll = mr.unmapClassName("official", in);
            if (!((String)ll).contains("class_") && ((String)ll).indexOf(36) != -1) {
                String[] spll = ((String)ll).split(Pattern.quote("$"));
                String map_ll = RemapUtils.map(spll[0]);
                ll = map_ll + "$" + spll[1];
            }
            sigg = (String)sigg + jt.getDescriptor().replace(jt.getInternalName(), (CharSequence)ll).replace('.', '/');
        } else {
            sigg = (String)sigg + jt.getDescriptor();
        }
        return sigg;
    }
}

