/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.isaiah.common.cmixin.IMixinMinecraftServer;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.util.Codec;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.cardboardpowered.adventure.CardboardAdventureComponent;
import org.cardboardpowered.adventure.NBTLegacyHoverEventSerializer;
import org.cardboardpowered.adventure.WrapperAwareSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PaperAdventure {
    public static final AttributeKey<Locale> LOCALE_ATTRIBUTE = AttributeKey.valueOf((String)"adventure:locale");
    private static final Pattern LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
    public static final ComponentFlattener FLATTENER = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).complexMapper(TranslatableComponent.class, (translatable, consumer) -> {
        @NonNull String translated = class_2477.method_10517().method_48307(translatable.key());
        Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
        List args = translatable.args();
        int argPosition = 0;
        int lastIdx = 0;
        while (matcher.find()) {
            int idx;
            if (lastIdx < matcher.start()) {
                consumer.accept(Component.text((String)translated.substring(lastIdx, matcher.start())));
            }
            lastIdx = matcher.end();
            @Nullable String argIdx = matcher.group(1);
            if (argIdx != null) {
                try {
                    idx = Integer.parseInt(argIdx) - 1;
                    if (idx >= args.size()) continue;
                    consumer.accept((Component)args.get(idx));
                }
                catch (NumberFormatException idx2) {}
                continue;
            }
            if ((idx = argPosition++) >= args.size()) continue;
            consumer.accept((Component)args.get(idx));
        }
        if (lastIdx < translated.length()) {
            consumer.accept(Component.text((String)translated.substring(lastIdx)));
        }
    }).build();
    public static final LegacyComponentSerializer LEGACY_SECTION_UXRC = LegacyComponentSerializer.builder().flattener(FLATTENER).hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    public static final PlainComponentSerializer PLAIN = (PlainComponentSerializer)PlainComponentSerializer.builder().flattener(FLATTENER).build();
    public static final GsonComponentSerializer GSON = GsonComponentSerializer.builder().legacyHoverEventSerializer((LegacyHoverEventSerializer)NBTLegacyHoverEventSerializer.INSTANCE).build();
    public static final GsonComponentSerializer COLOR_DOWNSAMPLING_GSON = GsonComponentSerializer.builder().legacyHoverEventSerializer((LegacyHoverEventSerializer)NBTLegacyHoverEventSerializer.INSTANCE).downsampleColors().build();
    private static final Codec<class_2487, String, IOException, IOException> NBT_CODEC = new Codec<class_2487, String, IOException, IOException>(){

        public @NonNull class_2487 decode(@NonNull String encoded) throws IOException {
            try {
                return class_2522.method_67315((String)encoded);
            }
            catch (CommandSyntaxException e) {
                throw new IOException(e);
            }
        }

        public @NonNull String encode(@NonNull class_2487 decoded) {
            return decoded.toString();
        }
    };
    public static final ComponentSerializer<Component, Component, class_2561> WRAPPER_AWARE_SERIALIZER = new WrapperAwareSerializer(() -> CraftRegistry.getMinecraftRegistry().method_57093((DynamicOps)JavaOps.INSTANCE));

    public static class_2960 asVanilla(Key key) {
        return class_2960.method_60655((String)key.namespace(), (String)key.value());
    }

    public static class_2960 asVanillaNullable(Key key) {
        if (key == null) {
            return null;
        }
        return class_2960.method_60655((String)key.namespace(), (String)key.value());
    }

    public static Component asAdventure(class_2561 component) {
        return component == null ? Component.empty() : WRAPPER_AWARE_SERIALIZER.deserialize((Object)component);
    }

    public static ArrayList<Component> asAdventure(List<class_2561> vanillas) {
        ArrayList<Component> adventures = new ArrayList<Component>(vanillas.size());
        for (class_2561 vanilla : vanillas) {
            adventures.add(PaperAdventure.asAdventure(vanilla));
        }
        return adventures;
    }

    public static ArrayList<Component> asAdventureFromJson(List<String> jsonStrings) {
        ArrayList<Component> adventures = new ArrayList<Component>(jsonStrings.size());
        for (String json : jsonStrings) {
            adventures.add(GsonComponentSerializer.gson().deserialize((Object)json));
        }
        return adventures;
    }

    public static List<String> asJson(List<Component> adventures) {
        ArrayList<String> jsons = new ArrayList<String>(adventures.size());
        for (Component component : adventures) {
            jsons.add((String)GsonComponentSerializer.gson().serialize(component));
        }
        return jsons;
    }

    public static class_2561 asVanilla(Component component) {
        return new CardboardAdventureComponent(component);
    }

    public static List<class_2561> asVanilla(List<Component> adventures) {
        ArrayList<class_2561> vanillas = new ArrayList<class_2561>(adventures.size());
        for (Component adventure : adventures) {
            vanillas.add(PaperAdventure.asVanilla(adventure));
        }
        return vanillas;
    }

    public static String asJsonString(Component component, Locale locale) {
        return (String)GSON.serialize(GlobalTranslator.render((Component)component, (Locale)(locale != null ? locale : Locale.US)));
    }

    public static String asJsonString(class_2561 component, Locale locale) {
        if (component instanceof CardboardAdventureComponent) {
            return PaperAdventure.asJsonString(((CardboardAdventureComponent)component).adventure, locale);
        }
        return ((IMixinMinecraftServer)CraftServer.server).IC$to_json(component);
    }

    public static String superHackyLegacyRepresentationOfComponent(Component component, String string) {
        return LEGACY_SECTION_UXRC.serialize(component) + ChatColor.getLastColors((String)string);
    }

    public static class_1259.class_1260 asVanilla(BossBar.Color color) {
        if (color == BossBar.Color.PINK) {
            return class_1259.class_1260.field_5788;
        }
        if (color == BossBar.Color.BLUE) {
            return class_1259.class_1260.field_5780;
        }
        if (color == BossBar.Color.RED) {
            return class_1259.class_1260.field_5784;
        }
        if (color == BossBar.Color.GREEN) {
            return class_1259.class_1260.field_5785;
        }
        if (color == BossBar.Color.YELLOW) {
            return class_1259.class_1260.field_5782;
        }
        if (color == BossBar.Color.PURPLE) {
            return class_1259.class_1260.field_5783;
        }
        if (color == BossBar.Color.WHITE) {
            return class_1259.class_1260.field_5786;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static BossBar.Color asAdventure(class_1259.class_1260 color) {
        if (color == class_1259.class_1260.field_5788) {
            return BossBar.Color.PINK;
        }
        if (color == class_1259.class_1260.field_5780) {
            return BossBar.Color.BLUE;
        }
        if (color == class_1259.class_1260.field_5784) {
            return BossBar.Color.RED;
        }
        if (color == class_1259.class_1260.field_5785) {
            return BossBar.Color.GREEN;
        }
        if (color == class_1259.class_1260.field_5782) {
            return BossBar.Color.YELLOW;
        }
        if (color == class_1259.class_1260.field_5783) {
            return BossBar.Color.PURPLE;
        }
        if (color == class_1259.class_1260.field_5786) {
            return BossBar.Color.WHITE;
        }
        throw new IllegalArgumentException(color.name());
    }

    public static class_1259.class_1261 asVanilla(BossBar.Overlay overlay) {
        if (overlay == BossBar.Overlay.PROGRESS) {
            return class_1259.class_1261.field_5795;
        }
        if (overlay == BossBar.Overlay.NOTCHED_6) {
            return class_1259.class_1261.field_5796;
        }
        if (overlay == BossBar.Overlay.NOTCHED_10) {
            return class_1259.class_1261.field_5791;
        }
        if (overlay == BossBar.Overlay.NOTCHED_12) {
            return class_1259.class_1261.field_5793;
        }
        if (overlay == BossBar.Overlay.NOTCHED_20) {
            return class_1259.class_1261.field_5790;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static BossBar.Overlay asAdventure(class_1259.class_1261 overlay) {
        if (overlay == class_1259.class_1261.field_5795) {
            return BossBar.Overlay.PROGRESS;
        }
        if (overlay == class_1259.class_1261.field_5796) {
            return BossBar.Overlay.NOTCHED_6;
        }
        if (overlay == class_1259.class_1261.field_5791) {
            return BossBar.Overlay.NOTCHED_10;
        }
        if (overlay == class_1259.class_1261.field_5793) {
            return BossBar.Overlay.NOTCHED_12;
        }
        if (overlay == class_1259.class_1261.field_5790) {
            return BossBar.Overlay.NOTCHED_20;
        }
        throw new IllegalArgumentException(overlay.name());
    }

    public static void setFlag(BossBar bar, BossBar.Flag flag, boolean value) {
        if (value) {
            bar.addFlag(flag);
        } else {
            bar.removeFlag(flag);
        }
    }

    public static class_1799 asItemStack(Book book, Locale locale) {
        class_1799 item = new class_1799((class_1935)class_1802.field_8360, 1);
        item.method_57379(class_9334.field_49606, (Object)new class_9302(class_9262.method_57137((Object)PaperAdventure.validateField(PaperAdventure.asPlain(book.title(), locale), 32, "title")), PaperAdventure.asPlain(book.author(), locale), 0, book.pages().stream().map(c -> class_9262.method_57137((Object)PaperAdventure.asVanilla(c))).toList(), false));
        return item;
    }

    public static String asPlain(Component component, Locale locale) {
        return PlainTextComponentSerializer.plainText().serialize(PaperAdventure.translated(component, locale));
    }

    private static Component translated(Component component, Locale locale) {
        return GlobalTranslator.render((Component)component, (Locale)(locale != null ? locale : Locale.US));
    }

    private static String validateField(String content, int length, String name) {
        int actual = content.length();
        if (actual > length) {
            throw new IllegalArgumentException("Field '" + name + "' has a maximum length of " + length + " but was passed '" + content + "', which was " + actual + " characters long.");
        }
        return content;
    }

    public static class_3419 asVanilla(Sound.Source source) {
        if (source == Sound.Source.MASTER) {
            return class_3419.field_15250;
        }
        if (source == Sound.Source.MUSIC) {
            return class_3419.field_15253;
        }
        if (source == Sound.Source.RECORD) {
            return class_3419.field_15247;
        }
        if (source == Sound.Source.WEATHER) {
            return class_3419.field_15252;
        }
        if (source == Sound.Source.BLOCK) {
            return class_3419.field_15245;
        }
        if (source == Sound.Source.HOSTILE) {
            return class_3419.field_15251;
        }
        if (source == Sound.Source.NEUTRAL) {
            return class_3419.field_15254;
        }
        if (source == Sound.Source.PLAYER) {
            return class_3419.field_15248;
        }
        if (source == Sound.Source.AMBIENT) {
            return class_3419.field_15256;
        }
        if (source == Sound.Source.VOICE) {
            return class_3419.field_15246;
        }
        throw new IllegalArgumentException(source.name());
    }

    public static @Nullable class_3419 asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return PaperAdventure.asVanilla(source);
    }

    public static @Nullable BinaryTagHolder asBinaryTagHolder(@Nullable class_2487 tag) {
        if (tag == null) {
            return null;
        }
        try {
            return BinaryTagHolder.encode((Object)tag, NBT_CODEC);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static @NonNull TextColor asAdventure(class_124 minecraftColor) {
        if (minecraftColor.method_532() == null) {
            throw new IllegalArgumentException("Not a valid color");
        }
        return TextColor.color((int)minecraftColor.method_532());
    }

    public static @Nullable class_124 asVanilla(TextColor color) {
        return class_124.method_534((int)color.value());
    }

    public static class_2561 asVanillaNullToEmpty(Component component) {
        if (component == null) {
            return class_5244.field_39003;
        }
        return PaperAdventure.asVanilla(component);
    }

    public static Key asAdventure(class_2960 key) {
        return Key.key((String)key.method_12836(), (String)key.method_12832());
    }

    public static Key asAdventureKey(class_5321<?> key) {
        return PaperAdventure.asAdventure(key.method_29177());
    }

    public static class_6880<class_3414> resolveSound(Key key) {
        class_2960 id = PaperAdventure.asVanilla(key);
        Optional vanilla = class_7923.field_41172.method_10223(id);
        if (vanilla.isPresent()) {
            return (class_6880)vanilla.get();
        }
        return class_6880.method_40223((Object)class_3414.method_47908((class_2960)id));
    }

    public static <T> class_5321<T> asVanilla(class_5321<? extends class_2378<T>> registry, Key key) {
        return class_5321.method_29179(registry, (class_2960)PaperAdventure.asVanilla(key));
    }
}

