/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.google.common.base.Preconditions;
import io.papermc.paper.connection.ReadablePlayerCookieConnection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_9088;
import net.minecraft.class_9091;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class ReadablePlayerCookieConnectionImpl
implements ReadablePlayerCookieConnection {
    private final Map<class_2960, CookieFuture> requestedCookies = new ConcurrentHashMap<class_2960, CookieFuture>();
    private final class_2535 connection;

    public ReadablePlayerCookieConnectionImpl(class_2535 connection) {
        this.connection = connection;
    }

    public CompletableFuture<byte[]> retrieveCookie(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        class_2960 resourceLocation = CraftNamespacedKey.toMinecraft(key);
        this.requestedCookies.put(resourceLocation, new CookieFuture(resourceLocation, future));
        this.connection.method_10743((class_2596)new class_9088(resourceLocation));
        return future;
    }

    public boolean canStoreCookie() {
        return true;
    }

    public boolean handleCookieResponse(class_9091 packet) {
        CookieFuture future = this.requestedCookies.get(packet.comp_2195());
        if (future != null) {
            future.future().complete(packet.comp_2196());
            this.requestedCookies.remove(packet.comp_2195());
            return true;
        }
        return false;
    }

    public boolean isAwaitingCookies() {
        return !this.requestedCookies.isEmpty();
    }

    public record CookieFuture(class_2960 key, CompletableFuture<byte[]> future) {
    }
}

