/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.BlocksAttacks;
import io.papermc.paper.datacomponent.item.blocksattacks.DamageReduction;
import io.papermc.paper.datacomponent.item.blocksattacks.ItemDamageFunction;
import io.papermc.paper.datacomponent.item.blocksattacks.PaperDamageReduction;
import io.papermc.paper.datacomponent.item.blocksattacks.PaperItemDamageFunction;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.tag.TagKey;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.class_10707;
import net.minecraft.class_3414;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.damage.DamageType;
import org.jspecify.annotations.Nullable;

public record PaperBlocksAttacks(class_10707 impl) implements BlocksAttacks,
Handleable<class_10707>
{
    @Override
    public class_10707 getHandle() {
        return this.impl;
    }

    public float blockDelaySeconds() {
        return this.impl.comp_3586();
    }

    public float disableCooldownScale() {
        return this.impl.comp_3587();
    }

    public List<DamageReduction> damageReductions() {
        return this.impl.comp_3588().stream().map(PaperDamageReduction::new).map(paperDamageReduction -> paperDamageReduction).toList();
    }

    public ItemDamageFunction itemDamage() {
        return new PaperItemDamageFunction(this.impl.comp_3589());
    }

    public @Nullable TagKey<DamageType> bypassedBy() {
        Optional<TagKey> tagKey = this.impl.comp_3637().map(PaperRegistries::fromNms);
        return tagKey.orElse(null);
    }

    public @Nullable Key blockSound() {
        return this.impl.comp_3590().map(holder -> PaperAdventure.asAdventure(((class_3414)holder.comp_349()).comp_3319())).orElse(null);
    }

    public @Nullable Key disableSound() {
        return this.impl.comp_3591().map(holder -> PaperAdventure.asAdventure(((class_3414)holder.comp_349()).comp_3319())).orElse(null);
    }

    static final class BuilderImpl
    implements BlocksAttacks.Builder {
        private float blockDelaySeconds;
        private float disableCooldownScale = 1.0f;
        private List<DamageReduction> damageReductions = new ObjectArrayList();
        private ItemDamageFunction itemDamage = new PaperItemDamageFunction(class_10707.class_10709.field_56308);
        private @Nullable TagKey<DamageType> bypassedBy;
        private @Nullable Key blockSound;
        private @Nullable Key disableSound;

        BuilderImpl() {
        }

        public BlocksAttacks.Builder blockDelaySeconds(float delay) {
            Preconditions.checkArgument((delay >= 0.0f ? 1 : 0) != 0, (String)"delay must be non-negative, was %s", (Object)Float.valueOf(delay));
            this.blockDelaySeconds = delay;
            return this;
        }

        public BlocksAttacks.Builder disableCooldownScale(float scale) {
            Preconditions.checkArgument((scale >= 0.0f ? 1 : 0) != 0, (String)"scale must be non-negative, was %s", (Object)Float.valueOf(scale));
            this.disableCooldownScale = scale;
            return this;
        }

        public BlocksAttacks.Builder addDamageReduction(DamageReduction reduction) {
            this.damageReductions.add(reduction);
            return this;
        }

        public BlocksAttacks.Builder damageReductions(List<DamageReduction> reductions) {
            this.damageReductions = new ObjectArrayList(reductions);
            return this;
        }

        public BlocksAttacks.Builder itemDamage(ItemDamageFunction function) {
            this.itemDamage = function;
            return this;
        }

        public BlocksAttacks.Builder bypassedBy(@Nullable TagKey<DamageType> bypassedBy) {
            this.bypassedBy = bypassedBy;
            return this;
        }

        public BlocksAttacks.Builder blockSound(@Nullable Key sound) {
            this.blockSound = sound;
            return this;
        }

        public BlocksAttacks.Builder disableSound(@Nullable Key sound) {
            this.disableSound = sound;
            return this;
        }

        public BlocksAttacks build() {
            return new PaperBlocksAttacks(new class_10707(this.blockDelaySeconds, this.disableCooldownScale, this.damageReductions.stream().map(damageReduction -> ((PaperDamageReduction)damageReduction).getHandle()).toList(), ((PaperItemDamageFunction)this.itemDamage).getHandle(), Optional.ofNullable(this.bypassedBy).map(PaperRegistries::toNms), Optional.ofNullable(this.blockSound).map(PaperAdventure::resolveSound), Optional.ofNullable(this.disableSound).map(PaperAdventure::resolveSound)));
        }
    }
}

