/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import io.papermc.paper.datacomponent.item.consumable.PaperConsumableEffects;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.minecraft.class_10124;
import net.minecraft.class_10134;
import net.minecraft.class_1839;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import org.bukkit.craftbukkit.util.Handleable;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.Unmodifiable;

public record PaperConsumable(class_10124 impl) implements Consumable,
Handleable<class_10124>
{
    private static final ItemUseAnimation[] VALUES = ItemUseAnimation.values();

    @Override
    public class_10124 getHandle() {
        return this.impl;
    }

    public @NonNegative float consumeSeconds() {
        return this.impl.comp_3085();
    }

    public ItemUseAnimation animation() {
        return VALUES[this.impl.comp_3086().ordinal()];
    }

    public Key sound() {
        return PaperAdventure.asAdventure(((class_3414)this.impl.comp_3087().comp_349()).comp_3319());
    }

    public boolean hasConsumeParticles() {
        return this.impl.comp_3088();
    }

    public @Unmodifiable List<ConsumeEffect> consumeEffects() {
        return MCUtil.transformUnmodifiable(this.impl.comp_3089(), PaperConsumableEffects::fromNms);
    }

    public Consumable.Builder toBuilder() {
        return new BuilderImpl().consumeSeconds(this.consumeSeconds()).animation(this.animation()).sound(this.sound()).addEffects(this.consumeEffects());
    }

    static final class BuilderImpl
    implements Consumable.Builder {
        private static final class_1839[] VALUES = class_1839.values();
        private float consumeSeconds = 1.6f;
        private class_1839 consumeAnimation = class_1839.field_8950;
        private class_6880<class_3414> eatSound = class_3417.field_20614;
        private boolean hasConsumeParticles = true;
        private final List<class_10134> effects = new ObjectArrayList();

        BuilderImpl() {
        }

        public Consumable.Builder consumeSeconds(@NonNegative float consumeSeconds) {
            Preconditions.checkArgument((consumeSeconds >= 0.0f ? 1 : 0) != 0, (String)"consumeSeconds must be non-negative, was %s", (Object)Float.valueOf(consumeSeconds));
            this.consumeSeconds = consumeSeconds;
            return this;
        }

        public Consumable.Builder animation(ItemUseAnimation animation) {
            this.consumeAnimation = VALUES[animation.ordinal()];
            return this;
        }

        public Consumable.Builder sound(Key sound) {
            this.eatSound = PaperAdventure.resolveSound(sound);
            return this;
        }

        public Consumable.Builder hasConsumeParticles(boolean hasConsumeParticles) {
            this.hasConsumeParticles = hasConsumeParticles;
            return this;
        }

        public Consumable.Builder addEffect(ConsumeEffect effect) {
            this.effects.add(PaperConsumableEffects.toNms(effect));
            return this;
        }

        public Consumable.Builder addEffects(List<ConsumeEffect> effects) {
            for (ConsumeEffect effect : effects) {
                this.effects.add(PaperConsumableEffects.toNms(effect));
            }
            return this;
        }

        public Consumable build() {
            return new PaperConsumable(new class_10124(this.consumeSeconds, this.consumeAnimation, this.eatSound, this.hasConsumeParticles, (List)new ObjectArrayList(this.effects)));
        }

        public Consumable.Builder effects(List<ConsumeEffect> effects) {
            this.effects.clear();
            return this.addEffects(effects);
        }
    }
}

