/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.enchantments.Enchantment;
import org.cardboardpowered.impl.CardboardEnchantment;

public record PaperItemEnchantments(class_9304 impl, Map<Enchantment, Integer> enchantments) implements ItemEnchantments,
Handleable<class_9304>
{
    public PaperItemEnchantments(class_9304 itemEnchantments) {
        this(itemEnchantments, PaperItemEnchantments.convert(itemEnchantments));
    }

    private static Map<Enchantment, Integer> convert(class_9304 itemEnchantments) {
        if (itemEnchantments.method_57543()) {
            return Collections.emptyMap();
        }
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>(itemEnchantments.method_57541());
        for (Object2IntMap.Entry entry : itemEnchantments.method_57539()) {
            map.put(CardboardEnchantment.minecraftHolderToBukkit((class_6880<class_1887>)((class_6880)entry.getKey())), entry.getIntValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public class_9304 getHandle() {
        return this.impl;
    }

    static final class BuilderImpl
    implements ItemEnchantments.Builder {
        private final Map<Enchantment, Integer> enchantments = new Object2ObjectOpenHashMap();

        BuilderImpl() {
        }

        public ItemEnchantments.Builder add(Enchantment enchantment, int level) {
            Preconditions.checkArgument((level >= 1 && level <= 255 ? 1 : 0) != 0, (String)"level must be between %s and %s, was %s", (Object)1, (Object)255, (Object)level);
            this.enchantments.put(enchantment, level);
            return this;
        }

        public ItemEnchantments.Builder addAll(Map<Enchantment, Integer> enchantments) {
            enchantments.forEach(this::add);
            return this;
        }

        public ItemEnchantments build() {
            class_9304 initialEnchantments = class_9304.field_49385;
            if (this.enchantments.isEmpty()) {
                return new PaperItemEnchantments(initialEnchantments);
            }
            class_9304.class_9305 mutable = new class_9304.class_9305(initialEnchantments);
            this.enchantments.forEach((enchantment, level) -> mutable.method_57547(CardboardEnchantment.bukkitToMinecraftHolder(enchantment), level.intValue()));
            return new PaperItemEnchantments(mutable.method_57549());
        }
    }
}

