/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_9290;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperItemLore(class_9290 impl) implements ItemLore,
Handleable<class_9290>
{
    @Override
    public class_9290 getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<Component> lines() {
        return MCUtil.transformUnmodifiable(this.impl.comp_2400(), PaperAdventure::asAdventure);
    }

    public @Unmodifiable List<Component> styledLines() {
        return MCUtil.transformUnmodifiable(this.impl.comp_2401(), PaperAdventure::asAdventure);
    }

    static final class BuilderImpl
    implements ItemLore.Builder {
        private List<Component> lines = new ObjectArrayList();

        BuilderImpl() {
        }

        private static void validateLineCount(int current, int add) {
            int newSize = current + add;
            Preconditions.checkArgument((newSize <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s lines, had %s", (int)256, (int)newSize);
        }

        public ItemLore.Builder lines(List<? extends ComponentLike> lines) {
            BuilderImpl.validateLineCount(0, lines.size());
            this.lines = new ArrayList<Component>(ComponentLike.asComponents(lines));
            return this;
        }

        public ItemLore.Builder addLine(ComponentLike line) {
            BuilderImpl.validateLineCount(this.lines.size(), 1);
            this.lines.add(line.asComponent());
            return this;
        }

        public ItemLore.Builder addLines(List<? extends ComponentLike> lines) {
            BuilderImpl.validateLineCount(this.lines.size(), lines.size());
            this.lines.addAll(ComponentLike.asComponents(lines));
            return this;
        }

        public ItemLore build() {
            if (this.lines.isEmpty()) {
                return new PaperItemLore(class_9290.field_49340);
            }
            return new PaperItemLore(new class_9290(PaperAdventure.asVanilla(this.lines)));
        }
    }
}

