/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1293;
import net.minecraft.class_1844;
import org.bukkit.Color;
import org.bukkit.craftbukkit.potion.CraftPotionType;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.cardboardpowered.impl.CardboardPotionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperPotionContents(class_1844 impl) implements PotionContents,
Handleable<class_1844>
{
    @Override
    public class_1844 getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<PotionEffect> customEffects() {
        return MCUtil.transformUnmodifiable(this.impl.comp_2380(), CardboardPotionUtil::toBukkit);
    }

    public @Nullable PotionType potion() {
        return this.impl.comp_2378().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    public @Nullable Color customColor() {
        return this.impl.comp_2379().map(Color::fromARGB).orElse(null);
    }

    public @Nullable String customName() {
        return this.impl.comp_3209().orElse(null);
    }

    public @Unmodifiable List<PotionEffect> allEffects() {
        return StreamSupport.stream(this.impl.method_57397().spliterator(), false).map(CardboardPotionUtil::toBukkit).collect(Collectors.toUnmodifiableList());
    }

    public Color computeEffectiveColor() {
        return Color.fromARGB((int)this.impl.method_8064());
    }

    static final class BuilderImpl
    implements PotionContents.Builder {
        private final List<class_1293> customEffects = new ObjectArrayList();
        private @Nullable PotionType type;
        private @Nullable Color color;
        private @Nullable String customName;

        BuilderImpl() {
        }

        public PotionContents.Builder potion(@Nullable PotionType type) {
            this.type = type;
            return this;
        }

        public PotionContents.Builder customColor(@Nullable Color color) {
            this.color = color;
            return this;
        }

        public PotionContents.Builder customName(@Nullable String name) {
            Preconditions.checkArgument((name == null || name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Custom name is longer than %s characters", (int)Short.MAX_VALUE);
            this.customName = name;
            return this;
        }

        public PotionContents.Builder addCustomEffect(PotionEffect effect) {
            this.customEffects.add(CardboardPotionUtil.fromBukkit(effect));
            return this;
        }

        public PotionContents.Builder addCustomEffects(List<PotionEffect> effects) {
            effects.forEach(this::addCustomEffect);
            return this;
        }

        public PotionContents build() {
            if (this.type == null && this.color == null && this.customEffects.isEmpty() && this.customName == null) {
                return new PaperPotionContents(class_1844.field_49274);
            }
            return new PaperPotionContents(new class_1844(Optional.ofNullable(this.type).map(CraftPotionType::bukkitToMinecraftHolder), Optional.ofNullable(this.color).map(Color::asARGB), (List)new ObjectArrayList(this.customEffects), Optional.ofNullable(this.customName)));
        }
    }
}

