/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperSimpleRegistry;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.PaperCatTypeRegistryEntry;
import io.papermc.paper.registry.data.PaperEnchantmentRegistryEntry;
import io.papermc.paper.registry.data.PaperFrogVariantRegistryEntry;
import io.papermc.paper.registry.data.PaperGameEventRegistryEntry;
import io.papermc.paper.registry.data.PaperPaintingVariantRegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryBuilder;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.CraftArt;
import org.bukkit.craftbukkit.CraftFluid;
import org.bukkit.craftbukkit.CraftGameEvent;
import org.bukkit.craftbukkit.CraftJukeboxSong;
import org.bukkit.craftbukkit.CraftMusicInstrument;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.damage.CraftDamageType;
import org.bukkit.craftbukkit.entity.CraftFrog;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.inventory.CraftMenuType;
import org.bukkit.craftbukkit.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.map.CraftMapCursor;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.cardboardpowered.impl.CardboardEnchantment;
import org.cardboardpowered.impl.entity.CardboardCat;
import org.cardboardpowered.impl.entity.CraftVillager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class PaperRegistries {
    static final List<RegistryEntry<?, ?>> REGISTRY_ENTRIES = List.of(RegistryEntryBuilder.start(class_7924.field_41273, RegistryKey.GAME_EVENT).craft(GameEvent.class, CraftGameEvent::new).writable(PaperGameEventRegistryEntry.PaperBuilder::new), RegistryEntryBuilder.start(class_7924.field_41231, RegistryKey.STRUCTURE_TYPE).craft(StructureType.class, CraftStructureType::new).build(), RegistryEntryBuilder.start(class_7924.field_41208, RegistryKey.MOB_EFFECT).craft(PotionEffectType.class, CraftPotionEffectType::new).build(), RegistryEntryBuilder.start(class_7924.field_41254, RegistryKey.BLOCK).craft(BlockType.class, CraftBlockType::new).build(), RegistryEntryBuilder.start(class_7924.field_41197, RegistryKey.ITEM).craft(ItemType.class, CraftItemType::new).build(), RegistryEntryBuilder.start(class_7924.field_41259, RegistryKey.CAT_VARIANT).craft(Cat.Type.class, CardboardCat.CraftType::new).writable(PaperCatTypeRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(class_7924.field_41272, RegistryKey.FROG_VARIANT).craft(Frog.Variant.class, CraftFrog.CraftVariant::new).writable(PaperFrogVariantRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(class_7924.field_41234, RegistryKey.VILLAGER_PROFESSION).craft(Villager.Profession.class, CraftVillager.CraftProfession::new).build(), RegistryEntryBuilder.start(class_7924.field_41235, RegistryKey.VILLAGER_TYPE).craft(Villager.Type.class, CraftVillager.CraftType::new).build(), RegistryEntryBuilder.start(class_7924.field_50082, RegistryKey.MAP_DECORATION_TYPE).craft(MapCursor.Type.class, CraftMapCursor.CraftType::new).build(), RegistryEntryBuilder.start(class_7924.field_41207, RegistryKey.MENU).craft(MenuType.class, CraftMenuType::new).build(), RegistryEntryBuilder.start(class_7924.field_41251, RegistryKey.ATTRIBUTE).craft(Attribute.class, CraftAttribute::new).build(), RegistryEntryBuilder.start(class_7924.field_41270, RegistryKey.FLUID).craft(Fluid.class, CraftFluid::new).build(), RegistryEntryBuilder.start(class_7924.field_41225, RegistryKey.SOUND_EVENT).craft(Sound.class, CraftSound::new, true).build(), RegistryEntryBuilder.start(class_7924.field_49659, RegistryKey.DATA_COMPONENT_TYPE).craft(DataComponentTypes.class, PaperDataComponentType::of).build(), RegistryEntryBuilder.start(class_7924.field_41236, RegistryKey.BIOME).craft(Biome.class, CraftBiome::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_41246, RegistryKey.STRUCTURE).craft(class_3195.class, CraftStructure::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_42083, RegistryKey.TRIM_MATERIAL).craft(TrimMaterial.class, CraftTrimMaterial::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_42082, RegistryKey.TRIM_PATTERN).craft(TrimPattern.class, CraftTrimPattern::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_42534, RegistryKey.DAMAGE_TYPE).craft(DamageType.class, CraftDamageType::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_49772, RegistryKey.WOLF_VARIANT).craft(Wolf.Variant.class, CraftWolf.CraftVariant::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_41265, RegistryKey.ENCHANTMENT).craft(class_1887.class, CardboardEnchantment::new).serializationUpdater(FieldRename.ENCHANTMENT_RENAME).writable(PaperEnchantmentRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(class_7924.field_52176, RegistryKey.JUKEBOX_SONG).craft(JukeboxSong.class, CraftJukeboxSong::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_41252, RegistryKey.BANNER_PATTERN).craft(PatternType.class, CraftPatternType::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_41209, RegistryKey.PAINTING_VARIANT).craft(Art.class, CraftArt::new).writable(PaperPaintingVariantRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(class_7924.field_41275, RegistryKey.INSTRUMENT).craft(MusicInstrument.class, CraftMusicInstrument::new).build().delayed(), RegistryEntryBuilder.start(class_7924.field_41266, RegistryKey.ENTITY_TYPE).apiOnly(PaperSimpleRegistry::entityType), RegistryEntryBuilder.start(class_7924.field_41210, RegistryKey.PARTICLE_TYPE).apiOnly(PaperSimpleRegistry::particleType), RegistryEntryBuilder.start(class_7924.field_41215, RegistryKey.POTION).apiOnly(PaperSimpleRegistry::potion), RegistryEntryBuilder.start(class_7924.field_41206, RegistryKey.MEMORY_MODULE_TYPE).apiOnly(() -> Registry.MEMORY_MODULE_TYPE));
    private static final Map<RegistryKey<?>, RegistryEntry<?, ?>> BY_REGISTRY_KEY;
    private static final Map<class_5321<?>, RegistryEntry<?, ?>> BY_RESOURCE_KEY;

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(class_5321<? extends class_2378<M>> resourceKey) {
        return BY_RESOURCE_KEY.get(resourceKey);
    }

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(RegistryKey<? super T> registryKey) {
        return BY_REGISTRY_KEY.get(registryKey);
    }

    public static <M, T> RegistryKey<T> registryFromNms(class_5321<? extends class_2378<M>> registryResourceKey) {
        return Objects.requireNonNull(BY_RESOURCE_KEY.get(registryResourceKey), String.valueOf(registryResourceKey) + " doesn't have an api RegistryKey").apiKey();
    }

    public static <M, T> class_5321<? extends class_2378<M>> registryToNms(RegistryKey<T> registryKey) {
        return Objects.requireNonNull(BY_REGISTRY_KEY.get(registryKey), String.valueOf(registryKey) + " doesn't have an mc registry ResourceKey").mcKey();
    }

    public static <M, T> TypedKey<T> fromNms(class_5321<M> resourceKey) {
        return TypedKey.create(PaperRegistries.registryFromNms(resourceKey.method_58273()), (Key)CraftNamespacedKey.fromMinecraft(resourceKey.method_29177()));
    }

    public static <M, T> class_5321<M> toNms(TypedKey<T> typedKey) {
        class_5321<class_2378<M>> key = PaperRegistries.registryToNms(typedKey.registryKey());
        return class_5321.method_29179(key, (class_2960)CardboardAdventure.asVanilla(typedKey.key()));
    }

    public static <M, T> TagKey<T> fromNms(class_6862<M> tagKey) {
        return TagKey.create(PaperRegistries.registryFromNms(tagKey.comp_326()), (Key)CraftNamespacedKey.fromMinecraft(tagKey.comp_327()));
    }

    public static <M, T> class_6862<M> toNms(TagKey<T> tagKey) {
        class_5321<class_2378<M>> key = PaperRegistries.registryToNms(tagKey.registryKey());
        return class_6862.method_40092(key, (class_2960)CardboardAdventure.asVanilla(tagKey.key()));
    }

    public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> RegistryEntryMeta.Buildable<M, T, B> getBuildableMeta(class_5321<? extends class_2378<M>> registryKey) {
        RegistryEntry<M, T> entry = PaperRegistries.getEntry(registryKey);
        if (entry == null) {
            throw new IllegalArgumentException("No registry entry for " + String.valueOf(registryKey));
        }
        RegistryEntryMeta<M, T> registryEntryMeta = entry.meta();
        if (!(registryEntryMeta instanceof RegistryEntryMeta.Buildable)) {
            throw new IllegalArgumentException("Registry entry for " + String.valueOf(registryKey) + " is not buildable");
        }
        RegistryEntryMeta.Buildable buildableMeta = (RegistryEntryMeta.Buildable)registryEntryMeta;
        return buildableMeta;
    }

    public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> RegistryEntryMeta.Buildable<M, T, B> getBuildableMeta(RegistryKey<T> registryKey) {
        RegistryEntry<M, T> entry = PaperRegistries.getEntry(registryKey);
        if (entry == null) {
            throw new IllegalArgumentException("No registry entry for " + String.valueOf(registryKey));
        }
        RegistryEntryMeta<M, T> registryEntryMeta = entry.meta();
        if (!(registryEntryMeta instanceof RegistryEntryMeta.Buildable)) {
            throw new IllegalArgumentException("Registry entry for " + String.valueOf(registryKey) + " is not buildable");
        }
        RegistryEntryMeta.Buildable buildableMeta = (RegistryEntryMeta.Buildable)registryEntryMeta;
        return buildableMeta;
    }

    private PaperRegistries() {
    }

    static {
        IdentityHashMap byRegistryKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        IdentityHashMap byResourceKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        for (RegistryEntry<?, ?> entry : REGISTRY_ENTRIES) {
            byRegistryKey.put(entry.apiKey(), entry);
            byResourceKey.put(entry.mcKey(), entry);
        }
        BY_REGISTRY_KEY = Collections.unmodifiableMap(byRegistryKey);
        BY_RESOURCE_KEY = Collections.unmodifiableMap(byResourceKey);
    }
}

