/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.DamageTypeRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.class_8107;
import net.minecraft.class_8108;
import net.minecraft.class_8110;
import net.minecraft.class_8112;
import org.bukkit.craftbukkit.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.damage.CraftDamageType;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageType;
import org.bukkit.damage.DeathMessageType;
import org.jspecify.annotations.Nullable;

public class PaperDamageTypeRegistryEntry
implements DamageTypeRegistryEntry {
    protected @Nullable String messageId;
    protected @Nullable Float exhaustion;
    protected @Nullable class_8108 damageScaling;
    protected class_8107 damageEffects = class_8107.field_42275;
    protected class_8112 deathMessageType = class_8112.field_42361;
    protected final Conversions conversions;

    public PaperDamageTypeRegistryEntry(Conversions conversions, @Nullable class_8110 internal) {
        this.conversions = conversions;
        if (internal == null) {
            return;
        }
        this.messageId = internal.comp_1242();
        this.exhaustion = Float.valueOf(internal.comp_1244());
        this.damageScaling = internal.comp_1243();
        this.damageEffects = internal.comp_1245();
        this.deathMessageType = internal.comp_1246();
    }

    public String messageId() {
        return Checks.asConfigured(this.messageId, "messsageId");
    }

    public float exhaustion() {
        return Checks.asConfigured(this.exhaustion, "exhaustion").floatValue();
    }

    public DamageScaling damageScaling() {
        return CraftDamageType.damageScalingToBukkit(Checks.asConfigured(this.damageScaling, "damageScaling"));
    }

    public DamageEffect damageEffect() {
        return CraftDamageEffect.toBukkit(this.damageEffects);
    }

    public DeathMessageType deathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(this.deathMessageType);
    }

    public static final class PaperBuilder
    extends PaperDamageTypeRegistryEntry
    implements DamageTypeRegistryEntry.Builder,
    PaperRegistryBuilder<class_8110, DamageType> {
        public PaperBuilder(Conversions conversions, @Nullable class_8110 internal) {
            super(conversions, internal);
        }

        public DamageTypeRegistryEntry.Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public DamageTypeRegistryEntry.Builder exhaustion(float exhaustion) {
            this.exhaustion = Float.valueOf(exhaustion);
            return this;
        }

        public DamageTypeRegistryEntry.Builder damageScaling(DamageScaling scaling) {
            this.damageScaling = CraftDamageType.damageScalingToNMS(scaling);
            return this;
        }

        public DamageTypeRegistryEntry.Builder damageEffect(DamageEffect effect) {
            this.damageEffects = ((CraftDamageEffect)effect).getHandle();
            return this;
        }

        public DamageTypeRegistryEntry.Builder deathMessageType(DeathMessageType deathMessageType) {
            this.deathMessageType = CraftDamageType.deathMessageTypeToNMS(deathMessageType);
            return this;
        }

        @Override
        public class_8110 build() {
            return new class_8110(Checks.asConfigured(this.messageId, "messsageId"), Checks.asConfigured(this.damageScaling, "scaling"), Checks.asConfigured(this.exhaustion, "exhaustion").floatValue(), this.damageEffects, this.deathMessageType);
        }
    }
}

