/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.PaintingVariantRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.Optional;
import java.util.OptionalInt;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1535;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.bukkit.Art;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public class PaperPaintingVariantRegistryEntry
implements PaintingVariantRegistryEntry {
    protected OptionalInt width = OptionalInt.empty();
    protected OptionalInt height = OptionalInt.empty();
    protected @Nullable class_2561 title;
    protected @Nullable class_2561 author;
    protected @Nullable class_2960 assetId;
    protected final Conversions conversions;

    public PaperPaintingVariantRegistryEntry(Conversions conversions, @Nullable class_1535 internal) {
        this.conversions = conversions;
        if (internal == null) {
            return;
        }
        this.width = OptionalInt.of(internal.comp_2670());
        this.height = OptionalInt.of(internal.comp_2671());
        this.title = internal.comp_2918().orElse(null);
        this.author = internal.comp_2919().orElse(null);
        this.assetId = internal.comp_2672();
    }

    public @Range(from=1L, to=16L) int width() {
        return Checks.asConfigured(this.width, "width");
    }

    public @Range(from=1L, to=16L) int height() {
        return Checks.asConfigured(this.height, "height");
    }

    public @Nullable Component title() {
        return this.title == null ? null : this.conversions.asAdventure(this.title);
    }

    public @Nullable Component author() {
        return this.author == null ? null : this.conversions.asAdventure(this.author);
    }

    public Key assetId() {
        return CardboardAdventure.asAdventure(Checks.asConfigured(this.assetId, "assetId"));
    }

    public static final class PaperBuilder
    extends PaperPaintingVariantRegistryEntry
    implements PaintingVariantRegistryEntry.Builder,
    PaperRegistryBuilder<class_1535, Art> {
        public PaperBuilder(Conversions conversions, @Nullable class_1535 internal) {
            super(conversions, internal);
        }

        public PaintingVariantRegistryEntry.Builder width(@Range(from=1L, to=16L) int width) {
            this.width = OptionalInt.of(Checks.asArgumentRange(width, "width", 1, 16));
            return this;
        }

        public PaintingVariantRegistryEntry.Builder height(@Range(from=1L, to=16L) int height) {
            this.height = OptionalInt.of(Checks.asArgumentRange(height, "height", 1, 16));
            return this;
        }

        public PaintingVariantRegistryEntry.Builder title(@Nullable Component title) {
            this.title = this.conversions.asVanilla(title);
            return this;
        }

        public PaintingVariantRegistryEntry.Builder author(@Nullable Component author) {
            this.author = this.conversions.asVanilla(author);
            return this;
        }

        public PaintingVariantRegistryEntry.Builder assetId(Key assetId) {
            this.assetId = CardboardAdventure.asVanilla(Checks.asArgument(assetId, "assetId"));
            return this;
        }

        @Override
        public class_1535 build() {
            return new class_1535(this.width(), this.height(), Checks.asConfigured(this.assetId, "assetId"), Optional.ofNullable(this.title), Optional.ofNullable(this.author));
        }
    }
}

