/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryImpl;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.entry.RegistryTypeMapper;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.util.ApiVersion;

public class RegistryEntryBuilder<M, A extends Keyed> {
    protected final class_5321<? extends class_2378<M>> mcKey;
    protected final RegistryKey<A> apiKey;

    public static <M, A extends Keyed> RegistryEntryBuilder<M, A> start(class_5321<? extends class_2378<M>> mcKey, RegistryKey<A> apiKey) {
        return new RegistryEntryBuilder<M, A>(mcKey, apiKey);
    }

    private RegistryEntryBuilder(class_5321<? extends class_2378<M>> mcKey, RegistryKey<A> apiKey) {
        this.mcKey = mcKey;
        this.apiKey = apiKey;
    }

    public RegistryEntry<M, A> apiOnly(Supplier<Registry<A>> apiRegistrySupplier) {
        return new RegistryEntryImpl(new RegistryEntryMeta.ApiOnly(this.mcKey, this.apiKey, apiRegistrySupplier));
    }

    public CraftStage<M, A> craft(Class<?> classToPreload, BiFunction<? super NamespacedKey, M, ? extends A> minecraftToBukkit) {
        return new CraftStage<M, A>(this.mcKey, this.apiKey, classToPreload, new RegistryTypeMapper<M, A>(minecraftToBukkit));
    }

    public CraftStage<M, A> craft(Class<?> classToPreload, Function<class_6880<M>, ? extends A> minecraftToBukkit) {
        return this.craft(classToPreload, minecraftToBukkit, false);
    }

    public CraftStage<M, A> craft(Class<?> classToPreload, Function<class_6880<M>, ? extends A> minecraftToBukkit, boolean allowDirect) {
        return new CraftStage<M, A>(this.mcKey, this.apiKey, classToPreload, new RegistryTypeMapper<M, A>(minecraftToBukkit, allowDirect));
    }

    public static final class CraftStage<M, A extends Keyed>
    extends RegistryEntryBuilder<M, A> {
        private static final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> EMPTY = (namespacedKey, apiVersion) -> namespacedKey;
        private final Class<?> classToPreload;
        private final RegistryTypeMapper<M, A> minecraftToBukkit;
        private BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater = EMPTY;

        private CraftStage(class_5321<? extends class_2378<M>> mcKey, RegistryKey<A> apiKey, Class<?> classToPreload, RegistryTypeMapper<M, A> minecraftToBukkit) {
            super(mcKey, apiKey);
            this.classToPreload = classToPreload;
            this.minecraftToBukkit = minecraftToBukkit;
        }

        public CraftStage<M, A> serializationUpdater(BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) {
            this.serializationUpdater = serializationUpdater;
            return this;
        }

        public RegistryEntry<M, A> build() {
            return new RegistryEntryImpl<M, A>(new RegistryEntryMeta.Craft<M, A>(this.mcKey, this.apiKey, this.classToPreload, this.minecraftToBukkit, this.serializationUpdater));
        }

        public <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> modifiable(PaperRegistryBuilder.Filler<M, A, B> filler) {
            return this.create(filler, RegistryEntryMeta.RegistryModificationApiSupport.MODIFIABLE);
        }

        public <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> addable(PaperRegistryBuilder.Filler<M, A, B> filler) {
            return this.create(filler, RegistryEntryMeta.RegistryModificationApiSupport.ADDABLE);
        }

        public <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> writable(PaperRegistryBuilder.Filler<M, A, B> filler) {
            return this.create(filler, RegistryEntryMeta.RegistryModificationApiSupport.WRITABLE);
        }

        private <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> create(PaperRegistryBuilder.Filler<M, A, B> filler, RegistryEntryMeta.RegistryModificationApiSupport support) {
            return new RegistryEntryImpl(new RegistryEntryMeta.Buildable<M, A, B>(this.mcKey, this.apiKey, this.classToPreload, this.minecraftToBukkit, this.serializationUpdater, filler, support));
        }
    }
}

