/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.papermc.paper.math.BlockPosition;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Position;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.isaiah.common.ICommonMod;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.Waitable;

public final class MCUtil {
    public static final Executor MAIN_EXECUTOR = run -> {
        if (!MCUtil.isMainThread()) {
            MCUtil.MinecraftServer_getServer().execute(run);
        } else {
            run.run();
        }
    };
    public static final ExecutorService ASYNC_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("Paper Async Task Handler Thread - %1$d").build());

    public static MinecraftServer MinecraftServer_getServer() {
        return ICommonMod.getIServer().getMinecraft();
    }

    private MCUtil() {
    }

    public static List<class_1923> getSpiralOutChunks(class_2338 blockposition, int radius) {
        ArrayList list = Lists.newArrayList();
        list.add(new class_1923(blockposition.method_10263() >> 4, blockposition.method_10260() >> 4));
        for (int r = 1; r <= radius; ++r) {
            int x = -r;
            int z = r;
            while (x <= r && z > -r) {
                list.add(new class_1923(blockposition.method_10263() + (x << 4) >> 4, blockposition.method_10260() + (z << 4) >> 4));
                list.add(new class_1923(blockposition.method_10263() - (x << 4) >> 4, blockposition.method_10260() - (z << 4) >> 4));
                if (x < r) {
                    ++x;
                    continue;
                }
                --z;
            }
        }
        return list;
    }

    public static <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r -> r, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, Consumer<T> consumer) {
        future.thenAcceptAsync((Consumer)consumer, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, BiConsumer<T, Throwable> consumer) {
        future.whenCompleteAsync((BiConsumer)consumer, MAIN_EXECUTOR);
    }

    public static boolean isMainThread() {
        return MCUtil.MinecraftServer_getServer().method_18854();
    }

    public static void ensureMain(Runnable run) {
        MCUtil.ensureMain(null, run);
    }

    public static void ensureMain(String reason, Runnable run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                // empty if block
            }
            MCUtil.MinecraftServer_getServer().getProcessQueue().add(run);
            return;
        }
        run.run();
    }

    public static <T> T ensureMain(Supplier<T> run) {
        return MCUtil.ensureMain(null, run);
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                // empty if block
            }
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MCUtil.MinecraftServer_getServer().getProcessQueue().add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                return null;
            }
        }
        return run.get();
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static Location toLocation(class_1937 world, double x, double y, double z) {
        return new Location((World)world.getCraftWorld(), x, y, z);
    }

    public static Location toLocation(class_1937 world, class_2338 pos) {
        return new Location((World)world.getCraftWorld(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_2338 toBlockPosition(Location loc) {
        return new class_2338(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static class_2338 toBlockPos(Position pos) {
        return new class_2338(pos.blockX(), pos.blockY(), pos.blockZ());
    }

    public static FinePosition toPosition(class_243 vector) {
        return Position.fine((double)vector.field_1352, (double)vector.field_1351, (double)vector.field_1350);
    }

    public static BlockPosition toPosition(class_2382 vector) {
        return Position.block((int)vector.method_10263(), (int)vector.method_10264(), (int)vector.method_10260());
    }

    public static class_243 toVec3(Position position) {
        return new class_243(position.x(), position.y(), position.z());
    }

    public static boolean isEdgeOfChunk(class_2338 pos) {
        int modX = pos.method_10263() & 0xF;
        int modZ = pos.method_10260() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    public static void scheduleAsyncTask(Runnable run) {
        ASYNC_EXECUTOR.execute(run);
    }

    public static <T> class_5321<T> toResourceKey(class_5321<? extends class_2378<T>> registry, NamespacedKey namespacedKey) {
        return class_5321.method_29179(registry, (class_2960)CraftNamespacedKey.toMinecraft(namespacedKey));
    }

    public static NamespacedKey fromResourceKey(class_5321<?> key) {
        return CraftNamespacedKey.fromMinecraft(key.method_29177());
    }

    public static <A, M> List<A> transformUnmodifiable(List<? extends M> nms, Function<? super M, ? extends A> converter) {
        return Collections.unmodifiableList(Lists.transform(nms, converter::apply));
    }

    public static <A, M> Collection<A> transformUnmodifiable(Collection<? extends M> nms, Function<? super M, ? extends A> converter) {
        return Collections.unmodifiableCollection(Collections2.transform(nms, converter::apply));
    }

    public static <A, M, C extends Collection<M>> void addAndConvert(C target, Collection<A> toAdd, Function<? super A, ? extends M> converter) {
        for (A value : toAdd) {
            target.add(converter.apply(value));
        }
    }
}

